/*
 * Decompiled with CFR 0.152.
 */
package wsi.survey.util;

import android.content.Context;
import android.graphics.Camera;
import android.graphics.Matrix;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Transformation;
import android.widget.Gallery;
import android.widget.ImageView;

public class ImageGallery
extends Gallery {
    private Camera mCamera;
    private int mCoveflowCenter;
    private int mMaxRotationAngle;
    private int mMaxZoom;

    public ImageGallery(Context context) {
        super(context);
        Camera camera;
        this.mCamera = camera = new Camera();
        this.mMaxRotationAngle = 60;
        this.mMaxZoom = 65416;
        this.setStaticTransformationsEnabled(true);
    }

    public ImageGallery(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        Camera camera;
        this.mCamera = camera = new Camera();
        this.mMaxRotationAngle = 60;
        this.mMaxZoom = 65416;
        this.setStaticTransformationsEnabled(true);
    }

    public ImageGallery(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        Camera camera;
        this.mCamera = camera = new Camera();
        this.mMaxRotationAngle = 60;
        this.mMaxZoom = 65416;
        this.setStaticTransformationsEnabled(true);
    }

    private int getCenterOfCoverflow() {
        int n = this.getWidth();
        int n2 = this.getPaddingLeft();
        int n3 = n - n2;
        int n4 = this.getPaddingRight();
        int n5 = (n3 - n4) / 2;
        int n6 = this.getPaddingLeft();
        return n5 + n6;
    }

    private static int getCenterOfView(View view) {
        int n = view.getLeft();
        int n2 = view.getWidth() / 2;
        return n + n2;
    }

    private void transformImageBitmap(ImageView imageView, Transformation transformation, int n) {
        this.mCamera.save();
        Matrix matrix = transformation.getMatrix();
        int n2 = imageView.getLayoutParams().height;
        int n3 = imageView.getLayoutParams().width;
        int n4 = Math.abs(n);
        this.mCamera.translate(0.0f, 0.0f, 100.0f);
        int n5 = this.mMaxRotationAngle;
        if (n4 < n5) {
            double d = this.mMaxZoom;
            double d2 = (double)n4 * 1.5;
            float f = (float)(d + d2);
            this.mCamera.translate(0.0f, 0.0f, f);
        }
        Camera camera = this.mCamera;
        float f = n;
        camera.rotateY(f);
        this.mCamera.getMatrix(matrix);
        float f2 = -(n3 / 2);
        float f3 = -(n2 / 2);
        boolean bl = matrix.preTranslate(f2, f3);
        float f4 = n3 / 2;
        float f5 = n2 / 2;
        boolean bl2 = matrix.postTranslate(f4, f5);
        this.mCamera.restore();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean getChildStaticTransformation(View view, Transformation transformation) {
        int n;
        int n2 = ImageGallery.getCenterOfView(view);
        int n3 = view.getWidth();
        transformation.clear();
        int n4 = Transformation.TYPE_BOTH;
        transformation.setTransformationType(n4);
        int n5 = this.mCoveflowCenter;
        if (n2 == n5) {
            ImageView imageView = (ImageView)view;
            this.transformImageBitmap(imageView, transformation, 0);
            return true;
        }
        float f = this.mCoveflowCenter - n2;
        float f2 = n3;
        float f3 = f / f2;
        float f4 = this.mMaxRotationAngle;
        int n6 = (int)(f3 * f4);
        int n7 = Math.abs(n6);
        if (n7 > (n = this.mMaxRotationAngle)) {
            n6 = n6 < 0 ? -this.mMaxRotationAngle : this.mMaxRotationAngle;
        }
        ImageView imageView = (ImageView)view;
        this.transformImageBitmap(imageView, transformation, n6);
        return true;
    }

    public int getMaxRotationAngle() {
        return this.mMaxRotationAngle;
    }

    public int getMaxZoom() {
        return this.mMaxZoom;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        int n5;
        this.mCoveflowCenter = n5 = this.getCenterOfCoverflow();
        super.onSizeChanged(n, n2, n3, n4);
    }

    public void setMaxRotationAngle(int n) {
        this.mMaxRotationAngle = n;
    }

    public void setMaxZoom(int n) {
        this.mMaxZoom = n;
    }
}

