/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class MathHelper {
    private static final NumberFormat FORMAT = NumberFormat.getNumberInstance();
    public static final double NULL_VALUE = Double.MAX_VALUE;

    private MathHelper() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static double[] computeLabels(double d, double d2, int n) {
        double[] dArray;
        if (Math.abs(d - d2) < (double)1.0E-7f) {
            dArray = new double[]{d, d, 0L};
            return dArray;
        }
        double d3 = d;
        double d4 = d2;
        boolean bl = false;
        if (d3 > d4) {
            bl = true;
            double d5 = d3;
            d3 = d4;
            d4 = d5;
        }
        double d6 = Math.abs(d3 - d4);
        double d7 = n;
        double d8 = MathHelper.roundUp(d6 / d7);
        double d9 = Math.ceil(d3 / d8);
        double d10 = d8 * d9;
        double d11 = Math.floor(d4 / d8);
        double d12 = d8 * d11;
        if (bl) {
            dArray = new double[3];
            dArray[0] = d12;
            dArray[1] = d10;
            float f = 0.0f * d8;
            dArray[2] = f;
            return dArray;
        }
        dArray = new double[]{d10, d12, d8};
        return dArray;
    }

    public static double[] getDoubles(List<Double> list) {
        int n = list.size();
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            double d;
            dArray[n2] = d = list.get(n2).doubleValue();
            ++n2;
        }
        return dArray;
    }

    public static float[] getFloats(List<Float> list) {
        int n = list.size();
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            float f;
            fArray[n2] = f = list.get(n2).floatValue();
            ++n2;
        }
        return fArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Double> getLabels(double d, double d2, int n) {
        FORMAT.setMaximumFractionDigits(5);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double[] dArray = MathHelper.computeLabels(d, d2, n);
        double d3 = dArray[1];
        double d4 = dArray[0];
        double d5 = d3 - d4;
        double d6 = dArray[2];
        int n2 = (int)(d5 / d6) + 1;
        int n3 = 0;
        while (n3 < n2) {
            double d7 = dArray[0];
            double d8 = n3;
            double d9 = dArray[2];
            double d10 = d8 * d9;
            double d11 = d7 + d10;
            try {
                double d12;
                NumberFormat numberFormat = FORMAT;
                String string2 = FORMAT.format(d11);
                d11 = d12 = numberFormat.parse(string2).doubleValue();
            }
            catch (ParseException parseException) {}
            Double d13 = d11;
            boolean bl = arrayList.add(d13);
            ++n3;
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double[] minmax(List<Double> list) {
        double d;
        if (list.size() == 0) {
            return new double[2];
        }
        double d2 = d = list.get(0).doubleValue();
        int n = list.size();
        int n2 = 1;
        while (true) {
            if (n2 >= n) {
                double[] dArray = new double[]{d, d2};
                return dArray;
            }
            double d3 = list.get(n2);
            d = Math.min(d, d3);
            d2 = Math.max(d2, d3);
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static double roundUp(double d) {
        int n = (int)Math.floor(Math.log10(d));
        double d2 = -n;
        double d3 = Math.pow(10.0, d2);
        double d4 = d * d3;
        if (d4 > 5.0) {
            d4 = 0.0f;
        } else if (d4 > 2.0) {
            d4 = 0.0f;
        } else if (d4 > 1.0) {
            d4 = 0.0f;
        }
        double d5 = n;
        double d6 = Math.pow(10.0, d5);
        return d4 * d6;
    }
}

