/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.tools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.RoundChart;
import org.achartengine.chart.XYChart;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.tools.AbstractTool;
import org.achartengine.tools.PanListener;

public class Pan
extends AbstractTool {
    private boolean limitsReachedX;
    private boolean limitsReachedY;
    private List<PanListener> mPanListeners;

    public Pan(AbstractChart abstractChart) {
        super(abstractChart);
        ArrayList<PanListener> arrayList = new ArrayList<PanListener>();
        this.mPanListeners = arrayList;
        this.limitsReachedX = 0;
        this.limitsReachedY = 0;
    }

    private double getAxisRatio(double[] dArray) {
        double d = dArray[1];
        double d2 = dArray[0];
        double d3 = Math.abs(d - d2);
        double d4 = dArray[3];
        double d5 = dArray[2];
        double d6 = Math.abs(d4 - d5);
        return d3 / d6;
    }

    private void notifyPanListeners() {
        synchronized (this) {
            Iterator<PanListener> iterator = this.mPanListeners.iterator();
            while (true) {
                boolean bl;
                if (bl = iterator.hasNext()) break block5;
                break;
            }
            {
                block5: {
                    return;
                }
                iterator.next().panApplied();
                continue;
            }
        }
    }

    public void addPanListener(PanListener panListener) {
        synchronized (this) {
            boolean bl = this.mPanListeners.add(panListener);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public void apply(float f, float f2, float f3, float f4) {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        if (!(this.mChart instanceof XYChart)) {
            RoundChart roundChart = (RoundChart)this.mChart;
            int n = roundChart.getCenterX();
            int n2 = (int)(f3 - f);
            int n3 = n + n2;
            roundChart.setCenterX(n3);
            int n4 = roundChart.getCenterY();
            int n5 = (int)(f4 - f2);
            int n6 = n4 + n5;
            roundChart.setCenterY(n6);
        } else {
            int n;
            int n7 = this.mRenderer.getScalesCount();
            double[] dArray = this.mRenderer.getPanLimits();
            boolean bl5 = dArray != null && dArray.length == 4;
            XYChart xYChart = (XYChart)this.mChart;
            for (int i = 0; i < (n = n7); ++i) {
                double[] dArray2 = this.getRange(i);
                double[] dArray3 = xYChart.getCalcRange(i);
                if (this.limitsReachedX && this.limitsReachedY) {
                    double d;
                    double d2;
                    double d3 = dArray2[0];
                    double d4 = dArray2[1];
                    if (d3 == d4) {
                        double d5 = dArray3[0];
                        double d6 = dArray3[1];
                        if (d5 == d6) return;
                    }
                    if ((d2 = dArray2[2]) == (d = dArray2[3])) {
                        double d7 = dArray3[2];
                        double d8 = dArray3[3];
                        if (d7 == d8) return;
                    }
                }
                Pan pan = this;
                double[] dArray4 = dArray2;
                pan.checkRange(dArray4, i);
                float f5 = f;
                float f6 = f2;
                double[] dArray5 = xYChart.toRealPoint(f5, f6, i);
                float f7 = f3;
                float f8 = f4;
                double[] dArray6 = xYChart.toRealPoint(f7, f8, i);
                double d = dArray5[0];
                double d9 = dArray6[0];
                double d10 = d - d9;
                double d11 = dArray5[1];
                double d12 = dArray6[1];
                double d13 = d11 - d12;
                Pan pan2 = this;
                double[] dArray7 = dArray2;
                double d14 = pan2.getAxisRatio(dArray7);
                XYMultipleSeriesRenderer xYMultipleSeriesRenderer = this.mRenderer;
                if (xYChart.isVertical(xYMultipleSeriesRenderer)) {
                    double d15 = -d13 * d14;
                    double d16 = d10 / d14;
                    double d17 = d15;
                    d13 = d16;
                }
                if (this.mRenderer.isPanXEnabled()) {
                    if (dArray != null) {
                        if (bl3) {
                            double d18 = dArray[0];
                            double d19 = dArray2[0] + d10;
                            bl3 = d18 <= d19;
                        }
                        if (bl4) {
                            double d20 = dArray[1];
                            double d21 = dArray2[1] + d10;
                            bl4 = d20 >= d21;
                        }
                    }
                    if (!bl5 || bl3 && bl4) {
                        double d22 = dArray2[0] + d10;
                        double d23 = dArray2[1] + d10;
                        this.setXRange(d22, d23, i);
                        this.limitsReachedX = 0;
                    } else {
                        this.limitsReachedX = 1;
                    }
                }
                if (!this.mRenderer.isPanYEnabled()) continue;
                if (bl2 && dArray != null) {
                    double d24 = dArray[2];
                    double d25 = dArray2[2] - d13;
                    bl2 = d24 <= d25;
                }
                if (bl && dArray != null) {
                    double d26 = dArray[3];
                    double d27 = dArray2[3] - d13;
                    bl = d26 >= d27;
                }
                if (bl5 && !bl2 && !bl) {
                    this.limitsReachedY = 1;
                    continue;
                }
                if (!bl && d13 < 0.0) {
                    double d28 = dArray2[2] + d13;
                    double d29 = dArray2[3] + d13;
                    this.setYRange(d28, d29, i);
                } else if (!bl2 && d13 > 0.0) {
                    double d30 = dArray2[2] + d13;
                    double d31 = dArray2[3] + d13;
                    this.setYRange(d30, d31, i);
                } else if (bl2 && bl) {
                    double d32 = dArray2[2] + d13;
                    double d33 = dArray2[3] + d13;
                    this.setYRange(d32, d33, i);
                }
                this.limitsReachedY = 0;
            }
        }
        this.notifyPanListeners();
    }

    public void removePanListener(PanListener panListener) {
        synchronized (this) {
            boolean bl = this.mPanListeners.add(panListener);
            return;
        }
    }
}

