/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.model;

import java.io.Serializable;
import java.util.Iterator;
import java.util.SortedMap;
import org.achartengine.util.IndexXYMap;
import org.achartengine.util.XYEntry;

public class XYSeries
implements Serializable {
    private double mMaxX;
    private double mMaxY;
    private double mMinX;
    private double mMinY;
    private final int mScaleNumber;
    private String mTitle;
    private final IndexXYMap<Double, Double> mXY;

    public XYSeries(String string2) {
        this(string2, 0);
    }

    public XYSeries(String string2, int n) {
        IndexXYMap indexXYMap = new IndexXYMap();
        this.mXY = indexXYMap;
        this.mMinX = Double.MAX_VALUE;
        this.mMaxX = -1.7976931348623157E308;
        this.mMinY = Double.MAX_VALUE;
        this.mMaxY = -1.7976931348623157E308;
        this.mTitle = string2;
        this.mScaleNumber = n;
        this.initRange();
    }

    private void initRange() {
        this.mMinX = Double.MAX_VALUE;
        this.mMaxX = -1.7976931348623157E308;
        this.mMinY = Double.MAX_VALUE;
        this.mMaxY = -1.7976931348623157E308;
        int n = this.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            double d = this.getX(n2);
            double d2 = this.getY(n2);
            this.updateRange(d, d2);
            ++n2;
        }
        return;
    }

    private void updateRange(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        this.mMinX = d6 = Math.min(this.mMinX, d);
        this.mMaxX = d5 = Math.max(this.mMaxX, d);
        this.mMinY = d4 = Math.min(this.mMinY, d2);
        this.mMaxY = d3 = Math.max(this.mMaxY, d2);
    }

    public void add(double d, double d2) {
        synchronized (this) {
            IndexXYMap<Double, Double> indexXYMap = this.mXY;
            Double d3 = d;
            Double d4 = d2;
            Double d5 = indexXYMap.put(d3, d4);
            this.updateRange(d, d2);
            return;
        }
    }

    public void clear() {
        synchronized (this) {
            this.mXY.clear();
            this.initRange();
            return;
        }
    }

    public int getIndexForKey(double d) {
        IndexXYMap<Double, Double> indexXYMap = this.mXY;
        Double d2 = d;
        return indexXYMap.getIndexForKey(d2);
    }

    public int getItemCount() {
        synchronized (this) {
            int n;
            int n2 = n = this.mXY.size();
            return n2;
        }
    }

    public double getMaxX() {
        return this.mMaxX;
    }

    public double getMaxY() {
        return this.mMaxY;
    }

    public double getMinX() {
        return this.mMinX;
    }

    public double getMinY() {
        return this.mMinY;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SortedMap<Double, Double> getRange(double d, double d2, int n) {
        synchronized (this) {
            Double d3;
            IndexXYMap<Double, Double> indexXYMap;
            SortedMap sortedMap;
            IndexXYMap<Double, Double> indexXYMap2 = this.mXY;
            Double d4 = d;
            SortedMap sortedMap2 = indexXYMap2.headMap(d4);
            if (!sortedMap2.isEmpty()) {
                d = sortedMap2.lastKey();
            }
            if (!(sortedMap = (indexXYMap = this.mXY).tailMap(d3 = Double.valueOf(d2))).isEmpty()) {
                Iterator<Double> iterator = sortedMap.keySet().iterator();
                Double d5 = iterator.next();
                if (iterator.hasNext()) {
                    d2 = iterator.next();
                } else {
                    double d6;
                    double d7 = d6 = d5.doubleValue();
                    d2 += d7;
                }
            }
            IndexXYMap<Double, Double> indexXYMap3 = this.mXY;
            Double d8 = d;
            Double d9 = d2;
            SortedMap<Double, Double> sortedMap3 = indexXYMap3.subMap(d8, d9);
            return sortedMap3;
        }
    }

    public int getScaleNumber() {
        return this.mScaleNumber;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public double getX(int n) {
        synchronized (this) {
            double d;
            double d2 = d = this.mXY.getXByIndex(n).doubleValue();
            return d2;
        }
    }

    public double getY(int n) {
        synchronized (this) {
            double d;
            double d2 = d = this.mXY.getYByIndex(n).doubleValue();
            return d2;
        }
    }

    public void remove(int n) {
        synchronized (this) {
            double d;
            double d2;
            double d3;
            XYEntry<Double, Double> xYEntry = this.mXY.removeByIndex(n);
            double d4 = xYEntry.getKey();
            double d5 = xYEntry.getValue();
            double d6 = this.mMinX;
            if (d4 == d6 || d4 == (d3 = this.mMaxX) || d5 == (d2 = this.mMinY) || d5 == (d = this.mMaxY)) {
                this.initRange();
            }
            return;
        }
    }

    public void setTitle(String string2) {
        this.mTitle = string2;
    }
}

