/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import org.achartengine.chart.ClickableArea;
import org.achartengine.chart.PointStyle;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.renderer.XYSeriesRenderer;

public class ScatterChart
extends XYChart {
    private static /* synthetic */ int[] $SWITCH_TABLE$org$achartengine$chart$PointStyle;
    private static final int SHAPE_WIDTH = 10;
    private static final float SIZE = 3.0f;
    public static final String TYPE = "Scatter";
    private float size = 3.0f;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ int[] $SWITCH_TABLE$org$achartengine$chart$PointStyle() {
        int[] nArray = $SWITCH_TABLE$org$achartengine$chart$PointStyle;
        if (nArray != null) {
            return nArray;
        }
        nArray = new int[PointStyle.values().length];
        try {
            int n = PointStyle.CIRCLE.ordinal();
            nArray[n] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            int n = PointStyle.DIAMOND.ordinal();
            nArray[n] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            int n = PointStyle.POINT.ordinal();
            nArray[n] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            int n = PointStyle.SQUARE.ordinal();
            nArray[n] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            int n = PointStyle.TRIANGLE.ordinal();
            nArray[n] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            int n = PointStyle.X.ordinal();
            nArray[n] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$achartengine$chart$PointStyle = nArray;
        return nArray;
    }

    ScatterChart() {
    }

    public ScatterChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        float f;
        this.size = f = xYMultipleSeriesRenderer.getPointSize();
    }

    private void drawCircle(Canvas canvas, Paint paint, float f, float f2) {
        float f3 = this.size;
        canvas.drawCircle(f, f2, f3, paint);
    }

    private void drawDiamond(Canvas canvas, Paint paint, float[] fArray, float f, float f2) {
        float f3;
        float f4;
        float f5;
        float f6;
        fArray[0] = f;
        float f7 = this.size;
        fArray[1] = f6 = f2 - f7;
        float f8 = this.size;
        fArray[2] = f5 = f - f8;
        fArray[3] = f2;
        fArray[4] = f;
        fArray[5] = f4 = this.size + f2;
        fArray[6] = f3 = this.size + f;
        fArray[7] = f2;
        this.drawPath(canvas, fArray, paint, true);
    }

    private void drawSquare(Canvas canvas, Paint paint, float f, float f2) {
        float f3 = this.size;
        float f4 = f - f3;
        float f5 = this.size;
        float f6 = f2 - f5;
        float f7 = this.size;
        float f8 = f + f7;
        float f9 = this.size;
        float f10 = f2 + f9;
        Canvas canvas2 = canvas;
        Paint paint2 = paint;
        canvas2.drawRect(f4, f6, f8, f10, paint2);
    }

    private void drawTriangle(Canvas canvas, Paint paint, float[] fArray, float f, float f2) {
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        fArray[0] = f;
        float f8 = this.size;
        float f9 = f2 - f8;
        float f10 = this.size / 2.0f;
        fArray[1] = f7 = f9 - f10;
        float f11 = this.size;
        fArray[2] = f6 = f - f11;
        fArray[3] = f5 = this.size + f2;
        fArray[4] = f4 = this.size + f;
        fArray[5] = f3 = fArray[3];
        this.drawPath(canvas, fArray, paint, true);
    }

    private void drawX(Canvas canvas, Paint paint, float f, float f2) {
        float f3 = this.size;
        float f4 = f - f3;
        float f5 = this.size;
        float f6 = f2 - f5;
        float f7 = this.size;
        float f8 = f + f7;
        float f9 = this.size;
        float f10 = f2 + f9;
        Canvas canvas2 = canvas;
        Paint paint2 = paint;
        canvas2.drawLine(f4, f6, f8, f10, paint2);
        float f11 = this.size;
        float f12 = f + f11;
        float f13 = this.size;
        float f14 = f2 - f13;
        float f15 = this.size;
        float f16 = f - f15;
        float f17 = this.size;
        float f18 = f2 + f17;
        Canvas canvas3 = canvas;
        Paint paint3 = paint;
        canvas3.drawLine(f12, f14, f16, f18, paint3);
    }

    @Override
    protected ClickableArea[] clickableAreasForPoints(float[] fArray, double[] dArray, float f, int n, int n2) {
        int n3 = fArray.length;
        ClickableArea[] clickableAreaArray = new ClickableArea[n3 / 2];
        int n4 = 0;
        while (n4 < n3) {
            ClickableArea clickableArea;
            int n5 = this.mRenderer.getSelectableBuffer();
            int n6 = n4 / 2;
            float f2 = fArray[n4];
            float f3 = n5;
            float f4 = f2 - f3;
            int n7 = n4 + 1;
            float f5 = fArray[n7];
            float f6 = n5;
            float f7 = f5 - f6;
            float f8 = fArray[n4];
            float f9 = n5;
            float f10 = f8 + f9;
            int n8 = n4 + 1;
            float f11 = fArray[n8];
            float f12 = n5;
            float f13 = f11 + f12;
            RectF rectF = new RectF(f4, f7, f10, f13);
            double d = dArray[n4];
            int n9 = n4 + 1;
            double d2 = dArray[n9];
            clickableAreaArray[n6] = clickableArea = new ClickableArea(rectF, d, d2);
            n4 += 2;
        }
        return clickableAreaArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f, float f2, int n, Paint paint) {
        if (((XYSeriesRenderer)simpleSeriesRenderer).isFillPoints()) {
            Paint.Style style = Paint.Style.FILL;
            paint.setStyle(style);
        } else {
            Paint.Style style = Paint.Style.STROKE;
            paint.setStyle(style);
        }
        int[] nArray = ScatterChart.$SWITCH_TABLE$org$achartengine$chart$PointStyle();
        int n2 = ((XYSeriesRenderer)simpleSeriesRenderer).getPointStyle().ordinal();
        switch (nArray[n2]) {
            case 1: {
                float f3 = f + 10.0f;
                this.drawX(canvas, paint, f3, f2);
                return;
            }
            case 2: {
                float f4 = f + 10.0f;
                this.drawCircle(canvas, paint, f4, f2);
                return;
            }
            case 3: {
                float[] fArray = new float[6];
                float f5 = f + 10.0f;
                ScatterChart scatterChart = this;
                Canvas canvas2 = canvas;
                Paint paint2 = paint;
                float f6 = f2;
                scatterChart.drawTriangle(canvas2, paint2, fArray, f5, f6);
                return;
            }
            case 4: {
                float f7 = f + 10.0f;
                this.drawSquare(canvas, paint, f7, f2);
                return;
            }
            case 5: {
                float[] fArray = new float[8];
                float f8 = f + 10.0f;
                ScatterChart scatterChart = this;
                Canvas canvas3 = canvas;
                Paint paint3 = paint;
                float f9 = f2;
                scatterChart.drawDiamond(canvas3, paint3, fArray, f8, f9);
                return;
            }
            case 6: {
                float f10 = f + 10.0f;
                canvas.drawPoint(f10, f2, paint);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] fArray, SimpleSeriesRenderer simpleSeriesRenderer, float f, int n, int n2) {
        XYSeriesRenderer xYSeriesRenderer = (XYSeriesRenderer)simpleSeriesRenderer;
        int n3 = xYSeriesRenderer.getColor();
        paint.setColor(n3);
        if (xYSeriesRenderer.isFillPoints()) {
            Paint.Style style = Paint.Style.FILL;
            paint.setStyle(style);
        } else {
            Paint.Style style = Paint.Style.STROKE;
            paint.setStyle(style);
        }
        int n4 = fArray.length;
        int[] nArray = ScatterChart.$SWITCH_TABLE$org$achartengine$chart$PointStyle();
        int n5 = xYSeriesRenderer.getPointStyle().ordinal();
        switch (nArray[n5]) {
            default: {
                return;
            }
            case 1: {
                int n6 = 0;
                while (n6 < n4) {
                    float f2 = fArray[n6];
                    int n7 = n6 + 1;
                    float f3 = fArray[n7];
                    this.drawX(canvas, paint, f2, f3);
                    n6 += 2;
                }
                return;
            }
            case 2: {
                int n8 = 0;
                while (n8 < n4) {
                    float f4 = fArray[n8];
                    int n9 = n8 + 1;
                    float f5 = fArray[n9];
                    this.drawCircle(canvas, paint, f4, f5);
                    n8 += 2;
                }
                return;
            }
            case 3: {
                float[] fArray2 = new float[6];
                int n10 = 0;
                while (n10 < n4) {
                    float f6 = fArray[n10];
                    int n11 = n10 + 1;
                    float f7 = fArray[n11];
                    ScatterChart scatterChart = this;
                    Canvas canvas2 = canvas;
                    Paint paint2 = paint;
                    scatterChart.drawTriangle(canvas2, paint2, fArray2, f6, f7);
                    n10 += 2;
                }
                return;
            }
            case 4: {
                int n12 = 0;
                while (n12 < n4) {
                    float f8 = fArray[n12];
                    int n13 = n12 + 1;
                    float f9 = fArray[n13];
                    this.drawSquare(canvas, paint, f8, f9);
                    n12 += 2;
                }
                return;
            }
            case 5: {
                float[] fArray3 = new float[8];
                int n14 = 0;
                while (n14 < n4) {
                    float f10 = fArray[n14];
                    int n15 = n14 + 1;
                    float f11 = fArray[n15];
                    ScatterChart scatterChart = this;
                    Canvas canvas3 = canvas;
                    Paint paint3 = paint;
                    scatterChart.drawDiamond(canvas3, paint3, fArray3, f10, f11);
                    n14 += 2;
                }
                return;
            }
            case 6: 
        }
        canvas.drawPoints(fArray, paint);
    }

    @Override
    public String getChartType() {
        return TYPE;
    }

    @Override
    public int getLegendShapeWidth(int n) {
        return 10;
    }

    @Override
    protected void setDatasetRenderer(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        float f;
        super.setDatasetRenderer(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        this.size = f = xYMultipleSeriesRenderer.getPointSize();
    }
}

