/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import org.achartengine.chart.BarChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

public class RangeBarChart
extends BarChart {
    public static final String TYPE = "RangeBar";

    RangeBarChart() {
    }

    public RangeBarChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, BarChart.Type type) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer, type);
    }

    @Override
    protected void drawChartValuesText(Canvas canvas, XYSeries xYSeries, SimpleSeriesRenderer simpleSeriesRenderer, Paint paint, float[] fArray, int n, int n2) {
        int n3 = this.mDataset.getSeriesCount();
        int n4 = fArray.length;
        float[] fArray2 = fArray;
        float f = this.getHalfDiffX(fArray2, n4, n3);
        int n5 = 0;
        if (n2 > 0) {
            n5 = 2;
        }
        int n6 = n5;
        int n7;
        while (n6 < (n7 = fArray.length)) {
            int n8;
            int n9;
            double d;
            int n10;
            int n11;
            int n12;
            double d2;
            int n13 = n6 / 2;
            int n14 = n2 + n13;
            float f2 = fArray[n6];
            BarChart.Type type = this.mType;
            BarChart.Type type2 = BarChart.Type.DEFAULT;
            if (type == type2) {
                float f3 = (float)(n * 2) * f;
                float f4 = ((float)n3 - 1.5f) * f;
                float f5 = f3 - f4;
                float f6 = f2 + f5;
            }
            if (!this.isNullValue(d2 = xYSeries.getY(n12 = n14 + 1)) && (n11 = fArray.length) > (n10 = n6 + 3)) {
                int n15 = n14 + 1;
                double d3 = xYSeries.getY(n15);
                String string2 = this.getLabel(d3);
                int n16 = n6 + 3;
                float f7 = fArray[n16];
                float f8 = simpleSeriesRenderer.getChartValuesSpacing();
                float f9 = f7 - f8;
                RangeBarChart rangeBarChart = this;
                Canvas canvas2 = canvas;
                Paint paint2 = paint;
                rangeBarChart.drawText(canvas2, string2, f2, f9, paint2, 0.0f);
            }
            if (!this.isNullValue(d = xYSeries.getY(n14)) && (n9 = fArray.length) > (n8 = n6 + 1)) {
                double d4 = xYSeries.getY(n14);
                String string3 = this.getLabel(d4);
                int n17 = n6 + 1;
                float f10 = fArray[n17];
                float f11 = simpleSeriesRenderer.getChartValuesTextSize();
                float f12 = f10 + f11;
                float f13 = simpleSeriesRenderer.getChartValuesSpacing();
                float f14 = f12 + f13 - 3.0f;
                RangeBarChart rangeBarChart = this;
                Canvas canvas3 = canvas;
                Paint paint3 = paint;
                rangeBarChart.drawText(canvas3, string3, f2, f14, paint3, 0.0f);
            }
            n6 += 4;
        }
        return;
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] fArray, SimpleSeriesRenderer simpleSeriesRenderer, float f, int n, int n2) {
        int n3 = this.mDataset.getSeriesCount();
        int n4 = fArray.length;
        int n5 = simpleSeriesRenderer.getColor();
        paint.setColor(n5);
        Paint.Style style = Paint.Style.FILL;
        paint.setStyle(style);
        float[] fArray2 = fArray;
        float f2 = this.getHalfDiffX(fArray2, n4, n3);
        int n6 = 0;
        if (n2 > 0) {
            n6 = 2;
        }
        int n7 = n6;
        while (true) {
            if (n7 >= n4) {
                int n8 = simpleSeriesRenderer.getColor();
                paint.setColor(n8);
                return;
            }
            int n9 = fArray.length;
            int n10 = n7 + 3;
            if (n9 > n10) {
                float f3 = fArray[n7];
                int n11 = n7 + 1;
                float f4 = fArray[n11];
                int n12 = n7 + 2;
                float f5 = fArray[n12];
                int n13 = n7 + 3;
                float f6 = fArray[n13];
                RangeBarChart rangeBarChart = this;
                Canvas canvas2 = canvas;
                int n14 = n;
                Paint paint2 = paint;
                rangeBarChart.drawBar(canvas2, f3, f4, f5, f6, f2, n3, n14, paint2);
            }
            n7 += 4;
        }
    }

    @Override
    public String getChartType() {
        return TYPE;
    }

    @Override
    protected float getCoeficient() {
        return 0x3F000000;
    }
}

