/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.achartengine.chart.PieSegment;
import org.achartengine.model.Point;
import org.achartengine.model.SeriesSelection;

public class PieMapper
implements Serializable {
    private int mCenterX;
    private int mCenterY;
    private int mPieChartRadius;
    private List<PieSegment> mPieSegmentList;

    public PieMapper() {
        ArrayList<PieSegment> arrayList = new ArrayList<PieSegment>();
        this.mPieSegmentList = arrayList;
    }

    public void addPieSegment(int n, float f, float f2, float f3) {
        List<PieSegment> list = this.mPieSegmentList;
        PieSegment pieSegment = new PieSegment(n, f, f2, f3);
        boolean bl = list.add(pieSegment);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean areAllSegmentPresent(int n) {
        if (this.mPieSegmentList.size() != n) return false;
        return true;
    }

    public void clearPieSegments() {
        this.mPieSegmentList.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getAngle(Point point) {
        float f;
        float f2 = point.getX();
        float f3 = this.mCenterX;
        double d = f2 - f3;
        float f4 = point.getY();
        double d2 = Math.atan2(-(f4 - (f = (float)this.mCenterY)), d);
        if (d2 < 0.0) {
            d2 = Math.abs(d2);
            return Math.toDegrees(d2);
        }
        d2 = Math.PI * 2 - d2;
        return Math.toDegrees(d2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SeriesSelection getSeriesAndPointForScreenCoordinate(Point point) {
        PieSegment pieSegment;
        if (!this.isOnPieChart(point)) return null;
        double d = this.getAngle(point);
        Iterator<PieSegment> iterator = this.mPieSegmentList.iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!(pieSegment = iterator.next()).isInSegment(d));
        int n = pieSegment.getDataIndex();
        double d2 = pieSegment.getValue();
        double d3 = pieSegment.getValue();
        return new SeriesSelection(0, n, d2, d3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOnPieChart(Point point) {
        int n;
        int n2;
        double d;
        float f;
        float f2;
        double d2;
        float f3 = this.mCenterX;
        float f4 = point.getX();
        double d3 = Math.pow(f3 - f4, 2.0);
        double d4 = d3 + (d2 = Math.pow((f2 = (float)this.mCenterY) - (f = point.getY()), 2.0));
        if (!(d4 <= (d = (double)((n2 = this.mPieChartRadius) * (n = this.mPieChartRadius))))) return false;
        return true;
    }

    public void setDimensions(int n, int n2, int n3) {
        this.mPieChartRadius = n;
        this.mCenterX = n2;
        this.mCenterY = n3;
    }
}

