/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import org.achartengine.chart.ClickableArea;
import org.achartengine.chart.PointStyle;
import org.achartengine.chart.ScatterChart;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.renderer.XYSeriesRenderer;

public class LineChart
extends XYChart {
    private static final int SHAPE_WIDTH = 30;
    public static final String TYPE = "Line";
    private ScatterChart pointsChart;

    LineChart() {
    }

    public LineChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        ScatterChart scatterChart;
        this.pointsChart = scatterChart = new ScatterChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
    }

    @Override
    protected ClickableArea[] clickableAreasForPoints(float[] fArray, double[] dArray, float f, int n, int n2) {
        int n3 = fArray.length;
        ClickableArea[] clickableAreaArray = new ClickableArea[n3 / 2];
        int n4 = 0;
        while (n4 < n3) {
            ClickableArea clickableArea;
            int n5 = this.mRenderer.getSelectableBuffer();
            int n6 = n4 / 2;
            float f2 = fArray[n4];
            float f3 = n5;
            float f4 = f2 - f3;
            int n7 = n4 + 1;
            float f5 = fArray[n7];
            float f6 = n5;
            float f7 = f5 - f6;
            float f8 = fArray[n4];
            float f9 = n5;
            float f10 = f8 + f9;
            int n8 = n4 + 1;
            float f11 = fArray[n8];
            float f12 = n5;
            float f13 = f11 + f12;
            RectF rectF = new RectF(f4, f7, f10, f13);
            double d = dArray[n4];
            int n9 = n4 + 1;
            double d2 = dArray[n9];
            clickableAreaArray[n6] = clickableArea = new ClickableArea(rectF, d, d2);
            n4 += 2;
        }
        return clickableAreaArray;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f, float f2, int n, Paint paint) {
        float f3 = f + 30.0f;
        Canvas canvas2 = canvas;
        float f4 = f;
        float f5 = f2;
        float f6 = f2;
        Paint paint2 = paint;
        canvas2.drawLine(f4, f5, f3, f6, paint2);
        if (this.isRenderPoints(simpleSeriesRenderer)) {
            ScatterChart scatterChart = this.pointsChart;
            float f7 = f + 5.0f;
            Canvas canvas3 = canvas;
            SimpleSeriesRenderer simpleSeriesRenderer2 = simpleSeriesRenderer;
            float f8 = f2;
            int n2 = n;
            Paint paint3 = paint;
            scatterChart.drawLegendShape(canvas3, simpleSeriesRenderer2, f7, f8, n2, paint3);
        }
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] fArray, SimpleSeriesRenderer simpleSeriesRenderer, float f, int n, int n2) {
        int n3 = fArray.length;
        XYSeriesRenderer xYSeriesRenderer = (XYSeriesRenderer)simpleSeriesRenderer;
        float f2 = paint.getStrokeWidth();
        float f3 = xYSeriesRenderer.getLineWidth();
        paint.setStrokeWidth(f3);
        if (xYSeriesRenderer.isFillBelowLine()) {
            float f4;
            float f5;
            float f6;
            float f7;
            int n4 = xYSeriesRenderer.getFillBelowLineColor();
            paint.setColor(n4);
            float[] fArray2 = new float[fArray.length + 4];
            System.arraycopy(fArray, 0, fArray2, 0, n3);
            fArray2[0] = f7 = fArray[0] + 1.0f;
            int n5 = n3 + -2;
            fArray2[n3] = f6 = fArray2[n5];
            int n6 = n3 + 1;
            fArray2[n6] = f;
            int n7 = n3 + 2;
            fArray2[n7] = f5 = fArray2[0];
            int n8 = n3 + 3;
            int n9 = n3 + 1;
            fArray2[n8] = f4 = fArray2[n9];
            Paint.Style style = Paint.Style.FILL;
            paint.setStyle(style);
            this.drawPath(canvas, fArray2, paint, true);
        }
        int n10 = simpleSeriesRenderer.getColor();
        paint.setColor(n10);
        Paint.Style style = Paint.Style.STROKE;
        paint.setStyle(style);
        this.drawPath(canvas, fArray, paint, false);
        paint.setStrokeWidth(f2);
    }

    @Override
    public String getChartType() {
        return TYPE;
    }

    @Override
    public int getLegendShapeWidth(int n) {
        return 30;
    }

    @Override
    public ScatterChart getPointsChart() {
        return this.pointsChart;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isRenderPoints(SimpleSeriesRenderer simpleSeriesRenderer) {
        PointStyle pointStyle;
        PointStyle pointStyle2 = ((XYSeriesRenderer)simpleSeriesRenderer).getPointStyle();
        if (pointStyle2 == (pointStyle = PointStyle.POINT)) return false;
        return true;
    }

    @Override
    protected void setDatasetRenderer(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        ScatterChart scatterChart;
        super.setDatasetRenderer(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        this.pointsChart = scatterChart = new ScatterChart(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
    }
}

