/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import java.util.List;
import org.achartengine.chart.BarChart;
import org.achartengine.chart.BubbleChart;
import org.achartengine.chart.ClickableArea;
import org.achartengine.chart.CubicLineChart;
import org.achartengine.chart.LineChart;
import org.achartengine.chart.RangeBarChart;
import org.achartengine.chart.ScatterChart;
import org.achartengine.chart.TimeChart;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

public class CombinedXYChart
extends XYChart {
    private XYChart[] mCharts;
    private Class[] xyChartTypes;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CombinedXYChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, String[] stringArray) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        Class[] classArray = new Class[]{TimeChart.class, LineChart.class, CubicLineChart.class, BarChart.class, BubbleChart.class, ScatterChart.class, RangeBarChart.class};
        this.xyChartTypes = classArray;
        int n = stringArray.length;
        XYChart[] xYChartArray = new XYChart[n];
        this.mCharts = xYChartArray;
        int n2 = 0;
        while (n2 < n) {
            try {
                XYChart xYChart;
                XYChart[] xYChartArray2 = this.mCharts;
                String string2 = stringArray[n2];
                xYChartArray2[n2] = xYChart = this.getXYChart(string2);
            }
            catch (Exception exception) {}
            if (this.mCharts[n2] == false) {
                StringBuilder stringBuilder = new StringBuilder("Unknown chart type ");
                String string3 = stringArray[n2];
                String string4 = stringBuilder.append(string3).toString();
                throw new IllegalArgumentException(string4);
            }
            XYMultipleSeriesDataset xYMultipleSeriesDataset2 = new XYMultipleSeriesDataset();
            XYSeries xYSeries = xYMultipleSeriesDataset.getSeriesAt(n2);
            xYMultipleSeriesDataset2.addSeries(xYSeries);
            XYMultipleSeriesRenderer xYMultipleSeriesRenderer2 = new XYMultipleSeriesRenderer();
            double d = xYMultipleSeriesRenderer.getBarSpacing();
            xYMultipleSeriesRenderer2.setBarSpacing(d);
            float f = xYMultipleSeriesRenderer.getPointSize();
            xYMultipleSeriesRenderer2.setPointSize(f);
            int n3 = xYMultipleSeriesDataset.getSeriesAt(n2).getScaleNumber();
            if (xYMultipleSeriesRenderer.isMinXSet(n3)) {
                double d2 = xYMultipleSeriesRenderer.getXAxisMin(n3);
                xYMultipleSeriesRenderer2.setXAxisMin(d2);
            }
            if (xYMultipleSeriesRenderer.isMaxXSet(n3)) {
                double d3 = xYMultipleSeriesRenderer.getXAxisMax(n3);
                xYMultipleSeriesRenderer2.setXAxisMax(d3);
            }
            if (xYMultipleSeriesRenderer.isMinYSet(n3)) {
                double d4 = xYMultipleSeriesRenderer.getYAxisMin(n3);
                xYMultipleSeriesRenderer2.setYAxisMin(d4);
            }
            if (xYMultipleSeriesRenderer.isMaxYSet(n3)) {
                double d5 = xYMultipleSeriesRenderer.getYAxisMax(n3);
                xYMultipleSeriesRenderer2.setYAxisMax(d5);
            }
            SimpleSeriesRenderer simpleSeriesRenderer = xYMultipleSeriesRenderer.getSeriesRendererAt(n2);
            xYMultipleSeriesRenderer2.addSeriesRenderer(simpleSeriesRenderer);
            this.mCharts[n2].setDatasetRenderer(xYMultipleSeriesDataset2, xYMultipleSeriesRenderer2);
            ++n2;
        }
        return;
    }

    private XYChart getXYChart(String string2) throws IllegalAccessException, InstantiationException {
        XYChart xYChart = null;
        int n = this.xyChartTypes.length;
        int n2 = 0;
        while (n2 < n && xYChart == null) {
            XYChart xYChart2 = (XYChart)this.xyChartTypes[n2].newInstance();
            String string3 = xYChart2.getChartType();
            if (string2.equals(string3)) {
                xYChart = xYChart2;
            }
            ++n2;
        }
        return xYChart;
    }

    @Override
    protected ClickableArea[] clickableAreasForPoints(float[] fArray, double[] dArray, float f, int n, int n2) {
        XYChart xYChart = this.mCharts[n];
        float[] fArray2 = fArray;
        double[] dArray2 = dArray;
        float f2 = f;
        int n3 = n2;
        return xYChart.clickableAreasForPoints(fArray2, dArray2, f2, 0, n3);
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f, float f2, int n, Paint paint) {
        XYChart xYChart = this.mCharts[n];
        Canvas canvas2 = canvas;
        SimpleSeriesRenderer simpleSeriesRenderer2 = simpleSeriesRenderer;
        float f3 = f;
        float f4 = f2;
        Paint paint2 = paint;
        xYChart.drawLegendShape(canvas2, simpleSeriesRenderer2, f3, f4, 0, paint2);
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] fArray, SimpleSeriesRenderer simpleSeriesRenderer, float f, int n, int n2) {
        XYChart xYChart = this.mCharts[n];
        Rect rect = this.getScreenR();
        xYChart.setScreenR(rect);
        XYChart xYChart2 = this.mCharts[n];
        int n3 = this.mDataset.getSeriesAt(n).getScaleNumber();
        double[] dArray = this.getCalcRange(n3);
        xYChart2.setCalcRange(dArray, 0);
        XYChart xYChart3 = this.mCharts[n];
        Canvas canvas2 = canvas;
        Paint paint2 = paint;
        float[] fArray2 = fArray;
        SimpleSeriesRenderer simpleSeriesRenderer2 = simpleSeriesRenderer;
        float f2 = f;
        int n4 = n2;
        xYChart3.drawSeries(canvas2, paint2, fArray2, simpleSeriesRenderer2, f2, 0, n4);
    }

    @Override
    protected void drawSeries(XYSeries xYSeries, Canvas canvas, Paint paint, List<Float> list, SimpleSeriesRenderer simpleSeriesRenderer, float f, int n, XYMultipleSeriesRenderer.Orientation orientation, int n2) {
        XYChart xYChart = this.mCharts[n];
        Rect rect = this.getScreenR();
        xYChart.setScreenR(rect);
        XYChart xYChart2 = this.mCharts[n];
        XYMultipleSeriesDataset xYMultipleSeriesDataset = this.mDataset;
        int n3 = n;
        int n4 = xYMultipleSeriesDataset.getSeriesAt(n3).getScaleNumber();
        double[] dArray = this.getCalcRange(n4);
        xYChart2.setCalcRange(dArray, 0);
        XYChart xYChart3 = this.mCharts[n];
        XYSeries xYSeries2 = xYSeries;
        Canvas canvas2 = canvas;
        Paint paint2 = paint;
        List<Float> list2 = list;
        SimpleSeriesRenderer simpleSeriesRenderer2 = simpleSeriesRenderer;
        float f2 = f;
        XYMultipleSeriesRenderer.Orientation orientation2 = orientation;
        int n5 = n2;
        xYChart3.drawSeries(xYSeries2, canvas2, paint2, list2, simpleSeriesRenderer2, f2, 0, orientation2, n5);
    }

    @Override
    public String getChartType() {
        return "Combined";
    }

    @Override
    public int getLegendShapeWidth(int n) {
        return this.mCharts[n].getLegendShapeWidth(0);
    }
}

