/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine;

import android.graphics.RectF;
import android.view.MotionEvent;
import org.achartengine.GraphicalView;
import org.achartengine.ITouchHandler;
import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.RoundChart;
import org.achartengine.chart.XYChart;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.tools.Pan;
import org.achartengine.tools.PanListener;
import org.achartengine.tools.Zoom;
import org.achartengine.tools.ZoomListener;

public class TouchHandler
implements ITouchHandler {
    private GraphicalView graphicalView;
    private Pan mPan;
    private Zoom mPinchZoom;
    private DefaultRenderer mRenderer;
    private float oldX;
    private float oldX2;
    private float oldY;
    private float oldY2;
    private RectF zoomR;

    /*
     * Enabled aggressive block sorting
     */
    public TouchHandler(GraphicalView graphicalView, AbstractChart abstractChart) {
        RectF rectF;
        RectF rectF2;
        this.zoomR = rectF2 = new RectF();
        this.graphicalView = graphicalView;
        this.zoomR = rectF = this.graphicalView.getZoomRectangle();
        if (abstractChart instanceof XYChart) {
            XYMultipleSeriesRenderer xYMultipleSeriesRenderer = ((XYChart)abstractChart).getRenderer();
            this.mRenderer = xYMultipleSeriesRenderer;
        } else {
            DefaultRenderer defaultRenderer;
            this.mRenderer = defaultRenderer = ((RoundChart)abstractChart).getRenderer();
        }
        if (this.mRenderer.isPanEnabled()) {
            Pan pan;
            this.mPan = pan = new Pan(abstractChart);
        }
        if (this.mRenderer.isZoomEnabled()) {
            Zoom zoom;
            this.mPinchZoom = zoom = new Zoom(abstractChart, true, 1.0f);
        }
    }

    @Override
    public void addPanListener(PanListener panListener) {
        if (this.mPan != null) {
            this.mPan.addPanListener(panListener);
        }
    }

    @Override
    public void addZoomListener(ZoomListener zoomListener) {
        if (this.mPinchZoom != null) {
            this.mPinchZoom.addZoomListener(zoomListener);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean handleTouch(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        if (this.mRenderer != null && n == 2) {
            if (this.oldX >= 0.0f || this.oldY >= 0.0f) {
                float f = motionEvent.getX(0);
                float f2 = motionEvent.getY(0);
                if (motionEvent.getPointerCount() > 1 && (this.oldX2 >= 0.0f || this.oldY2 >= 0.0f) && this.mRenderer.isZoomEnabled()) {
                    float f3;
                    float f4;
                    float f5;
                    float f6;
                    float f7;
                    float f8 = motionEvent.getX(1);
                    float f9 = motionEvent.getY(1);
                    float f10 = Math.abs(f - f8);
                    float f11 = Math.abs(f2 - f9);
                    float f12 = this.oldX;
                    float f13 = this.oldX2;
                    float f14 = Math.abs(f12 - f13);
                    float f15 = this.oldY;
                    float f16 = this.oldY2;
                    float f17 = Math.abs(f15 - f16);
                    float f18 = this.oldY;
                    float f19 = Math.abs(f2 - f18);
                    float f20 = this.oldX;
                    float f21 = Math.abs(f - f20);
                    float f22 = f19 / f21;
                    float f23 = this.oldY2;
                    float f24 = Math.abs(f9 - f23);
                    float f25 = this.oldX2;
                    float f26 = Math.abs(f8 - f25);
                    float f27 = f24 / f26;
                    if ((double)f22 <= 0.577 && (double)f27 <= 0.577) {
                        float f28 = f10 / f14;
                        if ((double)f28 > 0.909 && (double)f28 < 1.1) {
                            this.mPinchZoom.setZoomRate(f28);
                            this.mPinchZoom.apply(1);
                        }
                    } else if ((double)f22 >= 1.732 && (double)f27 >= 1.732) {
                        float f29 = f11 / f17;
                        if ((double)f29 > 0.909 && (double)f29 < 1.1) {
                            this.mPinchZoom.setZoomRate(f29);
                            this.mPinchZoom.apply(2);
                        }
                    } else if ((double)f22 > 0.577 && (double)f22 < 1.732 && (double)f27 > 0.577 && (double)f27 < 1.732 && (double)(f7 = (f6 = Math.abs(f - (f5 = this.oldX))) >= (f4 = Math.abs(f2 - (f3 = this.oldY))) ? f10 / f14 : f11 / f17) > 0.909 && (double)f7 < 1.1) {
                        this.mPinchZoom.setZoomRate(f7);
                        this.mPinchZoom.apply(0);
                    }
                    this.oldX2 = f8;
                    this.oldY2 = f9;
                } else if (this.mRenderer.isPanEnabled()) {
                    Pan pan = this.mPan;
                    float f30 = this.oldX;
                    float f31 = this.oldY;
                    pan.apply(f30, f31, f, f2);
                    this.oldX2 = 0.0f;
                    this.oldY2 = 0.0f;
                }
                this.oldX = f;
                this.oldY = f2;
                this.graphicalView.repaint();
                return true;
            }
        } else if (n == 0) {
            float f;
            float f32;
            RectF rectF;
            float f33;
            float f34;
            this.oldX = f34 = motionEvent.getX(0);
            this.oldY = f33 = motionEvent.getY(0);
            if (this.mRenderer != null && this.mRenderer.isZoomEnabled() && (rectF = this.zoomR).contains(f32 = this.oldX, f = this.oldY)) {
                float f35 = this.oldX;
                float f36 = this.zoomR.left;
                float f37 = this.zoomR.width() / 3.0f;
                float f38 = f36 + f37;
                if (f35 < f38) {
                    this.graphicalView.zoomIn();
                    return true;
                } else {
                    float f39 = this.oldX;
                    float f40 = this.zoomR.left;
                    float f41 = this.zoomR.width() * 2.0f / 3.0f;
                    float f42 = f40 + f41;
                    if (f39 < f42) {
                        this.graphicalView.zoomOut();
                        return true;
                    } else {
                        this.graphicalView.zoomReset();
                    }
                }
                return true;
            }
        } else if (n == 1 || n == 6) {
            this.oldX = 0.0f;
            this.oldY = 0.0f;
            this.oldX2 = 0.0f;
            this.oldY2 = 0.0f;
            if (n == 6) {
                this.oldX = -1.0f;
                this.oldY = -1.0f;
            }
        }
        if (!this.mRenderer.isClickEnabled()) return true;
        return false;
    }

    @Override
    public void removePanListener(PanListener panListener) {
        if (this.mPan != null) {
            this.mPan.removePanListener(panListener);
        }
    }

    @Override
    public void removeZoomListener(ZoomListener zoomListener) {
        if (this.mPinchZoom != null) {
            this.mPinchZoom.removeZoomListener(zoomListener);
        }
    }
}

