/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir;

import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import java.util.Map;
import org.objectweb.asm.Type;

public class Trap {
    public LabelStmt start;
    public LabelStmt end;
    public LabelStmt[] handlers;
    public Type[] types;

    public Trap() {
    }

    public Trap(LabelStmt start, LabelStmt end, LabelStmt[] handlers, Type[] types) {
        this.start = start;
        this.end = end;
        this.handlers = handlers;
        this.types = types;
    }

    public Trap clone(Map<LabelStmt, LabelStmt> map) {
        int size = this.handlers.length;
        LabelStmt[] cloneHandlers = new LabelStmt[size];
        Type[] cloneTypes = new Type[size];
        int i = 0;
        while (i < size) {
            cloneHandlers[i] = this.handlers[i].clone((Map)map);
            cloneTypes[i] = this.types[i];
            ++i;
        }
        return new Trap((LabelStmt)this.start.clone((Map)map), (LabelStmt)this.end.clone((Map)map), cloneHandlers, cloneTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(String.format(".catch %s - %s : ", this.start.getDisplayName(), this.end.getDisplayName()));
        int i = 0;
        while (i < this.handlers.length) {
            sb.append((Object)(this.types[i] == null ? "all" : this.types[i])).append(" > ").append(this.handlers[i].getDisplayName()).append(",");
            ++i;
        }
        return sb.toString();
    }
}

