/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.sequence.SequenceModel;

public class SingleByteCharsetProber
extends CharsetProber {
    public static final int NEGATIVE_CAT = 0;
    public static final float NEGATIVE_SHORTCUT_THRESHOLD = 0.05f;
    public static final int NUMBER_OF_SEQ_CAT = 4;
    public static final int POSITIVE_CAT = 3;
    public static final float POSITIVE_SHORTCUT_THRESHOLD = 0.95f;
    public static final int SAMPLE_SIZE = 64;
    public static final int SB_ENOUGH_REL_THRESHOLD = 1024;
    public static final int SYMBOL_CAT_ORDER = 250;
    private int freqChar;
    private short lastOrder;
    private SequenceModel model;
    private CharsetProber nameProber;
    private boolean reversed;
    private int[] seqCounters;
    private CharsetProber.ProbingState state;
    private int totalChar;
    private int totalSeqs;

    public SingleByteCharsetProber(SequenceModel sequenceModel) {
        this.model = sequenceModel;
        this.reversed = false;
        this.nameProber = null;
        this.seqCounters = new int[4];
        this.reset();
    }

    public SingleByteCharsetProber(SequenceModel sequenceModel, boolean bl, CharsetProber charsetProber) {
        this.model = sequenceModel;
        this.reversed = bl;
        this.nameProber = charsetProber;
        this.seqCounters = new int[4];
        this.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getCharSetName() {
        if (this.nameProber != null) return this.nameProber.getCharSetName();
        return this.model.getCharsetName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public float getConfidence() {
        if (this.totalSeqs <= 0) return 0.01f;
        float f = 1.0f * (float)this.seqCounters[3] / (float)this.totalSeqs / this.model.getTypicalPositiveRatio() * (float)this.freqChar / (float)this.totalChar;
        if (!(f >= 1.0f)) return f;
        return 0.99f;
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            short s = this.model.getOrder(byArray[n]);
            if (s < 250) {
                this.totalChar = 1 + this.totalChar;
            }
            if (s < 64) {
                this.freqChar = 1 + this.freqChar;
                if (this.lastOrder < 64) {
                    this.totalSeqs = 1 + this.totalSeqs;
                    if (!this.reversed) {
                        int[] nArray = this.seqCounters;
                        byte by = this.model.getPrecedence(s + 64 * this.lastOrder);
                        nArray[by] = 1 + nArray[by];
                    } else {
                        int[] nArray = this.seqCounters;
                        byte by = this.model.getPrecedence(s * 64 + this.lastOrder);
                        nArray[by] = 1 + nArray[by];
                    }
                }
            }
            this.lastOrder = s;
            ++n;
        }
        if (this.state != CharsetProber.ProbingState.DETECTING) return this.state;
        if (this.totalSeqs <= 1024) return this.state;
        float f = this.getConfidence();
        if (f > 0.95f) {
            this.state = CharsetProber.ProbingState.FOUND_IT;
            return this.state;
        }
        if (!(f < 0.05f)) return this.state;
        this.state = CharsetProber.ProbingState.NOT_ME;
        return this.state;
    }

    boolean keepEnglishLetters() {
        return this.model.getKeepEnglishLetter();
    }

    @Override
    public void reset() {
        this.state = CharsetProber.ProbingState.DETECTING;
        this.lastOrder = (short)255;
        for (int i = 0; i < 4; ++i) {
            this.seqCounters[i] = 0;
        }
        this.totalSeqs = 0;
        this.totalChar = 0;
        this.freqChar = 0;
    }

    @Override
    public void setOption() {
    }
}

