/*
 * Decompiled with CFR 0.152.
 */
package it.evilsocket.dsploit.wifi;

import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class NetworkManager {
    public static void cleanPreviousConfiguration(WifiManager wifiManager, WifiInfo wifiInfo) {
        WifiConfiguration wifiConfiguration;
        do {
            if ((wifiConfiguration = NetworkManager.getWifiConfiguration(wifiManager, wifiInfo)) == null) continue;
            wifiManager.removeNetwork(wifiConfiguration.networkId);
        } while (wifiConfiguration != null);
    }

    public static int getMaxPriority(WifiManager wifiManager) {
        List list = wifiManager.getConfiguredNetworks();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            WifiConfiguration wifiConfiguration = (WifiConfiguration)iterator.next();
            if (wifiConfiguration.priority <= n) continue;
            n = wifiConfiguration.priority;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WifiConfiguration getWifiConfiguration(WifiManager wifiManager, WifiConfiguration wifiConfiguration) {
        String string2 = wifiConfiguration.SSID;
        if (string2.length() == 0) {
            return null;
        }
        String string3 = wifiConfiguration.BSSID;
        Iterator iterator = wifiManager.getConfiguredNetworks().iterator();
        while (iterator.hasNext()) {
            WifiConfiguration wifiConfiguration2 = (WifiConfiguration)iterator.next();
            if (wifiConfiguration2.SSID == null || !string2.equals(wifiConfiguration2.SSID)) continue;
            if (wifiConfiguration2.BSSID == null) return wifiConfiguration2;
            if (string3 == null) return wifiConfiguration2;
            if (string3.equals(wifiConfiguration2.BSSID)) return wifiConfiguration2;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WifiConfiguration getWifiConfiguration(WifiManager wifiManager, WifiInfo wifiInfo) {
        String string2 = wifiInfo.getSSID();
        if (string2.length() == 0) {
            return null;
        }
        String string3 = wifiInfo.getBSSID();
        Iterator iterator = wifiManager.getConfiguredNetworks().iterator();
        while (iterator.hasNext()) {
            WifiConfiguration wifiConfiguration = (WifiConfiguration)iterator.next();
            if (wifiConfiguration.SSID == null || !string2.equals(wifiConfiguration.SSID)) continue;
            if (wifiConfiguration.BSSID == null) return wifiConfiguration;
            if (string3 == null) return wifiConfiguration;
            if (string3.equals(wifiConfiguration.BSSID)) return wifiConfiguration;
        }
        return null;
    }

    public static int shiftPriorityAndSave(WifiManager wifiManager) {
        List list = wifiManager.getConfiguredNetworks();
        NetworkManager.sortByPriority(list);
        int n = list.size();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                wifiManager.saveConfiguration();
                return n;
            }
            WifiConfiguration wifiConfiguration = (WifiConfiguration)list.get(n2);
            wifiConfiguration.priority = n2++;
            wifiManager.updateNetwork(wifiConfiguration);
        }
    }

    public static void sortByPriority(List<WifiConfiguration> list) {
        Collections.sort(list, new Comparator<WifiConfiguration>(){

            @Override
            public int compare(WifiConfiguration wifiConfiguration, WifiConfiguration wifiConfiguration2) {
                return wifiConfiguration.priority - wifiConfiguration2.priority;
            }
        });
    }
}

