/*
 * Decompiled with CFR 0.152.
 */
package it.evilsocket.dsploit.plugins.mitm;

import android.content.Context;
import android.os.Bundle;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ToggleButton;
import com.actionbarsherlock.app.SherlockActivity;
import com.actionbarsherlock.view.MenuItem;
import it.evilsocket.dsploit.core.Shell;
import it.evilsocket.dsploit.gui.dialogs.ConfirmDialog;
import it.evilsocket.dsploit.gui.dialogs.ErrorDialog;
import it.evilsocket.dsploit.net.Target;
import it.evilsocket.dsploit.plugins.mitm.SpoofSession;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Sniffer
extends SherlockActivity {
    private static final Pattern PARSER;
    private static final String PCAP_FILTER = "not '(src host localhost or dst host localhost or arp)'";
    private static final String[] SORT;
    private static final String TAG = "SNIFFER";
    private StatListAdapter mAdapter = null;
    private boolean mDumpToFile = false;
    private ListView mListView = null;
    private String mPcapFileName = null;
    private boolean mRunning = false;
    private double mSampleTime = 1.0;
    private ProgressBar mSniffProgress = null;
    private ToggleButton mSniffToggleButton = null;
    private Spinner mSortSpinner = null;
    private int mSortType = 0;
    private SpoofSession mSpoofSession = null;

    static {
        String[] stringArray = new String[]{"Bandwidth \u2193", "Bandwidth \u2191", "Total \u2193", "Total \u2191", "Activity \u2193", "Activity \u2191"};
        SORT = stringArray;
        PARSER = Pattern.compile("^.+length\\s+(\\d+)\\)\\s+([\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3})\\.[^\\s]+\\s+>\\s+([\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3})\\.[^\\:]+:.+", 2);
    }

    private void setSpoofErrorState(final String string2) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                new ErrorDialog("Error", string2, Sniffer.this).show();
                Sniffer.this.setStoppedState();
            }
        });
    }

    private void setStartedState() {
        it.evilsocket.dsploit.core.System.getTcpDump().kill();
        if (this.mDumpToFile) {
            Toast.makeText((Context)this, (CharSequence)("Dumping traffic to " + this.mPcapFileName), (int)0).show();
        }
        this.mSpoofSession.start(new SpoofSession.OnSessionReadyListener(){

            @Override
            public void onError(String string2) {
                Sniffer.this.setSpoofErrorState(string2);
            }

            @Override
            public void onSessionReady() {
                it.evilsocket.dsploit.core.System.getTcpDump().sniff(Sniffer.PCAP_FILTER, Sniffer.this.mPcapFileName, new Shell.OutputReceiver(){

                    @Override
                    public void onEnd(int n) {
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void onNewLine(String string2) {
                        try {
                            Matcher matcher = PARSER.matcher(string2.trim());
                            if (matcher == null) return;
                            if (!matcher.find()) return;
                            String string3 = matcher.group(1);
                            String string4 = matcher.group(2);
                            String string5 = matcher.group(3);
                            int n = Integer.parseInt(string3);
                            long l = System.currentTimeMillis();
                            AddressStats addressStats = null;
                            if (it.evilsocket.dsploit.core.System.getNetwork().isInternal(string4)) {
                                addressStats = Sniffer.this.mAdapter.getStats(string4);
                            } else if (it.evilsocket.dsploit.core.System.getNetwork().isInternal(string5)) {
                                string4 = string5;
                                addressStats = Sniffer.this.mAdapter.getStats(string5);
                            }
                            if (addressStats == null) {
                                addressStats = new AddressStats(string4);
                                addressStats.mPackets = n;
                                addressStats.mSampledTime = l;
                            } else {
                                addressStats.mPackets = n + addressStats.mPackets;
                                double d = (double)(l - addressStats.mSampledTime) / 1000.0;
                                if (d >= Sniffer.this.mSampleTime) {
                                    addressStats.mBandwidth = (double)(addressStats.mPackets - addressStats.mSampledSize) / d;
                                    addressStats.mSampledTime = System.currentTimeMillis();
                                    addressStats.mSampledSize = addressStats.mPackets;
                                }
                            }
                            final AddressStats addressStats2 = addressStats;
                            Sniffer.this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    Sniffer.this.mAdapter.addStats(addressStats2);
                                    Sniffer.this.mAdapter.notifyDataSetChanged();
                                }
                            });
                            return;
                        }
                        catch (Exception exception) {
                            it.evilsocket.dsploit.core.System.errorLogging(Sniffer.TAG, exception);
                        }
                    }

                    @Override
                    public void onStart(String string2) {
                    }
                }).start();
            }
        });
        this.mSniffProgress.setVisibility(0);
        this.mRunning = true;
    }

    private void setStoppedState() {
        this.mSpoofSession.stop();
        it.evilsocket.dsploit.core.System.getTcpDump().kill();
        this.mSniffProgress.setVisibility(4);
        this.mRunning = false;
        this.mSniffToggleButton.setChecked(false);
    }

    public int getSortType() {
        synchronized (this) {
            int n = this.mSortType;
            return n;
        }
    }

    public void onBackPressed() {
        this.setStoppedState();
        super.onBackPressed();
        this.overridePendingTransition(2130968576, 2130968577);
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setTitle(it.evilsocket.dsploit.core.System.getCurrentTarget() + " > MITM > Sniffer");
        this.setContentView(2130903076);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.mSniffToggleButton = (ToggleButton)this.findViewById(2131099753);
        this.mSniffProgress = (ProgressBar)this.findViewById(2131099754);
        this.mSortSpinner = (Spinner)this.findViewById(2131099757);
        this.mListView = (ListView)this.findViewById(2131099745);
        this.mAdapter = new StatListAdapter(2130903077);
        this.mSampleTime = Double.parseDouble(it.evilsocket.dsploit.core.System.getSettings().getString("PREF_SNIFFER_SAMPLE_TIME", "1.0"));
        this.mSpoofSession = new SpoofSession(false, false, null, null);
        this.mSortSpinner.setAdapter((SpinnerAdapter)new ArrayAdapter((Context)this, 17367048, (Object[])SORT));
        this.mSortSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> adapterView, View view, int n, long l) {
                Sniffer.this.mSortType = n;
            }

            public void onNothingSelected(AdapterView<?> adapterView) {
            }
        });
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mSniffToggleButton.setOnClickListener(new View.OnClickListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onClick(View view) {
                if (Sniffer.this.mRunning) {
                    Sniffer.this.setStoppedState();
                    return;
                }
                Sniffer.this.setStartedState();
            }
        });
        new ConfirmDialog("File Output", "Do you want to save sniffed traffic to a pcap file ?", this, new ConfirmDialog.ConfirmDialogListener(){

            @Override
            public void onCancel() {
                Sniffer.this.mDumpToFile = false;
                Sniffer.this.mPcapFileName = null;
            }

            @Override
            public void onConfirm() {
                Sniffer.this.mDumpToFile = true;
                Sniffer.this.mPcapFileName = new File(it.evilsocket.dsploit.core.System.getStoragePath(), "dsploit-sniff-" + System.currentTimeMillis() + ".pcap").getAbsolutePath();
            }
        }).show();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        switch (menuItem.getItemId()) {
            default: {
                return super.onOptionsItemSelected(menuItem);
            }
            case 16908332: 
        }
        this.onBackPressed();
        return true;
    }

    public class AddressStats
    implements Comparable<AddressStats> {
        public String mAddress = "";
        public double mBandwidth = 0.0;
        public int mPackets = 0;
        public int mSampledSize = 0;
        public long mSampledTime = 0L;

        public AddressStats(String string2) {
            this.mAddress = string2;
            this.mPackets = 0;
            this.mBandwidth = 0.0;
            this.mSampledTime = 0L;
            this.mSampledSize = 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int compareTo(AddressStats addressStats) {
            double d;
            double d2;
            int[] nArray;
            switch (Sniffer.this.getSortType()) {
                default: {
                    nArray = new int[3];
                    nArray[0] = -1;
                    nArray[1] = 1;
                    d2 = this.mBandwidth;
                    d = addressStats.mBandwidth;
                    break;
                }
                case 0: {
                    nArray = new int[3];
                    nArray[0] = -1;
                    nArray[1] = 1;
                    d2 = this.mBandwidth;
                    d = addressStats.mBandwidth;
                    break;
                }
                case 1: {
                    nArray = new int[3];
                    nArray[0] = 1;
                    nArray[1] = -1;
                    d2 = this.mBandwidth;
                    d = addressStats.mBandwidth;
                    break;
                }
                case 2: {
                    nArray = new int[3];
                    nArray[0] = -1;
                    nArray[1] = 1;
                    d2 = this.mPackets;
                    d = addressStats.mPackets;
                    break;
                }
                case 3: {
                    nArray = new int[3];
                    nArray[0] = 1;
                    nArray[1] = -1;
                    d2 = this.mPackets;
                    d = addressStats.mPackets;
                    break;
                }
                case 4: {
                    nArray = new int[3];
                    nArray[0] = -1;
                    nArray[1] = 1;
                    d2 = this.mSampledTime;
                    d = addressStats.mSampledTime;
                    break;
                }
                case 5: {
                    nArray = new int[3];
                    nArray[0] = 1;
                    nArray[1] = -1;
                    d2 = this.mSampledTime;
                    d = addressStats.mSampledTime;
                }
            }
            if (d2 > d) {
                return nArray[0];
            }
            if (!(d2 < d)) return nArray[2];
            return nArray[1];
        }
    }

    public class StatListAdapter
    extends ArrayAdapter<AddressStats> {
        private int mLayoutId;
        private ArrayList<AddressStats> mStats;

        public StatListAdapter(int n) {
            super((Context)Sniffer.this, n);
            this.mLayoutId = 0;
            this.mStats = null;
            this.mLayoutId = n;
            this.mStats = new ArrayList();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String formatSize(int n) {
            if (n < 1024) {
                return String.valueOf(n) + " B";
            }
            if (n < 0x100000) {
                return String.valueOf(n / 1024) + " KB";
            }
            if (n >= 0x40000000) return String.valueOf(n / 0x40000000) + " GB";
            return String.valueOf(n / 0x100000) + " MB";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String formatSpeed(int n) {
            if (n < 1024) {
                return String.valueOf(n) + " B/s";
            }
            if (n < 0x100000) {
                return String.valueOf(n / 1024) + " KB/s";
            }
            if (n >= 0x40000000) return String.valueOf(n / 0x40000000) + " GB/s";
            return String.valueOf(n / 0x100000) + " MB/s";
        }

        private AddressStats getByPosition(int n) {
            synchronized (this) {
                AddressStats addressStats = this.mStats.get(n);
                return addressStats;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void addStats(AddressStats addressStats) {
            synchronized (this) {
                boolean bl = false;
                for (AddressStats addressStats2 : this.mStats) {
                    if (!addressStats2.mAddress.equals(addressStats.mAddress)) continue;
                    addressStats2.mPackets = addressStats.mPackets;
                    addressStats2.mBandwidth = addressStats.mBandwidth;
                    addressStats2.mSampledTime = addressStats.mSampledTime;
                    addressStats2.mSampledSize = addressStats.mSampledSize;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.mStats.add(addressStats);
                }
                Collections.sort(this.mStats);
                return;
            }
        }

        public int getCount() {
            return this.mStats.size();
        }

        /*
         * Enabled aggressive block sorting
         */
        public AddressStats getStats(String string2) {
            AddressStats addressStats;
            Iterator<AddressStats> iterator = this.mStats.iterator();
            do {
                if (!iterator.hasNext()) {
                    return null;
                }
                addressStats = iterator.next();
            } while (!addressStats.mAddress.equals(string2));
            return addressStats;
        }

        /*
         * Enabled aggressive block sorting
         */
        public View getView(int n, View view, ViewGroup viewGroup) {
            StatsHolder statsHolder;
            View view2 = view;
            if (view2 == null) {
                view2 = ((LayoutInflater)Sniffer.this.getSystemService("layout_inflater")).inflate(this.mLayoutId, viewGroup, false);
                statsHolder = new StatsHolder();
                statsHolder.address = (TextView)view2.findViewById(2131099758);
                statsHolder.description = (TextView)view2.findViewById(2131099759);
                view2.setTag((Object)statsHolder);
            } else {
                statsHolder = (StatsHolder)view2.getTag();
            }
            AddressStats addressStats = this.getByPosition(n);
            Target target = it.evilsocket.dsploit.core.System.getTargetByAddress(addressStats.mAddress);
            if (target != null && target.hasAlias()) {
                statsHolder.address.setText((CharSequence)Html.fromHtml((String)("<b>" + target.getAlias() + "</b> <small>( " + target.getDisplayAddress() + " )</small>")));
            } else {
                statsHolder.address.setText((CharSequence)addressStats.mAddress);
            }
            statsHolder.description.setText((CharSequence)Html.fromHtml((String)("<b>BANDWIDTH</b>: " + this.formatSpeed((int)addressStats.mBandwidth) + " | <b>TOTAL</b> " + this.formatSize(addressStats.mPackets))));
            return view2;
        }

        public class StatsHolder {
            TextView address;
            TextView description;
        }
    }
}

