/*
 * Decompiled with CFR 0.152.
 */
package it.evilsocket.dsploit.plugins;

import android.content.Context;
import android.content.Intent;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Bundle;
import android.text.Html;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.ToggleButton;
import it.evilsocket.dsploit.core.Plugin;
import it.evilsocket.dsploit.core.System;
import it.evilsocket.dsploit.gui.dialogs.FinishDialog;
import it.evilsocket.dsploit.net.Target;
import it.evilsocket.dsploit.plugins.NVDatabase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ExploitFinder
extends Plugin {
    private static final String TAG = "EXPLOITFINDER";
    private ListViewAdapter mAdapter;
    private ExpandableListView mListView;
    private boolean mRunning;
    private ProgressBar mSearchProgress;
    private ToggleButton mSearchToggleButton;
    private Thread mThread;

    public ExploitFinder() {
        Target.Type[] typeArray = new Target.Type[]{Target.Type.ENDPOINT, Target.Type.REMOTE};
        super("Vulnerability Finder", "Search for known vulnerabilities for target running services upon National Vulnerability Database.", typeArray, 2130903065, 2130837591);
        this.mSearchToggleButton = null;
        this.mSearchProgress = null;
        this.mListView = null;
        this.mAdapter = null;
        this.mRunning = false;
        this.mThread = null;
    }

    private void setStartedState() {
        this.mSearchProgress.setVisibility(0);
        this.mRunning = true;
        this.mAdapter.clear();
        this.mThread = new Thread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                Iterator<Target.Port> iterator = System.getCurrentTarget().getOpenPorts().iterator();
                block0: while (true) {
                    if (!iterator.hasNext()) {
                        ExploitFinder.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                ExploitFinder.this.setStoppedState();
                            }
                        });
                        return;
                    }
                    final Target.Port port = iterator.next();
                    if (!ExploitFinder.this.mRunning) return;
                    if (!ExploitFinder.this.mRunning || port.service == null || port.service.isEmpty()) continue;
                    String string2 = port.getServiceQuery();
                    Log.d((String)ExploitFinder.TAG, (String)("Searching for " + port.service + " ( QUERY = " + string2 + " )"));
                    ArrayList<Target.Vulnerability> arrayList = NVDatabase.search(string2);
                    if (!ExploitFinder.this.mRunning) return;
                    if (arrayList == null) {
                        Log.e((String)ExploitFinder.TAG, (String)"Error parsing the page.");
                        continue;
                    }
                    if (arrayList.size() > 0) {
                        Iterator<Target.Vulnerability> iterator2 = arrayList.iterator();
                        while (true) {
                            if (!iterator2.hasNext()) continue block0;
                            final Target.Vulnerability vulnerability = iterator2.next();
                            System.addVulnerability(port, vulnerability);
                            ExploitFinder.this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    ExploitFinder.this.mAdapter.addChild(port.service, vulnerability);
                                }
                            });
                        }
                    }
                    ExploitFinder.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            ExploitFinder.this.mAdapter.addChild(port.service, null);
                        }
                    });
                }
            }
        });
        this.mThread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setStoppedState() {
        try {
            if (this.mThread != null) {
                this.mThread.interrupt();
                this.mThread.stop();
            }
        }
        catch (Exception exception) {}
        this.mRunning = false;
        this.mSearchToggleButton.setChecked(false);
        this.mSearchProgress.setVisibility(8);
    }

    @Override
    public void onBackPressed() {
        this.setStoppedState();
        super.onBackPressed();
        this.overridePendingTransition(2130968576, 2130968577);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onCreate(Bundle var1_1) {
        block7: {
            block6: {
                super.onCreate(var1_1);
                if (!System.getCurrentTarget().hasOpenPorts()) {
                    new FinishDialog("Warning", "No open ports detected on current target, run the service inspector first.", this).show();
lbl4:
                    // 3 sources

                    while (true) {
                        this.mSearchToggleButton = (ToggleButton)this.findViewById(2131099699);
                        this.mSearchProgress = (ProgressBar)this.findViewById(2131099700);
                        this.mListView = (ExpandableListView)this.findViewById(2131099702);
                        this.mAdapter = new ListViewAdapter((Context)this);
                        var2_2 = System.getCurrentTarget().getVulnerabilities();
                        var3_3 = System.getCurrentTarget().getOpenPorts().iterator();
lbl11:
                        // 4 sources

                        while (true) {
                            if (var3_3.hasNext()) break block6;
                            this.mListView.setAdapter((ExpandableListAdapter)this.mAdapter);
                            this.mListView.setOnChildClickListener(new ExpandableListView.OnChildClickListener(){

                                public boolean onChildClick(ExpandableListView expandableListView, View view, int n, int n2, long l) {
                                    Target.Vulnerability vulnerability = (Target.Vulnerability)ExploitFinder.this.mAdapter.getChild(n, n2);
                                    if (vulnerability != null) {
                                        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("http://web.nvd.nist.gov/view/vuln/detail?vulnId=" + vulnerability.getIdentifier())));
                                        ExploitFinder.this.startActivity(intent);
                                    }
                                    return true;
                                }
                            });
                            var7_7 = 0;
lbl16:
                            // 2 sources

                            while (true) {
                                if (var7_7 >= this.mAdapter.getGroupCount()) {
                                    this.mSearchToggleButton.setOnClickListener(new View.OnClickListener(){

                                        /*
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        public void onClick(View view) {
                                            if (ExploitFinder.this.mRunning) {
                                                ExploitFinder.this.setStoppedState();
                                                return;
                                            }
                                            ExploitFinder.this.setStartedState();
                                        }
                                    });
                                    return;
                                }
                                break block7;
                                break;
                            }
                            break;
                        }
                        break;
                    }
                }
                if (System.getCurrentTarget().hasOpenPortsWithService()) ** GOTO lbl4
                new FinishDialog("Warning", "No specific informations about services running on target machine, run the service inspector first.", this).show();
                ** while (true)
            }
            var4_4 = var3_3.next();
            if (var4_4.service == null || var4_4.service.isEmpty()) ** GOTO lbl11
            this.mAdapter.addGroup(var4_4.service);
            if (!var2_2.containsKey(var4_4.toString())) ** GOTO lbl11
            var5_5 = var2_2.get(var4_4.toString()).iterator();
            while (true) {
                if (var5_5.hasNext()) ** break;
                ** continue;
                var6_6 = var5_5.next();
                this.mAdapter.addChild(var4_4.service, var6_6);
            }
        }
        this.mListView.expandGroup(var7_7);
        ++var7_7;
        ** while (true)
    }

    public class ListViewAdapter
    extends BaseExpandableListAdapter {
        private Context mContext = null;
        private HashMap<String, ArrayList<Target.Vulnerability>> mGroups = new HashMap();

        public ListViewAdapter(Context context) {
            this.mContext = context;
        }

        private ArrayList<Target.Vulnerability> getGroupAt(int n) {
            return this.mGroups.get(this.mGroups.keySet().toArray()[n]);
        }

        public void addChild(String string2, Target.Vulnerability vulnerability) {
            if (!this.hasGroup(string2)) {
                this.addGroup(string2);
            }
            this.mGroups.get(string2).add(vulnerability);
            this.notifyDataSetChanged();
        }

        public void addGroup(String string2) {
            this.mGroups.put(string2, new ArrayList());
            this.notifyDataSetChanged();
        }

        public void clear() {
            Object[] objectArray = this.mGroups.keySet().toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    this.notifyDataSetChanged();
                    return;
                }
                Object object = objectArray[n2];
                this.mGroups.get(object).clear();
                ++n2;
            }
        }

        public Object getChild(int n, int n2) {
            return this.getGroupAt(n).get(n2);
        }

        public long getChildId(int n, int n2) {
            return n2 + n * 10;
        }

        /*
         * Enabled aggressive block sorting
         */
        public View getChildView(int n, int n2, boolean bl, View view, ViewGroup viewGroup) {
            Target.Vulnerability vulnerability;
            TextView textView = (TextView)view;
            if (textView == null) {
                textView = new TextView(this.mContext);
            }
            if ((vulnerability = (Target.Vulnerability)this.getChild(n, n2)) == null) {
                textView.setText((CharSequence)Html.fromHtml((String)"<small><i>Nothing Found</i></small>"));
            } else {
                textView.setText((CharSequence)Html.fromHtml((String)("<font color=\"" + vulnerability.getHtmlColor() + "\"><b>" + vulnerability.getIdentifier() + "</b></font> : <small>" + vulnerability.getSummary() + "</small>")));
            }
            textView.setPadding(30, 0, 0, 0);
            return textView;
        }

        public int getChildrenCount(int n) {
            return this.getGroupAt(n).size();
        }

        public Object getGroup(int n) {
            return this.mGroups.keySet().toArray()[n];
        }

        public int getGroupCount() {
            return this.mGroups.size();
        }

        public long getGroupId(int n) {
            return n;
        }

        public View getGroupView(int n, boolean bl, View view, ViewGroup viewGroup) {
            TextView textView = (TextView)view;
            if (textView == null) {
                textView = new TextView(this.mContext);
            }
            textView.setText((CharSequence)this.getGroup(n).toString());
            textView.setTextSize(15.0f);
            textView.setTypeface(Typeface.DEFAULT_BOLD);
            textView.setPadding(50, 0, 0, 0);
            return textView;
        }

        public boolean hasGroup(String string2) {
            return this.mGroups.containsKey(string2);
        }

        public boolean hasStableIds() {
            return true;
        }

        public boolean isChildSelectable(int n, int n2) {
            return true;
        }
    }
}

