/*
 * Decompiled with CFR 0.152.
 */
package it.evilsocket.dsploit.net.http.server;

import android.util.Log;
import it.evilsocket.dsploit.core.System;
import it.evilsocket.dsploit.net.http.server.ServerThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;

public class Server
implements Runnable {
    private static final int BACKLOG = 255;
    private static final int MAX_FILE_SIZE = 0xA00000;
    private static final String TAG = "HTTP.SERVER";
    private InetAddress mAddress = null;
    private int mPort = System.HTTP_SERVER_PORT;
    private String mResourceContentType = null;
    private byte[] mResourceData = null;
    private String mResourcePath = null;
    private boolean mRunning = false;
    private ServerSocket mSocket = null;

    public Server(String string2, int n) throws UnknownHostException, IOException {
        this(string2, n, null, null);
    }

    public Server(String string2, int n, String string3, String string4) throws UnknownHostException, IOException {
        this(InetAddress.getByName(string2), n, string3, string4);
    }

    public Server(InetAddress inetAddress, int n) throws UnknownHostException, IOException {
        this(inetAddress, n, null, null);
    }

    public Server(InetAddress inetAddress, int n, String string2, String string3) throws UnknownHostException, IOException {
        this.mAddress = inetAddress;
        this.mPort = n;
        this.mSocket = new ServerSocket(this.mPort, 255, this.mAddress);
        if (string2 != null && string3 != null) {
            this.setResource(string2, string3);
        }
    }

    public String getResourceURL() {
        return "http://" + this.mAddress.getHostAddress() + ":" + this.mPort + "/";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (this.mSocket == null) {
            this.mSocket = new ServerSocket(this.mPort, 255, this.mAddress);
        }
        Log.d((String)"HTTP.SERVER", (String)("Server started on " + this.mAddress + ":" + this.mPort));
        this.mRunning = true;
lbl7:
        // 3 sources

        while (true) {
            if (!this.mRunning) {
                Log.d((String)"HTTP.SERVER", (String)"Server stopped.");
                return;
            }
            break;
        }
        {
            catch (IOException var1_2) {
                System.errorLogging("HTTP.SERVER", var1_2);
                return;
            }
            try {
                new ServerThread(this.mSocket.accept(), this.mResourceData, this.mResourceContentType).start();
                ** GOTO lbl7
            }
            catch (IOException var3_1) {}
            {
                System.errorLogging("HTTP.SERVER", var3_1);
                ** continue;
            }
        }
    }

    public void setResource(String string2, String string3) throws IOException {
        this.mResourcePath = string2;
        this.mResourceContentType = string3;
        File file = new File(this.mResourcePath);
        FileInputStream fileInputStream = new FileInputStream(file);
        long l = file.length();
        int n = 0;
        if (l > 0xA00000L) {
            throw new IOException("Max allowed file size is 10485760 bytes.");
        }
        this.mResourceData = new byte[(int)l];
        while (true) {
            int n2;
            if ((long)n >= l || (n2 = fileInputStream.read(this.mResourceData, n, (int)(l - (long)n))) < 0) {
                if ((long)n >= l) break;
                throw new IOException("Could not completely read file " + file.getName() + " .");
            }
            n += n2;
        }
        fileInputStream.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        Log.d((String)TAG, (String)"Stopping server ...");
        try {
            if (this.mSocket != null) {
                this.mSocket.close();
            }
        }
        catch (IOException iOException) {}
        this.mRunning = false;
        this.mSocket = null;
    }
}

