/*
 * Decompiled with CFR 0.152.
 */
package it.evilsocket.dsploit.net;

import it.evilsocket.dsploit.core.System;
import java.io.BufferedReader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Endpoint {
    private static final String TAG = "ENDPOINT";
    private InetAddress mAddress = null;
    private byte[] mHardware = null;

    public Endpoint(BufferedReader bufferedReader) throws Exception {
        this.mAddress = InetAddress.getByName(bufferedReader.readLine());
        this.mHardware = Endpoint.parseMacAddress(bufferedReader.readLine());
    }

    public Endpoint(String string2) {
        this(string2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Endpoint(String string2, String string3) {
        try {
            this.mAddress = InetAddress.getByName(string2);
            byte[] byArray = string3 != null ? Endpoint.parseMacAddress(string3) : null;
            this.mHardware = byArray;
            return;
        }
        catch (UnknownHostException unknownHostException) {
            System.errorLogging(TAG, unknownHostException);
            this.mAddress = null;
            return;
        }
    }

    public Endpoint(InetAddress inetAddress, byte[] byArray) {
        this.mAddress = inetAddress;
        this.mHardware = byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] parseMacAddress(String string2) {
        if (string2 == null) return null;
        if (string2.equals("null")) return null;
        if (string2.isEmpty()) return null;
        String[] stringArray = string2.split(":");
        byte[] byArray = new byte[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            byte[] byArray2 = new BigInteger(stringArray[n], 16).toByteArray();
            byArray[n] = byArray2[-1 + byArray2.length];
            ++n;
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Endpoint endpoint) {
        if (this.mHardware == null) return this.mAddress.equals(endpoint.getAddress());
        if (endpoint.mHardware == null) return this.mAddress.equals(endpoint.getAddress());
        if (this.mHardware.length != endpoint.mHardware.length) return this.mAddress.equals(endpoint.getAddress());
        return this.getHardwareAsString().equals(endpoint.getHardwareAsString());
    }

    public InetAddress getAddress() {
        return this.mAddress;
    }

    public long getAddressAsLong() {
        byte[] byArray = this.mAddress.getAddress();
        return ((0xFFL & (long)byArray[0]) << 24) + ((0xFFL & (long)byArray[1]) << 16) + ((0xFFL & (long)byArray[2]) << 8) + (0xFFL & (long)byArray[3]);
    }

    public byte[] getHardware() {
        return this.mHardware;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getHardwareAsString() {
        if (this.mHardware == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(18);
        byte[] byArray = this.mHardware;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            if (stringBuilder.length() > 0) {
                stringBuilder.append(':');
            }
            Object[] objectArray = new Object[]{by};
            stringBuilder.append(String.format("%02X", objectArray));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public void serialize(StringBuilder stringBuilder) {
        stringBuilder.append(String.valueOf(this.mAddress.getHostAddress()) + "\n");
        stringBuilder.append(String.valueOf(this.getHardwareAsString()) + "\n");
    }

    public void setAddress(InetAddress inetAddress) {
        this.mAddress = inetAddress;
    }

    public void setHardware(byte[] byArray) {
        this.mHardware = byArray;
    }

    public String toString() {
        return this.mAddress.getHostAddress();
    }
}

