/*
 * Decompiled with CFR 0.152.
 */
package com.bugsense.trace.models;

import android.content.Context;
import android.util.Log;
import com.bugsense.trace.ActivityAsyncTask;
import com.bugsense.trace.BugSense;
import com.bugsense.trace.BugSenseHandler;
import com.bugsense.trace.CryptoHttpClient;
import com.bugsense.trace.G;
import com.bugsense.trace.models.PingsMechanism;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public final class Ping
implements Serializable {
    private static final long serialVersionUID = -841601581361004004L;
    private String apiVersion = "";
    private String appVerCode = "";
    private String appVersion = "";
    private String locale = "";
    private String os = "";
    private String phoneBrand = "";
    private String phoneModel = "";
    private String tag = "_ping";
    private String timestamp = "";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void sendPing(final Context context, final Ping ping) {
        String string2 = Thread.currentThread().getName();
        if (!string2.equals("main")) {
            Log.d((String)G.TAG, (String)("Error in thread: " + string2));
            Ping.transmitPing(context, ping);
            return;
        }
        new ActivityAsyncTask<BugSense.Processor, Object, Object, Object>(new BugSense.Processor(){

            @Override
            public boolean beginSubmit() {
                return true;
            }

            @Override
            public void handlerInstalled() {
            }

            @Override
            public void submitDone() {
            }
        }){

            protected Object doInBackground(Object ... objectArray) {
                Ping.transmitPing(context, ping);
                return null;
            }

            protected void onCancelled() {
                super.onCancelled();
            }

            protected void onPreExecute() {
                super.onPreExecute();
            }

            @Override
            protected void processPostExecute(Object object) {
                ((BugSense.Processor)this.mWrapped).submitDone();
            }
        }.execute(new Object[0]);
    }

    public static void submitPing(Context context) {
        Ping ping = new Ping();
        ping.setApiVersion("3.0.6");
        ping.setAppVersion(G.APP_VERSION);
        ping.setAppVerCode(G.APP_VERSIONCODE);
        ping.setLocale(Locale.getDefault().getDisplayLanguage());
        ping.setOs(G.ANDROID_VERSION);
        ping.setPhoneModel(G.PHONE_MODEL);
        ping.setPhoneBrand(G.PHONE_BRAND);
        ping.setTimestamp(System.currentTimeMillis());
        Ping.sendPing(context, ping);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean transmitPing(Context context, Ping ping) {
        boolean bl = false;
        if (BugSenseHandler.I_WANT_TO_DEBUG) {
            Log.d((String)G.TAG, (String)("URL: " + G.ANALYTICS_URL));
            Log.d((String)G.TAG, (String)("APIKEY: " + G.API_KEY));
        }
        try {
            String string2;
            DefaultHttpClient defaultHttpClient = G.ANALYTICS_URL.startsWith("https://") ? new CryptoHttpClient(context, 0) : new DefaultHttpClient();
            HttpParams httpParams = defaultHttpClient.getParams();
            HttpProtocolParams.setUseExpectContinue((HttpParams)httpParams, (boolean)false);
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)20000);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)20000);
            HttpPost httpPost = new HttpPost(G.ANALYTICS_URL);
            httpPost.addHeader("X-BugSense-Api-Key", G.API_KEY);
            new ArrayList<BasicNameValuePair>().add(new BasicNameValuePair("data", ping.getFlatLine()));
            httpPost.setEntity((HttpEntity)new StringEntity(ping.getFlatLine()));
            HttpEntity httpEntity = defaultHttpClient.execute((HttpUriRequest)httpPost).getEntity();
            if (httpEntity == null) {
                Log.w((String)G.TAG, (String)"It seems that there is no internet connectivity");
                throw new Exception("no internet connection");
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpEntity.getContent()));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
            if (!BugSenseHandler.I_WANT_TO_DEBUG) return true;
            Log.i((String)G.TAG, (String)("Ping Response for '" + ping.tag + "' :" + stringBuilder.toString()));
            return true;
        }
        catch (ClientProtocolException clientProtocolException) {
            PingsMechanism.getInstance(context).savePing(ping);
            Log.w((String)G.TAG, (String)("Transmitting ping ClientProtocolException " + clientProtocolException.getMessage()));
            if (!BugSenseHandler.I_WANT_TO_DEBUG) return bl;
            clientProtocolException.printStackTrace();
            return bl;
        }
        catch (IOException iOException) {
            PingsMechanism.getInstance(context).savePing(ping);
            Log.w((String)G.TAG, (String)("Transmitting ping IOException " + iOException.getMessage()));
            if (!BugSenseHandler.I_WANT_TO_DEBUG) return bl;
            iOException.printStackTrace();
            return bl;
        }
        catch (Exception exception) {
            PingsMechanism.getInstance(context).savePing(ping);
            Log.w((String)G.TAG, (String)("Transmitting ping Exception " + exception.getMessage()));
            if (!BugSenseHandler.I_WANT_TO_DEBUG) return bl;
            exception.printStackTrace();
            return bl;
        }
    }

    public String getFlatLine() {
        return this.apiVersion + ":" + this.tag + ":" + this.phoneModel + ":" + this.phoneBrand + ":" + this.os + ":" + this.appVersion + ":" + this.locale + ":" + this.timestamp;
    }

    public String getTag() {
        return this.tag;
    }

    public void setApiVersion(String string2) {
        this.apiVersion = string2;
    }

    public void setAppVerCode(String string2) {
        this.appVerCode = string2;
    }

    public void setAppVersion(String string2) {
        this.appVersion = string2;
    }

    public void setLocale(String string2) {
        this.locale = string2;
    }

    public void setOs(String string2) {
        this.os = string2;
    }

    public void setPhoneBrand(String string2) {
        this.phoneBrand = string2;
    }

    public void setPhoneModel(String string2) {
        this.phoneModel = string2;
    }

    public void setTag(String string2) {
        this.tag = string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTimestamp(long l) {
        this.timestamp = "";
        try {
            this.timestamp = String.valueOf(l);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

