/*
 * Decompiled with CFR 0.152.
 */
package com.bugsense.trace;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import com.bugsense.trace.ActivityAsyncTask;
import com.bugsense.trace.BugSense;
import com.bugsense.trace.DefaultExceptionHandler;
import com.bugsense.trace.G;
import com.bugsense.trace.Utils;
import com.bugsense.trace.models.Crash;
import com.bugsense.trace.models.CrashMechanism;
import com.bugsense.trace.models.Ping;
import com.bugsense.trace.models.PingsMechanism;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONObject;

public class BugSenseHandler {
    public static boolean I_WANT_TO_DEBUG = false;
    private static HashMap<String, String> crashExtraData;
    private static SharedPreferences.Editor editor;
    private static ExecutorService executor;
    protected static Context gContext;
    private static boolean isSessionActive;
    private static String locText;
    private static String locTicker;
    private static String locTitle;
    private static SharedPreferences preferences;
    protected static int sMinDelay;
    private static boolean sSetupCalled;
    private static ActivityAsyncTask<Processor, Object, Object, Object> sTask;

    static {
        sMinDelay = 0;
        sSetupCalled = false;
        gContext = null;
        executor = Executors.newFixedThreadPool(2);
        isSessionActive = false;
        locTicker = "";
        locTitle = "";
        locText = "";
        crashExtraData = new HashMap();
    }

    public static void addCrashExtraData(String string2, String string3) {
        if (crashExtraData == null) {
            crashExtraData = new HashMap();
        }
        crashExtraData.put(string2, string3);
    }

    public static void addCrashExtraMap(HashMap<String, String> hashMap) {
        if (crashExtraData == null) {
            crashExtraData = new HashMap();
        }
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            crashExtraData.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void clearCrashExtraData() {
        if (crashExtraData == null) {
            crashExtraData = new HashMap();
            return;
        }
        crashExtraData.clear();
    }

    public static void closeSession(Context context) {
        isSessionActive = false;
        Ping ping = new Ping();
        ping.setTag("_gnip");
        ping.setApiVersion("3.0.6");
        ping.setAppVersion(G.APP_VERSION);
        ping.setAppVerCode(G.APP_VERSIONCODE);
        ping.setLocale(Locale.getDefault().getDisplayLanguage());
        ping.setOs(G.ANDROID_VERSION);
        ping.setPhoneModel(G.PHONE_MODEL);
        ping.setPhoneBrand(G.PHONE_BRAND);
        ping.setTimestamp(System.currentTimeMillis());
        PingsMechanism.getInstance(context).savePing(ping);
    }

    private static void deleteCrashesFile(final Context context) {
        Thread thread = new Thread(new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                if (I_WANT_TO_DEBUG) {
                    Log.i((String)G.TAG, (String)"Deleting Crashes File");
                }
                try {
                    File file = context.getFileStreamPath("bcrashes");
                    if (file.exists()) {
                        file.delete();
                    }
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
        });
        BugSenseHandler.getExecutor().submit(thread);
    }

    private static void deletePingsFile(final Context context) {
        Thread thread = new Thread(new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                if (I_WANT_TO_DEBUG) {
                    Log.i((String)G.TAG, (String)"Deleting Pings File");
                }
                try {
                    File file = context.getFileStreamPath("bpings");
                    if (file.exists()) {
                        file.delete();
                    }
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
        });
        BugSenseHandler.getExecutor().submit(thread);
    }

    public static void flush(Context context) {
        Log.i((String)G.TAG, (String)"Flushing...");
        PingsMechanism.getInstance(context).sendSavedPings();
        CrashMechanism.getInstance(context).sendSavedCrashes();
    }

    public static HashMap<String, String> getCrashExtraData() {
        if (crashExtraData == null) {
            crashExtraData = new HashMap();
        }
        return crashExtraData;
    }

    public static ExecutorService getExecutor() {
        if (executor == null) {
            executor = Executors.newFixedThreadPool(2);
        }
        return executor;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initAndStartSession(Context context, Processor processor, String string2) {
        block14: {
            boolean bl;
            boolean bl2;
            block13: {
                boolean bl3;
                boolean bl4;
                if (string2 == null || string2.length() < 8 || string2.length() > 14) {
                    throw new IllegalArgumentException("Your BugSense API Key is invalid!");
                }
                G.API_KEY = string2;
                preferences = context.getSharedPreferences(G.TAG, 0);
                editor = preferences.edit();
                bl2 = bl4 = preferences.getBoolean("PINGS_READ_COMPLETED", true);
                bl = bl3 = preferences.getBoolean("CRASH_READ_COMPLETED", true);
                break block13;
                {
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    bl2 = true;
                    if (I_WANT_TO_DEBUG) {
                        void var3_10;
                        var3_10.printStackTrace();
                    }
                    bl = true;
                }
            }
            if (!bl2) {
                BugSenseHandler.deletePingsFile(context);
            }
            if (!bl) {
                BugSenseHandler.deleteCrashesFile(context);
            }
            if (!G.ANALYTICS_URL.contains(string2)) {
                G.ANALYTICS_URL = G.ANALYTICS_URL + G.API_KEY + "/" + Utils.getUid(context);
            }
            if (I_WANT_TO_DEBUG) {
                Log.d((String)G.TAG, (String)("Crash     URL set to: " + G.URL));
                Log.d((String)G.TAG, (String)("Analytics URL set to: " + G.ANALYTICS_URL));
            }
            gContext = context;
            if (sSetupCalled && sTask != null && !sTask.postProcessingDone()) {
                sTask.connectTo(null);
                sTask.connectTo(processor);
            }
            sSetupCalled = true;
            Log.i((String)G.TAG, (String)"Registering default exceptions handler");
            G.FILES_PATH = context.getFilesDir().getAbsolutePath();
            G.PHONE_MODEL = Build.MODEL;
            G.ANDROID_VERSION = Build.VERSION.RELEASE;
            G.HAS_ROOT = Utils.checkForRoot();
            PackageManager packageManager = context.getPackageManager();
            try {
                PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
                G.APP_VERSION = packageInfo.versionName;
                G.APP_VERSIONCODE = String.valueOf(packageInfo.versionCode);
                G.APP_PACKAGE = packageInfo.packageName;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.e((String)G.TAG, (String)"Error collecting information about the package!");
                if (!I_WANT_TO_DEBUG) break block14;
                nameNotFoundException.printStackTrace();
            }
        }
        BugSenseHandler.installHandler();
        processor.handlerInstalled();
        PingsMechanism.sendPing(context);
        editor.putLong("lastping", System.currentTimeMillis()).commit();
        BugSenseHandler.flush(context);
        BugSenseHandler.startSession(context);
    }

    public static void initAndStartSession(Context context, String string2) {
        BugSenseHandler.initAndStartSession(context, new Processor(){

            @Override
            public boolean beginSubmit() {
                return true;
            }

            @Override
            public void handlerInstalled() {
            }

            @Override
            public void submitDone() {
            }
        }, string2);
    }

    private static void installHandler() {
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (uncaughtExceptionHandler != null && I_WANT_TO_DEBUG) {
            Log.d((String)G.TAG, (String)("current handler class=" + uncaughtExceptionHandler.getClass().getName()));
        }
        if (!(uncaughtExceptionHandler instanceof DefaultExceptionHandler)) {
            Thread.setDefaultUncaughtExceptionHandler(new DefaultExceptionHandler(uncaughtExceptionHandler));
        }
    }

    public static void leaveBreadcrumb(String string2) {
        if (G.breadcrumbs == null) {
            G.breadcrumbs = new ArrayList(16);
        }
        if (G.breadcrumbs.size() >= 16) {
            G.breadcrumbs.remove(0);
        }
        G.breadcrumbs.add(string2);
        if (I_WANT_TO_DEBUG) {
            Log.i((String)G.TAG, (String)("BreadCrumb: " + string2 + " added."));
        }
    }

    public static void removeCrashExtraData(String string2) {
        if (crashExtraData == null) {
            crashExtraData = new HashMap();
        }
        crashExtraData.remove(string2);
    }

    public static void sendException(Exception exception) {
        BugSenseHandler.sendExceptionMap(new HashMap<String, String>(0), exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void sendExceptionMap(HashMap<String, String> hashMap, Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (G.API_KEY == null) {
            Log.e((String)G.TAG, (String)"Could not send: API Key is missing");
            return;
        }
        Log.i((String)G.TAG, (String)"Saving handled exception");
        exception.printStackTrace(printWriter);
        long l = 0L;
        try {
            long l2 = System.currentTimeMillis();
            long l3 = G.TIMESTAMP;
            l = l2 - l3;
        }
        catch (Exception exception2) {}
        try {
            exception.printStackTrace(printWriter);
            Crash crash = new Crash();
            crash.setHandled(0);
            crash.setAndroidVersion(G.ANDROID_VERSION);
            crash.setAppPackage(G.APP_PACKAGE);
            crash.setAppVersion(G.APP_VERSION);
            crash.setBreadcrumbs(G.breadcrumbs);
            crash.setAppVerCode(G.APP_VERSIONCODE);
            if (G.SEND_LOG) {
                crash.setConsoleLogs(BugSense.readLogs());
            }
            crash.setCustomData(hashMap);
            crash.setDate(String.valueOf(System.currentTimeMillis()));
            crash.setExtraData(BugSenseHandler.getCrashExtraData());
            crash.setIsGPSOn(Utils.isGPSOn(gContext));
            crash.setIsMobileNetworkOn(Utils.isMobileNetworkOn(gContext));
            crash.setIsWifiOn(Utils.isWifiOn(gContext));
            crash.setMs_from_start(String.valueOf(l));
            crash.setPhoneModel(G.PHONE_MODEL);
            crash.setPhoneBrand(G.PHONE_BRAND);
            crash.setRooted(String.valueOf(G.HAS_ROOT));
            crash.setScreenProperties(Utils.ScreenProperties(gContext));
            crash.setStacktrace(((Object)stringWriter).toString());
            CrashMechanism.getInstance(gContext).saveCrash(crash);
            return;
        }
        catch (Exception exception3) {
            Log.e((String)G.TAG, (String)"Failed to save handled exception ");
            if (!I_WANT_TO_DEBUG) return;
            exception3.printStackTrace();
            return;
        }
    }

    public static void sendExceptionMessage(String string2, String string3, Exception exception) {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        if (string2 != null && string3 != null) {
            hashMap.put(string2, string3);
        }
        BugSenseHandler.sendExceptionMap(hashMap, exception);
    }

    public static void setLocalizedNotification(String string2, String string3, String string4) {
        locTicker = string2;
        locTitle = string3;
        locText = string4;
    }

    public static void setLogging(int n) {
        G.SEND_LOG = true;
        G.LOG_LINES = n;
    }

    public static void setLogging(int n, String string2) {
        G.SEND_LOG = true;
        G.LOG_LINES = n;
        G.LOG_FILTER = string2;
    }

    public static void setLogging(String string2) {
        G.SEND_LOG = true;
        G.LOG_FILTER = string2;
    }

    public static void setLogging(boolean bl) {
        G.SEND_LOG = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void showUpgradeNotification(String string2) {
        if (I_WANT_TO_DEBUG) {
            Log.i((String)G.TAG, (String)("Show notification: " + string2));
        }
        if (string2 == null) return;
        if (string2.length() <= 5) return;
        try {
            Context context = gContext;
            NotificationManager notificationManager = (NotificationManager)gContext.getSystemService("notification");
            JSONObject jSONObject = new JSONObject(new JSONObject(string2).getString("data"));
            String string3 = jSONObject.getString("tickerText");
            String string4 = locTicker != null && locTicker.length() > 1 ? locTicker : string3;
            long l = System.currentTimeMillis();
            Resources resources = gContext.getResources();
            int n = resources.getIdentifier("ic_launcher", "drawable", gContext.getPackageName());
            if (n == 0) {
                n = resources.getIdentifier("icon", "drawable", gContext.getPackageName());
            }
            Notification notification = new Notification(n, (CharSequence)string4, l);
            notification.flags = 16;
            String string5 = jSONObject.getString("contentTitle");
            String string6 = locTitle != null && locTitle.length() > 1 ? locTitle : string5;
            String string7 = jSONObject.getString("contentText");
            if (locText != null && locText.length() > 1) {
                string7 = locText;
            }
            notification.setLatestEventInfo(context, (CharSequence)string6, (CharSequence)string7, PendingIntent.getActivity((Context)context, (int)0, (Intent)new Intent("android.intent.action.VIEW", Uri.parse((String)jSONObject.getString("url"))), (int)0x10000000));
            notificationManager.notify(1, notification);
            return;
        }
        catch (Exception exception) {
            Log.e((String)G.TAG, (String)"Error starting fix notification");
            if (!I_WANT_TO_DEBUG) return;
            exception.printStackTrace();
            return;
        }
    }

    public static void startSession(Context context) {
        gContext = context;
        BugSenseHandler.installHandler();
        if (!isSessionActive) {
            G.TIMESTAMP = System.currentTimeMillis();
            isSessionActive = true;
            SharedPreferences sharedPreferences = context.getSharedPreferences(G.TAG, 0);
            Long l = sharedPreferences.getLong("lastping", 0L);
            if (l == 0L || System.currentTimeMillis() > 10000L + l) {
                sharedPreferences.edit().putLong("lastping", System.currentTimeMillis()).commit();
                PingsMechanism.sendPing(context);
            }
        }
    }

    public static interface Processor {
        public boolean beginSubmit();

        public void handlerInstalled();

        public void submitDone();
    }
}

