/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.widget;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.SpinnerAdapter;
import com.actionbarsherlock.R;
import com.actionbarsherlock.internal.widget.IcsAbsSpinner;
import com.actionbarsherlock.internal.widget.IcsListPopupWindow;

public class IcsSpinner
extends IcsAbsSpinner
implements DialogInterface.OnClickListener {
    private static final int MAX_ITEMS_MEASURED = 15;
    public static final int MODE_DROPDOWN = 1;
    private boolean mDisableChildrenWhenDisabled;
    int mDropDownWidth;
    private int mGravity;
    private SpinnerPopup mPopup;
    private DropDownAdapter mTempAdapter;
    private Rect mTempRect = new Rect();

    public IcsSpinner(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.actionDropDownStyle);
    }

    public IcsSpinner(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        int n2;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SherlockSpinner, n, 0);
        DropdownPopup dropdownPopup = new DropdownPopup(context, attributeSet, n);
        this.mDropDownWidth = typedArray.getLayoutDimension(4, -2);
        dropdownPopup.setBackgroundDrawable(typedArray.getDrawable(2));
        int n3 = typedArray.getDimensionPixelOffset(6, 0);
        if (n3 != 0) {
            dropdownPopup.setVerticalOffset(n3);
        }
        if ((n2 = typedArray.getDimensionPixelOffset(5, 0)) != 0) {
            dropdownPopup.setHorizontalOffset(n2);
        }
        this.mPopup = dropdownPopup;
        this.mGravity = typedArray.getInt(0, 17);
        this.mPopup.setPromptText(typedArray.getString(3));
        this.mDisableChildrenWhenDisabled = true;
        typedArray.recycle();
        if (this.mTempAdapter != null) {
            this.mPopup.setAdapter(this.mTempAdapter);
            this.mTempAdapter = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View makeAndAddView(int n) {
        View view;
        if (!this.mDataChanged && (view = this.mRecycler.get(n)) != null) {
            this.setUpChild(view);
            return view;
        }
        View view2 = this.mAdapter.getView(n, null, (ViewGroup)this);
        this.setUpChild(view2);
        return view2;
    }

    private void setUpChild(View view) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = this.generateDefaultLayoutParams();
        }
        this.addViewInLayout(view, 0, layoutParams);
        view.setSelected(this.hasFocus());
        if (this.mDisableChildrenWhenDisabled) {
            view.setEnabled(this.isEnabled());
        }
        int n = ViewGroup.getChildMeasureSpec((int)this.mHeightMeasureSpec, (int)(this.mSpinnerPadding.top + this.mSpinnerPadding.bottom), (int)layoutParams.height);
        view.measure(ViewGroup.getChildMeasureSpec((int)this.mWidthMeasureSpec, (int)(this.mSpinnerPadding.left + this.mSpinnerPadding.right), (int)layoutParams.width), n);
        int n2 = this.mSpinnerPadding.top + (this.getMeasuredHeight() - this.mSpinnerPadding.bottom - this.mSpinnerPadding.top - view.getMeasuredHeight()) / 2;
        int n3 = n2 + view.getMeasuredHeight();
        view.layout(0, n2, 0 + view.getMeasuredWidth(), n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getBaseline() {
        int n = -1;
        View view = null;
        if (this.getChildCount() > 0) {
            view = this.getChildAt(0);
        } else if (this.mAdapter != null && this.mAdapter.getCount() > 0) {
            view = this.makeAndAddView(0);
            this.mRecycler.put(0, view);
            this.removeAllViewsInLayout();
        }
        if (view == null) return n;
        int n2 = view.getBaseline();
        if (n2 < 0) return n;
        return n2 + view.getTop();
    }

    public CharSequence getPrompt() {
        return this.mPopup.getHintText();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void layout(int n, boolean bl) {
        int n2 = this.mSpinnerPadding.left;
        int n3 = this.getRight() - this.getLeft() - this.mSpinnerPadding.left - this.mSpinnerPadding.right;
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        if (this.mItemCount == 0) {
            this.resetList();
            return;
        }
        if (this.mNextSelectedPosition >= 0) {
            this.setSelectedPositionInt(this.mNextSelectedPosition);
        }
        this.recycleAllViews();
        this.removeAllViewsInLayout();
        this.mFirstPosition = this.mSelectedPosition;
        View view = this.makeAndAddView(this.mSelectedPosition);
        int n4 = view.getMeasuredWidth();
        int n5 = n2;
        switch (7 & this.mGravity) {
            case 1: {
                n5 = n2 + n3 / 2 - n4 / 2;
            }
            default: {
                break;
            }
            case 5: {
                n5 = n2 + n3 - n4;
            }
        }
        view.offsetLeftAndRight(n5);
        this.mRecycler.clear();
        this.invalidate();
        this.checkSelectionChanged();
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.setNextSelectedPositionInt(this.mSelectedPosition);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int measureContentWidth(SpinnerAdapter spinnerAdapter, Drawable drawable2) {
        if (spinnerAdapter == null) {
            return 0;
        }
        int n = 0;
        View view = null;
        int n2 = 0;
        int n3 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int n4 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int n5 = Math.max(0, this.getSelectedItemPosition());
        int n6 = Math.min(spinnerAdapter.getCount(), n5 + 15);
        int n7 = Math.max(0, n5 - (15 - (n6 - n5)));
        while (true) {
            if (n7 >= n6) {
                if (drawable2 == null) return n;
                drawable2.getPadding(this.mTempRect);
                n += this.mTempRect.left + this.mTempRect.right;
                return n;
            }
            int n8 = spinnerAdapter.getItemViewType(n7);
            if (n8 != n2) {
                n2 = n8;
                view = null;
            }
            if ((view = spinnerAdapter.getView(n7, view, (ViewGroup)this)).getLayoutParams() == null) {
                view.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            }
            view.measure(n3, n4);
            n = Math.max(n, view.getMeasuredWidth());
            ++n7;
        }
    }

    public void onClick(DialogInterface dialogInterface, int n) {
        this.setSelection(n);
        dialogInterface.dismiss();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.mInLayout = true;
        this.layout(0, false);
        this.mInLayout = false;
    }

    @Override
    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        if (this.mPopup != null && View.MeasureSpec.getMode((int)n) == Integer.MIN_VALUE) {
            this.setMeasuredDimension(Math.min(Math.max(this.getMeasuredWidth(), this.measureContentWidth(this.getAdapter(), this.getBackground())), View.MeasureSpec.getSize((int)n)), this.getMeasuredHeight());
        }
    }

    public boolean performClick() {
        boolean bl = super.performClick();
        if (!bl) {
            bl = true;
            if (!this.mPopup.isShowing()) {
                this.mPopup.show();
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAdapter(SpinnerAdapter spinnerAdapter) {
        super.setAdapter(spinnerAdapter);
        if (this.mPopup != null) {
            this.mPopup.setAdapter(new DropDownAdapter(spinnerAdapter));
            return;
        }
        this.mTempAdapter = new DropDownAdapter(spinnerAdapter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!this.mDisableChildrenWhenDisabled) return;
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            this.getChildAt(n2).setEnabled(bl);
            ++n2;
        }
        return;
    }

    public void setGravity(int n) {
        if (this.mGravity != n) {
            if ((n & 7) == 0) {
                n |= 3;
            }
            this.mGravity = n;
            this.requestLayout();
        }
    }

    @Override
    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        throw new RuntimeException("setOnItemClickListener cannot be used with a spinner.");
    }

    public void setPrompt(CharSequence charSequence) {
        this.mPopup.setPromptText(charSequence);
    }

    public void setPromptId(int n) {
        this.setPrompt(this.getContext().getText(n));
    }

    private static class DropDownAdapter
    implements ListAdapter,
    SpinnerAdapter {
        private SpinnerAdapter mAdapter;
        private ListAdapter mListAdapter;

        public DropDownAdapter(SpinnerAdapter spinnerAdapter) {
            this.mAdapter = spinnerAdapter;
            if (spinnerAdapter instanceof ListAdapter) {
                this.mListAdapter = (ListAdapter)spinnerAdapter;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean areAllItemsEnabled() {
            ListAdapter listAdapter = this.mListAdapter;
            if (listAdapter == null) return true;
            return listAdapter.areAllItemsEnabled();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getCount() {
            if (this.mAdapter != null) return this.mAdapter.getCount();
            return 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public View getDropDownView(int n, View view, ViewGroup viewGroup) {
            if (this.mAdapter != null) return this.mAdapter.getDropDownView(n, view, viewGroup);
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object getItem(int n) {
            if (this.mAdapter != null) return this.mAdapter.getItem(n);
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public long getItemId(int n) {
            if (this.mAdapter != null) return this.mAdapter.getItemId(n);
            return -1L;
        }

        public int getItemViewType(int n) {
            return 0;
        }

        public View getView(int n, View view, ViewGroup viewGroup) {
            return this.getDropDownView(n, view, viewGroup);
        }

        public int getViewTypeCount() {
            return 1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean hasStableIds() {
            if (this.mAdapter == null) return false;
            if (!this.mAdapter.hasStableIds()) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isEmpty() {
            if (this.getCount() != 0) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isEnabled(int n) {
            ListAdapter listAdapter = this.mListAdapter;
            if (listAdapter == null) return true;
            return listAdapter.isEnabled(n);
        }

        public void registerDataSetObserver(DataSetObserver dataSetObserver) {
            if (this.mAdapter != null) {
                this.mAdapter.registerDataSetObserver(dataSetObserver);
            }
        }

        public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
            if (this.mAdapter != null) {
                this.mAdapter.unregisterDataSetObserver(dataSetObserver);
            }
        }
    }

    private class DropdownPopup
    extends IcsListPopupWindow
    implements SpinnerPopup {
        private ListAdapter mAdapter;
        private CharSequence mHintText;

        public DropdownPopup(Context context, AttributeSet attributeSet, int n) {
            super(context, attributeSet, 0, n);
            this.setAnchorView((View)IcsSpinner.this);
            this.setModal(true);
            this.setPromptPosition(0);
            this.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView adapterView, View view, int n, long l) {
                    IcsSpinner.this.setSelection(n);
                    DropdownPopup.this.dismiss();
                }
            });
        }

        @Override
        public CharSequence getHintText() {
            return this.mHintText;
        }

        @Override
        public void setAdapter(ListAdapter listAdapter) {
            super.setAdapter(listAdapter);
            this.mAdapter = listAdapter;
        }

        @Override
        public void setPromptText(CharSequence charSequence) {
            this.mHintText = charSequence;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void show() {
            int n = IcsSpinner.this.getPaddingLeft();
            if (IcsSpinner.this.mDropDownWidth == -2) {
                int n2 = IcsSpinner.this.getWidth();
                int n3 = IcsSpinner.this.getPaddingRight();
                this.setContentWidth(Math.max(IcsSpinner.this.measureContentWidth((SpinnerAdapter)this.mAdapter, IcsSpinner.this.getBackground()), n2 - n - n3));
            } else if (IcsSpinner.this.mDropDownWidth == -1) {
                int n4 = IcsSpinner.this.getWidth();
                int n5 = IcsSpinner.this.getPaddingRight();
                this.setContentWidth(n4 - n - n5);
            } else {
                this.setContentWidth(IcsSpinner.this.mDropDownWidth);
            }
            Drawable drawable2 = IcsSpinner.this.getBackground();
            int n6 = 0;
            if (drawable2 != null) {
                drawable2.getPadding(IcsSpinner.this.mTempRect);
                n6 = -((IcsSpinner)IcsSpinner.this).mTempRect.left;
            }
            this.setHorizontalOffset(n6 + n);
            this.setInputMethodMode(2);
            super.show();
            this.getListView().setChoiceMode(1);
            IcsSpinner.this.setSelection(IcsSpinner.this.getSelectedItemPosition());
        }
    }

    private static interface SpinnerPopup {
        public void dismiss();

        public CharSequence getHintText();

        public boolean isShowing();

        public void setAdapter(ListAdapter var1);

        public void setPromptText(CharSequence var1);

        public void show();
    }
}

