/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import com.actionbarsherlock.internal.nineoldandroids.widget.NineLinearLayout;

public class IcsLinearLayout
extends NineLinearLayout {
    private static final int[] LinearLayout;
    private static final int LinearLayout_divider = 0;
    private static final int LinearLayout_dividerPadding = 2;
    private static final int LinearLayout_showDividers = 1;
    public static final int SHOW_DIVIDER_BEGINNING = 1;
    public static final int SHOW_DIVIDER_END = 4;
    public static final int SHOW_DIVIDER_MIDDLE = 2;
    public static final int SHOW_DIVIDER_NONE;
    private Drawable mDivider;
    private int mDividerHeight;
    private int mDividerPadding;
    private int mDividerWidth;
    private int mShowDividers;

    static {
        int[] nArray = new int[]{16843049, 16843561, 16843562};
        LinearLayout = nArray;
    }

    public IcsLinearLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, LinearLayout);
        this.setDividerDrawable(typedArray.getDrawable(0));
        this.mShowDividers = typedArray.getInt(1, 0);
        this.mDividerPadding = typedArray.getDimensionPixelSize(2, 0);
        typedArray.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    void drawDividersHorizontal(Canvas canvas) {
        int n = this.getChildCount();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                if (this.hasDividerBeforeChildAt(n)) {
                    int n3;
                    View view = this.getChildAt(n + -1);
                    if (view == null) {
                        n3 = this.getWidth() - this.getPaddingRight() - this.mDividerWidth;
                    } else {
                        LinearLayout.LayoutParams cfr_ignored_0 = (LinearLayout.LayoutParams)view.getLayoutParams();
                        n3 = view.getRight();
                    }
                    this.drawVerticalDivider(canvas, n3);
                }
                return;
            }
            View view = this.getChildAt(n2);
            if (view != null && view.getVisibility() != 8 && this.hasDividerBeforeChildAt(n2)) {
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view.getLayoutParams();
                this.drawVerticalDivider(canvas, view.getLeft() - layoutParams.leftMargin);
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void drawDividersVertical(Canvas canvas) {
        int n = this.getChildCount();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                if (this.hasDividerBeforeChildAt(n)) {
                    int n3;
                    View view = this.getChildAt(n + -1);
                    if (view == null) {
                        n3 = this.getHeight() - this.getPaddingBottom() - this.mDividerHeight;
                    } else {
                        LinearLayout.LayoutParams cfr_ignored_0 = (LinearLayout.LayoutParams)view.getLayoutParams();
                        n3 = view.getBottom();
                    }
                    this.drawHorizontalDivider(canvas, n3);
                }
                return;
            }
            View view = this.getChildAt(n2);
            if (view != null && view.getVisibility() != 8 && this.hasDividerBeforeChildAt(n2)) {
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view.getLayoutParams();
                this.drawHorizontalDivider(canvas, view.getTop() - layoutParams.topMargin);
            }
            ++n2;
        }
    }

    void drawHorizontalDivider(Canvas canvas, int n) {
        this.mDivider.setBounds(this.getPaddingLeft() + this.mDividerPadding, n, this.getWidth() - this.getPaddingRight() - this.mDividerPadding, n + this.mDividerHeight);
        this.mDivider.draw(canvas);
    }

    void drawVerticalDivider(Canvas canvas, int n) {
        this.mDivider.setBounds(n, this.getPaddingTop() + this.mDividerPadding, n + this.mDividerWidth, this.getHeight() - this.getPaddingBottom() - this.mDividerPadding);
        this.mDivider.draw(canvas);
    }

    public int getDividerPadding() {
        return this.mDividerPadding;
    }

    public int getDividerWidth() {
        return this.mDividerWidth;
    }

    public int getShowDividers() {
        return this.mShowDividers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean hasDividerBeforeChildAt(int n) {
        boolean bl = true;
        if (n == 0) {
            if ((1 & this.mShowDividers) == 0) return false;
            return bl;
        }
        if (n == this.getChildCount()) {
            if ((4 & this.mShowDividers) != 0) return bl;
            return false;
        }
        if ((2 & this.mShowDividers) == 0) return false;
        bl = false;
        int n2 = n + -1;
        while (n2 >= 0) {
            if (this.getChildAt(n2).getVisibility() != 8) {
                return true;
            }
            --n2;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void measureChildWithMargins(View view, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = this.indexOfChild(view);
        int n7 = this.getOrientation();
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view.getLayoutParams();
        if (this.hasDividerBeforeChildAt(n6)) {
            if (n7 == 1) {
                layoutParams.topMargin = this.mDividerHeight;
            } else {
                layoutParams.leftMargin = this.mDividerWidth;
            }
        }
        if (n6 == (n5 = this.getChildCount()) + -1 && this.hasDividerBeforeChildAt(n5)) {
            if (n7 == 1) {
                layoutParams.bottomMargin = this.mDividerHeight;
            } else {
                layoutParams.rightMargin = this.mDividerWidth;
            }
        }
        super.measureChildWithMargins(view, n, n2, n3, n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onDraw(Canvas canvas) {
        if (this.mDivider != null) {
            if (this.getOrientation() == 1) {
                this.drawDividersVertical(canvas);
            } else {
                this.drawDividersHorizontal(canvas);
            }
        }
        super.onDraw(canvas);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDividerDrawable(Drawable drawable2) {
        boolean bl = false;
        if (drawable2 == this.mDivider) {
            return;
        }
        this.mDivider = drawable2;
        if (drawable2 != null) {
            this.mDividerWidth = drawable2.getIntrinsicWidth();
            this.mDividerHeight = drawable2.getIntrinsicHeight();
        } else {
            this.mDividerWidth = bl;
            this.mDividerHeight = bl;
        }
        if (drawable2 == null) {
            bl = true;
        }
        this.setWillNotDraw(bl);
        this.requestLayout();
    }

    public void setDividerPadding(int n) {
        this.mDividerPadding = n;
    }

    public void setShowDividers(int n) {
        if (n != this.mShowDividers) {
            this.requestLayout();
            this.invalidate();
        }
        this.mShowDividers = n;
    }
}

