/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.widget;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.actionbarsherlock.R;
import com.actionbarsherlock.app.ActionBar;
import com.actionbarsherlock.internal.ActionBarSherlockCompat;
import com.actionbarsherlock.internal.ResourcesCompat;
import com.actionbarsherlock.internal.view.menu.ActionMenuItem;
import com.actionbarsherlock.internal.view.menu.ActionMenuPresenter;
import com.actionbarsherlock.internal.view.menu.ActionMenuView;
import com.actionbarsherlock.internal.view.menu.MenuBuilder;
import com.actionbarsherlock.internal.view.menu.MenuItemImpl;
import com.actionbarsherlock.internal.view.menu.MenuPresenter;
import com.actionbarsherlock.internal.view.menu.MenuView;
import com.actionbarsherlock.internal.view.menu.SubMenuBuilder;
import com.actionbarsherlock.internal.widget.AbsActionBarView;
import com.actionbarsherlock.internal.widget.ActionBarContainer;
import com.actionbarsherlock.internal.widget.ActionBarContextView;
import com.actionbarsherlock.internal.widget.IcsAdapterView;
import com.actionbarsherlock.internal.widget.IcsLinearLayout;
import com.actionbarsherlock.internal.widget.IcsProgressBar;
import com.actionbarsherlock.internal.widget.IcsSpinner;
import com.actionbarsherlock.internal.widget.ScrollingTabContainerView;
import com.actionbarsherlock.view.CollapsibleActionView;
import com.actionbarsherlock.view.Menu;
import com.actionbarsherlock.view.MenuItem;
import com.actionbarsherlock.view.Window;

public class ActionBarView
extends AbsActionBarView {
    private static final boolean DEBUG = false;
    private static final int DEFAULT_CUSTOM_GRAVITY = 19;
    public static final int DISPLAY_DEFAULT = 0;
    private static final int DISPLAY_RELAYOUT_MASK = 31;
    private static final String TAG = "ActionBarView";
    private ActionBar.OnNavigationListener mCallback;
    private ActionBarContextView mContextView;
    private View mCustomNavView;
    private int mDisplayOptions = -1;
    View mExpandedActionView;
    private final View.OnClickListener mExpandedActionViewUpListener;
    private HomeView mExpandedHomeLayout;
    private ExpandedActionViewMenuPresenter mExpandedMenuPresenter;
    private HomeView mHomeLayout;
    private Drawable mIcon;
    private boolean mIncludeTabs;
    private int mIndeterminateProgressStyle;
    private IcsProgressBar mIndeterminateProgressView;
    private boolean mIsCollapsable;
    private boolean mIsCollapsed;
    private int mItemPadding;
    private IcsLinearLayout mListNavLayout;
    private Drawable mLogo;
    private ActionMenuItem mLogoNavItem;
    private final IcsAdapterView.OnItemSelectedListener mNavItemSelectedListener = new IcsAdapterView.OnItemSelectedListener(){

        public void onItemSelected(IcsAdapterView icsAdapterView, View view, int n, long l) {
            if (ActionBarView.this.mCallback != null) {
                ActionBarView.this.mCallback.onNavigationItemSelected(n, l);
            }
        }

        public void onNothingSelected(IcsAdapterView icsAdapterView) {
        }
    };
    private int mNavigationMode;
    private MenuBuilder mOptionsMenu;
    private int mProgressBarPadding;
    private int mProgressStyle;
    private IcsProgressBar mProgressView;
    private IcsSpinner mSpinner;
    private SpinnerAdapter mSpinnerAdapter;
    private CharSequence mSubtitle;
    private int mSubtitleStyleRes;
    private TextView mSubtitleView;
    private ScrollingTabContainerView mTabScrollView;
    private CharSequence mTitle;
    private LinearLayout mTitleLayout;
    private int mTitleStyleRes;
    private View mTitleUpView;
    private TextView mTitleView;
    private final View.OnClickListener mUpClickListener;
    private boolean mUserTitle;
    Window.Callback mWindowCallback;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionBarView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mExpandedActionViewUpListener = new View.OnClickListener(){

            public void onClick(View view) {
                MenuItemImpl menuItemImpl = ((ActionBarView)ActionBarView.this).mExpandedMenuPresenter.mCurrentExpandedItem;
                if (menuItemImpl != null) {
                    menuItemImpl.collapseActionView();
                }
            }
        };
        this.mUpClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                ActionBarView.this.mWindowCallback.onMenuItemSelected(0, ActionBarView.this.mLogoNavItem);
            }
        };
        this.setBackgroundResource(0);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SherlockActionBar, R.attr.actionBarStyle, 0);
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        PackageManager packageManager = context.getPackageManager();
        this.mNavigationMode = typedArray.getInt(6, 0);
        this.mTitle = typedArray.getText(8);
        this.mSubtitle = typedArray.getText(9);
        this.mLogo = typedArray.getDrawable(11);
        if (this.mLogo == null) {
            if (Build.VERSION.SDK_INT < 11) {
                int n;
                if (context instanceof Activity && (n = ActionBarView.loadLogoFromManifest((Activity)context)) != 0) {
                    this.mLogo = context.getResources().getDrawable(n);
                }
            } else {
                if (context instanceof Activity) {
                    try {
                        this.mLogo = packageManager.getActivityLogo(((Activity)context).getComponentName());
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        Log.e((String)TAG, (String)"Activity component name not found!", (Throwable)nameNotFoundException);
                    }
                }
                if (this.mLogo == null) {
                    this.mLogo = applicationInfo.loadLogo(packageManager);
                }
            }
        }
        this.mIcon = typedArray.getDrawable(10);
        if (this.mIcon == null) {
            if (context instanceof Activity) {
                try {
                    this.mIcon = packageManager.getActivityIcon(((Activity)context).getComponentName());
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    Log.e((String)TAG, (String)"Activity component name not found!", (Throwable)nameNotFoundException);
                }
            }
            if (this.mIcon == null) {
                this.mIcon = applicationInfo.loadIcon(packageManager);
            }
        }
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        int n = typedArray.getResourceId(14, R.layout.abs__action_bar_home);
        this.mHomeLayout = (HomeView)layoutInflater.inflate(n, (ViewGroup)this, false);
        this.mExpandedHomeLayout = (HomeView)layoutInflater.inflate(n, (ViewGroup)this, false);
        this.mExpandedHomeLayout.setUp(true);
        this.mExpandedHomeLayout.setOnClickListener(this.mExpandedActionViewUpListener);
        this.mExpandedHomeLayout.setContentDescription(this.getResources().getText(R.string.abs__action_bar_up_description));
        this.mTitleStyleRes = typedArray.getResourceId(0, 0);
        this.mSubtitleStyleRes = typedArray.getResourceId(1, 0);
        this.mProgressStyle = typedArray.getResourceId(15, 0);
        this.mIndeterminateProgressStyle = typedArray.getResourceId(16, 0);
        this.mProgressBarPadding = typedArray.getDimensionPixelOffset(17, 0);
        this.mItemPadding = typedArray.getDimensionPixelOffset(18, 0);
        this.setDisplayOptions(typedArray.getInt(7, 0));
        int n2 = typedArray.getResourceId(13, 0);
        if (n2 != 0) {
            this.mCustomNavView = layoutInflater.inflate(n2, (ViewGroup)this, false);
            this.mNavigationMode = 0;
            this.setDisplayOptions(0x10 | this.mDisplayOptions);
        }
        this.mContentHeight = typedArray.getLayoutDimension(4, 0);
        typedArray.recycle();
        this.mLogoNavItem = new ActionMenuItem(context, 0, 16908332, 0, 0, this.mTitle);
        this.mHomeLayout.setOnClickListener(this.mUpClickListener);
        this.mHomeLayout.setClickable(true);
        this.mHomeLayout.setFocusable(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configPresenters(MenuBuilder menuBuilder) {
        if (menuBuilder != null) {
            menuBuilder.addMenuPresenter(this.mActionMenuPresenter);
            menuBuilder.addMenuPresenter(this.mExpandedMenuPresenter);
            return;
        }
        this.mActionMenuPresenter.initForMenu(this.mContext, null);
        this.mExpandedMenuPresenter.initForMenu(this.mContext, null);
        this.mActionMenuPresenter.updateMenuView(true);
        this.mExpandedMenuPresenter.updateMenuView(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initTitle() {
        boolean bl = true;
        if (this.mTitleLayout == null) {
            this.mTitleLayout = (LinearLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.abs__action_bar_title_item, (ViewGroup)this, false);
            this.mTitleView = (TextView)this.mTitleLayout.findViewById(R.id.abs__action_bar_title);
            this.mSubtitleView = (TextView)this.mTitleLayout.findViewById(R.id.abs__action_bar_subtitle);
            this.mTitleUpView = this.mTitleLayout.findViewById(R.id.abs__up);
            this.mTitleLayout.setOnClickListener(this.mUpClickListener);
            if (this.mTitleStyleRes != 0) {
                this.mTitleView.setTextAppearance(this.mContext, this.mTitleStyleRes);
            }
            if (this.mTitle != null) {
                this.mTitleView.setText(this.mTitle);
            }
            if (this.mSubtitleStyleRes != 0) {
                this.mSubtitleView.setTextAppearance(this.mContext, this.mSubtitleStyleRes);
            }
            if (this.mSubtitle != null) {
                this.mSubtitleView.setText(this.mSubtitle);
                this.mSubtitleView.setVisibility(0);
            }
            boolean bl2 = (4 & this.mDisplayOptions) != 0 ? bl : false;
            boolean bl3 = (2 & this.mDisplayOptions) != 0 ? bl : false;
            View view = this.mTitleUpView;
            int n = !bl3 ? (bl2 ? 0 : 4) : 8;
            view.setVisibility(n);
            LinearLayout linearLayout = this.mTitleLayout;
            if (!bl2 || bl3) {
                bl = false;
            }
            linearLayout.setEnabled(bl);
        }
        this.addView((View)this.mTitleLayout);
        if (this.mExpandedActionView != null || TextUtils.isEmpty((CharSequence)this.mTitle) && TextUtils.isEmpty((CharSequence)this.mSubtitle)) {
            this.mTitleLayout.setVisibility(8);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int loadLogoFromManifest(Activity var0) {
        block16: {
            block15: {
                block14: {
                    block12: {
                        block13: {
                            var1_1 = 0;
                            try {
                                block11: {
                                    var3_2 = var0.getClass().getName();
                                    var4_3 = var0.getApplicationInfo().packageName;
                                    var5_4 = var0.createPackageContext(var4_3, 0).getAssets().openXmlResourceParser("AndroidManifest.xml");
                                    var6_5 = var5_4.getEventType();
                                    block2: while (var6_5 != 1) {
                                        if (var6_5 == 2) {
                                            var7_6 = var5_4.getName();
                                            if (!"application".equals(var7_6)) break block11;
                                            var14_13 = -1 + var5_4.getAttributeCount();
                                            break block12;
                                        }
lbl13:
                                        // 6 sources

                                        while (true) {
                                            var6_5 = var5_4.nextToken();
                                            continue block2;
                                            break;
                                        }
                                    }
                                    break block13;
lbl17:
                                    // 1 sources

                                    while ("logo".equals(var5_4.getAttributeName(var14_13))) {
                                        var1_1 = var5_4.getAttributeResourceValue(var14_13, 0);
                                        ** GOTO lbl13
                                    }
                                    break block14;
                                }
                                if (!"activity".equals(var7_6)) ** GOTO lbl13
                                var8_7 = null;
                                var9_8 = null;
                                var10_9 = false;
                                var11_10 = -1 + var5_4.getAttributeCount();
lbl27:
                                // 2 sources

                                while (true) {
                                    if (var11_10 < 0) break block15;
                                    var12_11 = var5_4.getAttributeName(var11_10);
                                    if ("logo".equals(var12_11)) {
                                        var8_7 = var5_4.getAttributeResourceValue(var11_10, 0);
lbl32:
                                        // 3 sources

                                        while (var8_7 != null && var9_8 != null) {
                                            var1_1 = var8_7;
                                            break block16;
                                        }
                                        break block16;
                                    }
                                    if (!"name".equals(var12_11)) ** GOTO lbl32
                                    var9_8 = ActionBarSherlockCompat.cleanActivityName(var4_3, var5_4.getAttributeValue(var11_10));
                                    var13_12 = var3_2.equals(var9_8);
                                    if (!var13_12) break block15;
                                    var10_9 = true;
                                    ** GOTO lbl32
                                    break;
                                }
                            }
                            catch (Exception var2_14) {
                                var2_14.printStackTrace();
                            }
                        }
lbl45:
                        // 2 sources

                        return var1_1;
                    }
lbl48:
                    // 2 sources

                    while (var14_13 < 0) {
                        ** GOTO lbl13
                    }
                    ** GOTO lbl17
                }
                --var14_13;
                ** GOTO lbl48
            }
            if (var10_9) ** break;
            ** while (true)
            ** while (true)
        }
        --var11_10;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setTitleImpl(CharSequence charSequence) {
        int n = 0;
        this.mTitle = charSequence;
        if (this.mTitleView != null) {
            this.mTitleView.setText(charSequence);
            int n2 = this.mExpandedActionView == null && (8 & this.mDisplayOptions) != 0 && (!TextUtils.isEmpty((CharSequence)this.mTitle) || !TextUtils.isEmpty((CharSequence)this.mSubtitle)) ? 1 : n;
            LinearLayout linearLayout = this.mTitleLayout;
            if (n2 == 0) {
                n = 8;
            }
            linearLayout.setVisibility(n);
        }
        if (this.mLogoNavItem != null) {
            this.mLogoNavItem.setTitle(charSequence);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void collapseActionView() {
        if (this.mExpandedMenuPresenter == null) {
            return;
        }
        MenuItemImpl menuItemImpl = this.mExpandedMenuPresenter.mCurrentExpandedItem;
        if (menuItemImpl == null) return;
        menuItemImpl.collapseActionView();
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ActionBar.LayoutParams(19);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ActionBar.LayoutParams(this.getContext(), attributeSet);
    }

    public ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams == null) {
            layoutParams = this.generateDefaultLayoutParams();
        }
        return layoutParams;
    }

    public View getCustomNavigationView() {
        return this.mCustomNavView;
    }

    public int getDisplayOptions() {
        return this.mDisplayOptions;
    }

    public SpinnerAdapter getDropdownAdapter() {
        return this.mSpinnerAdapter;
    }

    public int getDropdownSelectedPosition() {
        return this.mSpinner.getSelectedItemPosition();
    }

    public int getNavigationMode() {
        return this.mNavigationMode;
    }

    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public boolean hasEmbeddedTabs() {
        return this.mIncludeTabs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasExpandedActionView() {
        if (this.mExpandedMenuPresenter == null) return false;
        if (this.mExpandedMenuPresenter.mCurrentExpandedItem == null) return false;
        return true;
    }

    public void initIndeterminateProgress() {
        this.mIndeterminateProgressView = new IcsProgressBar(this.mContext, null, 0, this.mIndeterminateProgressStyle);
        this.mIndeterminateProgressView.setId(R.id.abs__progress_circular);
        this.addView(this.mIndeterminateProgressView);
    }

    public void initProgress() {
        this.mProgressView = new IcsProgressBar(this.mContext, null, 0, this.mProgressStyle);
        this.mProgressView.setId(R.id.abs__progress_horizontal);
        this.mProgressView.setMax(10000);
        this.addView(this.mProgressView);
    }

    public boolean isCollapsed() {
        return this.mIsCollapsed;
    }

    public boolean isSplitActionBar() {
        return this.mSplitActionBar;
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.mTitleView = null;
        this.mSubtitleView = null;
        this.mTitleUpView = null;
        if (this.mTitleLayout != null && this.mTitleLayout.getParent() == this) {
            this.removeView((View)this.mTitleLayout);
        }
        this.mTitleLayout = null;
        if ((8 & this.mDisplayOptions) != 0) {
            this.initTitle();
        }
        if (this.mTabScrollView != null && this.mIncludeTabs) {
            ViewGroup.LayoutParams layoutParams = this.mTabScrollView.getLayoutParams();
            if (layoutParams != null) {
                layoutParams.width = -2;
                layoutParams.height = -1;
            }
            this.mTabScrollView.setAllowCollapse(true);
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.hideOverflowMenu();
            this.mActionMenuPresenter.hideSubMenus();
        }
    }

    protected void onFinishInflate() {
        ViewParent viewParent;
        super.onFinishInflate();
        this.addView((View)this.mHomeLayout);
        if (this.mCustomNavView != null && (0x10 & this.mDisplayOptions) != 0 && (viewParent = this.mCustomNavView.getParent()) != this) {
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(this.mCustomNavView);
            }
            this.addView(this.mCustomNavView);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        block31: {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            View view;
            int n10;
            int n11;
            block33: {
                block32: {
                    n11 = this.getPaddingLeft();
                    int n12 = this.getPaddingTop();
                    int n13 = n4 - n2 - this.getPaddingTop() - this.getPaddingBottom();
                    if (n13 <= 0) {
                        return;
                    }
                    HomeView homeView = this.mExpandedActionView != null ? this.mExpandedHomeLayout : this.mHomeLayout;
                    if (homeView.getVisibility() != 8) {
                        int n14 = homeView.getLeftOffset();
                        n11 += n14 + this.positionChild((View)homeView, n11 + n14, n12, n13);
                    }
                    if (this.mExpandedActionView == null) {
                        boolean bl2 = this.mTitleLayout != null && this.mTitleLayout.getVisibility() != 8 && (8 & this.mDisplayOptions) != 0;
                        if (bl2) {
                            n11 += this.positionChild((View)this.mTitleLayout, n11, n12, n13);
                        }
                        switch (this.mNavigationMode) {
                            case 1: {
                                if (this.mListNavLayout == null) break;
                                if (bl2) {
                                    n11 += this.mItemPadding;
                                }
                                n11 += this.positionChild((View)this.mListNavLayout, n11, n12, n13) + this.mItemPadding;
                                break;
                            }
                            case 2: {
                                if (this.mTabScrollView == null) break;
                                if (bl2) {
                                    n11 += this.mItemPadding;
                                }
                                n11 += this.positionChild((View)this.mTabScrollView, n11, n12, n13) + this.mItemPadding;
                                break;
                            }
                        }
                    }
                    n10 = n3 - n - this.getPaddingRight();
                    if (this.mMenuView != null && this.mMenuView.getParent() == this) {
                        this.positionChildInverse((View)this.mMenuView, n10, n12, n13);
                        n10 -= this.mMenuView.getMeasuredWidth();
                    }
                    if (this.mIndeterminateProgressView != null && this.mIndeterminateProgressView.getVisibility() != 8) {
                        this.positionChildInverse(this.mIndeterminateProgressView, n10, n12, n13);
                        n10 -= this.mIndeterminateProgressView.getMeasuredWidth();
                    }
                    view = null;
                    if (this.mExpandedActionView != null) {
                        view = this.mExpandedActionView;
                    } else if ((0x10 & this.mDisplayOptions) != 0 && this.mCustomNavView != null) {
                        view = this.mCustomNavView;
                    }
                    if (view == null) break block31;
                    ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                    ActionBar.LayoutParams layoutParams2 = layoutParams instanceof ActionBar.LayoutParams ? (ActionBar.LayoutParams)layoutParams : null;
                    n9 = layoutParams2 != null ? layoutParams2.gravity : 19;
                    n8 = view.getMeasuredWidth();
                    n7 = 0;
                    n6 = 0;
                    if (layoutParams2 != null) {
                        n11 += layoutParams2.leftMargin;
                        n10 -= layoutParams2.rightMargin;
                        n7 = layoutParams2.topMargin;
                        n6 = layoutParams2.bottomMargin;
                    }
                    if ((n5 = n9 & 7) != 1) break block32;
                    int n15 = (this.getRight() - this.getLeft() - n8) / 2;
                    if (n15 < n11) {
                        n5 = 3;
                        break block33;
                    } else if (n15 + n8 > n10) {
                        n5 = 5;
                    }
                    break block33;
                }
                if (n9 == -1) {
                    n5 = 3;
                }
            }
            int n16 = 0;
            switch (n5) {
                case 1: {
                    n16 = (this.getRight() - this.getLeft() - n8) / 2;
                    break;
                }
                case 3: {
                    n16 = n11;
                    break;
                }
                case 5: {
                    n16 = n10 - n8;
                    break;
                }
            }
            int n17 = n9 & 0x70;
            if (n9 == -1) {
                n17 = 16;
            }
            int n18 = 0;
            switch (n17) {
                case 16: {
                    int n19 = this.getPaddingTop();
                    n18 = (this.getBottom() - this.getTop() - this.getPaddingBottom() - n19 - view.getMeasuredHeight()) / 2;
                    break;
                }
                case 48: {
                    n18 = n7 + this.getPaddingTop();
                    break;
                }
                case 80: {
                    n18 = this.getHeight() - this.getPaddingBottom() - view.getMeasuredHeight() - n6;
                    break;
                }
            }
            int n20 = view.getMeasuredWidth();
            int n21 = n16 + n20;
            int n22 = n18 + view.getMeasuredHeight();
            view.layout(n16, n18, n21, n22);
            int cfr_ignored_0 = n11 + n20;
        }
        if (this.mProgressView == null) return;
        this.mProgressView.bringToFront();
        int n23 = this.mProgressView.getMeasuredHeight() / 2;
        this.mProgressView.layout(this.mProgressBarPadding, -n23, this.mProgressBarPadding + this.mProgressView.getMeasuredWidth(), n23);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n, int n2) {
        int n3;
        int n4 = this.getChildCount();
        if (this.mIsCollapsable) {
            int n5 = 0;
            int n6 = 0;
            while (true) {
                if (n6 >= n4) {
                    if (n5 != 0) break;
                    this.setMeasuredDimension(0, 0);
                    this.mIsCollapsed = true;
                    return;
                }
                View view = this.getChildAt(n6);
                if (view.getVisibility() != 8 && (view != this.mMenuView || this.mMenuView.getChildCount() != 0)) {
                    ++n5;
                }
                ++n6;
            }
        }
        this.mIsCollapsed = false;
        if (View.MeasureSpec.getMode((int)n) != 0x40000000) {
            throw new IllegalStateException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " can only be used " + "with android:layout_width=\"match_parent\" (or fill_parent)");
        }
        if (View.MeasureSpec.getMode((int)n2) != Integer.MIN_VALUE) {
            throw new IllegalStateException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " can only be used " + "with android:layout_height=\"wrap_content\"");
        }
        int n7 = View.MeasureSpec.getSize((int)n);
        int n8 = this.mContentHeight > 0 ? this.mContentHeight : View.MeasureSpec.getSize((int)n2);
        int n9 = this.getPaddingTop() + this.getPaddingBottom();
        int n10 = this.getPaddingLeft();
        int n11 = this.getPaddingRight();
        int n12 = n8 - n9;
        int n13 = View.MeasureSpec.makeMeasureSpec((int)n12, (int)Integer.MIN_VALUE);
        int n14 = n7 - n10 - n11;
        int n15 = n3 = n14 / 2;
        HomeView homeView = this.mExpandedActionView != null ? this.mExpandedHomeLayout : this.mHomeLayout;
        if (homeView.getVisibility() != 8) {
            ViewGroup.LayoutParams layoutParams = homeView.getLayoutParams();
            int n16 = layoutParams.width < 0 ? View.MeasureSpec.makeMeasureSpec((int)n14, (int)Integer.MIN_VALUE) : View.MeasureSpec.makeMeasureSpec((int)layoutParams.width, (int)0x40000000);
            int n17 = View.MeasureSpec.makeMeasureSpec((int)n12, (int)0x40000000);
            homeView.measure(n16, n17);
            int n18 = homeView.getMeasuredWidth() + homeView.getLeftOffset();
            n14 = Math.max(0, n14 - n18);
            n3 = Math.max(0, n14 - n18);
        }
        if (this.mMenuView != null && this.mMenuView.getParent() == this) {
            n14 = this.measureChildView((View)this.mMenuView, n14, n13, 0);
            n15 = Math.max(0, n15 - this.mMenuView.getMeasuredWidth());
        }
        if (this.mIndeterminateProgressView != null && this.mIndeterminateProgressView.getVisibility() != 8) {
            n14 = this.measureChildView(this.mIndeterminateProgressView, n14, n13, 0);
            n15 = Math.max(0, n15 - this.mIndeterminateProgressView.getMeasuredWidth());
        }
        boolean bl = this.mTitleLayout != null && this.mTitleLayout.getVisibility() != 8 && (8 & this.mDisplayOptions) != 0;
        if (this.mExpandedActionView == null) {
            switch (this.mNavigationMode) {
                case 1: {
                    if (this.mListNavLayout == null) break;
                    int n19 = bl ? 2 * this.mItemPadding : this.mItemPadding;
                    int n20 = Math.max(0, n14 - n19);
                    int n21 = Math.max(0, n3 - n19);
                    this.mListNavLayout.measure(View.MeasureSpec.makeMeasureSpec((int)n20, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)n12, (int)0x40000000));
                    int n22 = this.mListNavLayout.getMeasuredWidth();
                    n14 = Math.max(0, n20 - n22);
                    n3 = Math.max(0, n21 - n22);
                    break;
                }
                case 2: {
                    if (this.mTabScrollView == null) break;
                    int n23 = bl ? 2 * this.mItemPadding : this.mItemPadding;
                    int n24 = Math.max(0, n14 - n23);
                    int n25 = Math.max(0, n3 - n23);
                    this.mTabScrollView.measure(View.MeasureSpec.makeMeasureSpec((int)n24, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)n12, (int)0x40000000));
                    int n26 = this.mTabScrollView.getMeasuredWidth();
                    n14 = Math.max(0, n24 - n26);
                    n3 = Math.max(0, n25 - n26);
                    break;
                }
            }
        }
        View view = null;
        if (this.mExpandedActionView != null) {
            view = this.mExpandedActionView;
        } else if ((0x10 & this.mDisplayOptions) != 0 && this.mCustomNavView != null) {
            view = this.mCustomNavView;
        }
        if (view != null) {
            ViewGroup.LayoutParams layoutParams = this.generateLayoutParams(view.getLayoutParams());
            ActionBar.LayoutParams layoutParams2 = layoutParams instanceof ActionBar.LayoutParams ? (ActionBar.LayoutParams)layoutParams : null;
            int n27 = 0;
            int n28 = 0;
            if (layoutParams2 != null) {
                n27 = layoutParams2.leftMargin + layoutParams2.rightMargin;
                n28 = layoutParams2.topMargin + layoutParams2.bottomMargin;
            }
            int n29 = this.mContentHeight <= 0 ? Integer.MIN_VALUE : (layoutParams.height != -2 ? 0x40000000 : Integer.MIN_VALUE);
            if (layoutParams.height >= 0) {
                n12 = Math.min(layoutParams.height, n12);
            }
            int n30 = Math.max(0, n12 - n28);
            int n31 = layoutParams.width != -2 ? 0x40000000 : Integer.MIN_VALUE;
            int n32 = layoutParams.width >= 0 ? Math.min(layoutParams.width, n14) : n14;
            int n33 = Math.max(0, n32 - n27);
            int n34 = layoutParams2 != null ? layoutParams2.gravity : 19;
            if ((n34 & 7) == 1 && layoutParams.width == -1) {
                n33 = 2 * Math.min(n3, n15);
            }
            view.measure(View.MeasureSpec.makeMeasureSpec((int)n33, (int)n31), View.MeasureSpec.makeMeasureSpec((int)n30, (int)n29));
            n14 -= n27 + view.getMeasuredWidth();
        }
        if (this.mExpandedActionView == null && bl) {
            this.measureChildView((View)this.mTitleLayout, n14, View.MeasureSpec.makeMeasureSpec((int)this.mContentHeight, (int)0x40000000), 0);
            Math.max(0, n3 - this.mTitleLayout.getMeasuredWidth());
        }
        if (this.mContentHeight > 0) {
            this.setMeasuredDimension(n7, n8);
        } else {
            int n35 = 0;
            int n36 = 0;
            while (true) {
                if (n36 >= n4) {
                    this.setMeasuredDimension(n7, n35);
                    break;
                }
                int n37 = n9 + this.getChildAt(n36).getMeasuredHeight();
                if (n37 > n35) {
                    n35 = n37;
                }
                ++n36;
            }
        }
        if (this.mContextView != null) {
            this.mContextView.setContentHeight(this.getMeasuredHeight());
        }
        if (this.mProgressView == null) return;
        if (this.mProgressView.getVisibility() == 8) return;
        this.mProgressView.measure(View.MeasureSpec.makeMeasureSpec((int)(n7 - 2 * this.mProgressBarPadding), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)Integer.MIN_VALUE));
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        MenuItem menuItem;
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        if (savedState.expandedMenuItemId != 0 && this.mExpandedMenuPresenter != null && this.mOptionsMenu != null && (menuItem = this.mOptionsMenu.findItem(savedState.expandedMenuItemId)) != null) {
            menuItem.expandActionView();
        }
        if (savedState.isOverflowOpen) {
            this.postShowOverflowMenu();
        }
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        if (this.mExpandedMenuPresenter != null && this.mExpandedMenuPresenter.mCurrentExpandedItem != null) {
            savedState.expandedMenuItemId = this.mExpandedMenuPresenter.mCurrentExpandedItem.getItemId();
        }
        savedState.isOverflowOpen = this.isOverflowMenuShowing();
        return savedState;
    }

    public void setCallback(ActionBar.OnNavigationListener onNavigationListener) {
        this.mCallback = onNavigationListener;
    }

    public void setCollapsable(boolean bl) {
        this.mIsCollapsable = bl;
    }

    public void setContextView(ActionBarContextView actionBarContextView) {
        this.mContextView = actionBarContextView;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCustomNavigationView(View view) {
        boolean bl = (0x10 & this.mDisplayOptions) != 0;
        if (this.mCustomNavView != null && bl) {
            this.removeView(this.mCustomNavView);
        }
        this.mCustomNavView = view;
        if (this.mCustomNavView != null && bl) {
            this.addView(this.mCustomNavView);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDisplayOptions(int n) {
        int n2 = 8;
        int n3 = -1;
        boolean bl = true;
        if (this.mDisplayOptions != n3) {
            n3 = n ^ this.mDisplayOptions;
        }
        this.mDisplayOptions = n;
        if ((n3 & 0x1F) != 0) {
            boolean bl2 = (n & 2) != 0 ? bl : false;
            int n4 = bl2 && this.mExpandedActionView == null ? 0 : n2;
            this.mHomeLayout.setVisibility(n4);
            if ((n3 & 4) != 0) {
                boolean bl3 = (n & 4) != 0 ? bl : false;
                this.mHomeLayout.setUp(bl3);
                if (bl3) {
                    this.setHomeButtonEnabled(bl);
                }
            }
            if ((n3 & 1) != 0) {
                boolean bl4 = this.mLogo != null && (n & 1) != 0 ? bl : false;
                HomeView homeView = this.mHomeLayout;
                Drawable drawable2 = bl4 ? this.mLogo : this.mIcon;
                homeView.setIcon(drawable2);
            }
            if ((n3 & 8) != 0) {
                if ((n & 8) != 0) {
                    this.initTitle();
                } else {
                    this.removeView((View)this.mTitleLayout);
                }
            }
            if (this.mTitleLayout != null && (n3 & 6) != 0) {
                boolean bl5 = (4 & this.mDisplayOptions) != 0 ? bl : false;
                View view = this.mTitleUpView;
                if (!bl2) {
                    n2 = bl5 ? 0 : 4;
                }
                view.setVisibility(n2);
                LinearLayout linearLayout = this.mTitleLayout;
                if (bl2 || !bl5) {
                    bl = false;
                }
                linearLayout.setEnabled(bl);
            }
            if ((n3 & 0x10) != 0 && this.mCustomNavView != null) {
                if ((n & 0x10) != 0) {
                    this.addView(this.mCustomNavView);
                } else {
                    this.removeView(this.mCustomNavView);
                }
            }
            this.requestLayout();
        } else {
            this.invalidate();
        }
        if (!this.mHomeLayout.isEnabled()) {
            this.mHomeLayout.setContentDescription(null);
            return;
        }
        if ((n & 4) != 0) {
            this.mHomeLayout.setContentDescription(this.mContext.getResources().getText(R.string.abs__action_bar_up_description));
            return;
        }
        this.mHomeLayout.setContentDescription(this.mContext.getResources().getText(R.string.abs__action_bar_home_description));
    }

    public void setDropdownAdapter(SpinnerAdapter spinnerAdapter) {
        this.mSpinnerAdapter = spinnerAdapter;
        if (this.mSpinner != null) {
            this.mSpinner.setAdapter(spinnerAdapter);
        }
    }

    public void setDropdownSelectedPosition(int n) {
        this.mSpinner.setSelection(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setEmbeddedTabView(ScrollingTabContainerView scrollingTabContainerView) {
        if (this.mTabScrollView != null) {
            this.removeView((View)this.mTabScrollView);
        }
        this.mTabScrollView = scrollingTabContainerView;
        boolean bl = scrollingTabContainerView != null;
        this.mIncludeTabs = bl;
        if (this.mIncludeTabs && this.mNavigationMode == 2) {
            this.addView((View)this.mTabScrollView);
            ViewGroup.LayoutParams layoutParams = this.mTabScrollView.getLayoutParams();
            layoutParams.width = -2;
            layoutParams.height = -1;
            scrollingTabContainerView.setAllowCollapse(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setHomeButtonEnabled(boolean bl) {
        this.mHomeLayout.setEnabled(bl);
        this.mHomeLayout.setFocusable(bl);
        if (!bl) {
            this.mHomeLayout.setContentDescription(null);
            return;
        }
        if ((4 & this.mDisplayOptions) != 0) {
            this.mHomeLayout.setContentDescription(this.mContext.getResources().getText(R.string.abs__action_bar_up_description));
            return;
        }
        this.mHomeLayout.setContentDescription(this.mContext.getResources().getText(R.string.abs__action_bar_home_description));
    }

    public void setIcon(int n) {
        this.setIcon(this.mContext.getResources().getDrawable(n));
    }

    public void setIcon(Drawable drawable2) {
        this.mIcon = drawable2;
        if (drawable2 != null && ((1 & this.mDisplayOptions) == 0 || this.mLogo == null)) {
            this.mHomeLayout.setIcon(drawable2);
        }
    }

    public void setLogo(int n) {
        this.setLogo(this.mContext.getResources().getDrawable(n));
    }

    public void setLogo(Drawable drawable2) {
        this.mLogo = drawable2;
        if (drawable2 != null && (1 & this.mDisplayOptions) != 0) {
            this.mHomeLayout.setIcon(drawable2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setMenu(Menu menu2, MenuPresenter.Callback callback) {
        ActionMenuView actionMenuView;
        ViewGroup viewGroup;
        MenuBuilder menuBuilder;
        if (menu2 == this.mOptionsMenu) {
            return;
        }
        if (this.mOptionsMenu != null) {
            this.mOptionsMenu.removeMenuPresenter(this.mActionMenuPresenter);
            this.mOptionsMenu.removeMenuPresenter(this.mExpandedMenuPresenter);
        }
        this.mOptionsMenu = menuBuilder = (MenuBuilder)menu2;
        if (this.mMenuView != null && (viewGroup = (ViewGroup)this.mMenuView.getParent()) != null) {
            viewGroup.removeView((View)this.mMenuView);
        }
        if (this.mActionMenuPresenter == null) {
            this.mActionMenuPresenter = new ActionMenuPresenter(this.mContext);
            this.mActionMenuPresenter.setCallback(callback);
            this.mActionMenuPresenter.setId(R.id.abs__action_menu_presenter);
            this.mExpandedMenuPresenter = new ExpandedActionViewMenuPresenter();
        }
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -1);
        if (!this.mSplitActionBar) {
            this.mActionMenuPresenter.setExpandedActionViewsExclusive(ResourcesCompat.getResources_getBoolean(this.getContext(), R.bool.abs__action_bar_expanded_action_views_exclusive));
            this.configPresenters(menuBuilder);
            actionMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
            ViewGroup viewGroup2 = (ViewGroup)actionMenuView.getParent();
            if (viewGroup2 != null && viewGroup2 != this) {
                viewGroup2.removeView((View)actionMenuView);
            }
            this.addView((View)actionMenuView, layoutParams);
        } else {
            this.mActionMenuPresenter.setExpandedActionViewsExclusive(false);
            this.mActionMenuPresenter.setWidthLimit(this.getContext().getResources().getDisplayMetrics().widthPixels, true);
            this.mActionMenuPresenter.setItemLimit(Integer.MAX_VALUE);
            layoutParams.width = -1;
            this.configPresenters(menuBuilder);
            actionMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
            if (this.mSplitView != null) {
                ViewGroup viewGroup3 = (ViewGroup)actionMenuView.getParent();
                if (viewGroup3 != null && viewGroup3 != this.mSplitView) {
                    viewGroup3.removeView((View)actionMenuView);
                }
                actionMenuView.setVisibility(this.getAnimatedVisibility());
                this.mSplitView.addView((View)actionMenuView, layoutParams);
            } else {
                actionMenuView.setLayoutParams(layoutParams);
            }
        }
        this.mMenuView = actionMenuView;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setNavigationMode(int n) {
        int n2 = this.mNavigationMode;
        if (n != n2) {
            switch (n2) {
                case 1: {
                    if (this.mListNavLayout != null) {
                        this.removeView((View)this.mListNavLayout);
                    }
                }
                default: {
                    break;
                }
                case 2: {
                    if (this.mTabScrollView == null || !this.mIncludeTabs) break;
                    this.removeView((View)this.mTabScrollView);
                }
            }
            switch (n) {
                case 1: {
                    if (this.mSpinner == null) {
                        this.mSpinner = new IcsSpinner(this.mContext, null, R.attr.actionDropDownStyle);
                        this.mListNavLayout = (IcsLinearLayout)LayoutInflater.from((Context)this.mContext).inflate(R.layout.abs__action_bar_tab_bar_view, null);
                        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -1);
                        layoutParams.gravity = 17;
                        this.mListNavLayout.addView((View)this.mSpinner, (ViewGroup.LayoutParams)layoutParams);
                    }
                    if (this.mSpinner.getAdapter() != this.mSpinnerAdapter) {
                        this.mSpinner.setAdapter(this.mSpinnerAdapter);
                    }
                    this.mSpinner.setOnItemSelectedListener(this.mNavItemSelectedListener);
                    this.addView((View)this.mListNavLayout);
                }
                default: {
                    break;
                }
                case 2: {
                    if (this.mTabScrollView == null || !this.mIncludeTabs) break;
                    this.addView((View)this.mTabScrollView);
                }
            }
            this.mNavigationMode = n;
            this.requestLayout();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setSplitActionBar(boolean bl) {
        if (this.mSplitActionBar != bl) {
            if (this.mMenuView != null) {
                ViewGroup viewGroup = (ViewGroup)this.mMenuView.getParent();
                if (viewGroup != null) {
                    viewGroup.removeView((View)this.mMenuView);
                }
                if (bl) {
                    if (this.mSplitView != null) {
                        this.mSplitView.addView((View)this.mMenuView);
                    }
                } else {
                    this.addView((View)this.mMenuView);
                }
            }
            if (this.mSplitView != null) {
                ActionBarContainer actionBarContainer = this.mSplitView;
                int n = bl ? 0 : 8;
                actionBarContainer.setVisibility(n);
            }
            super.setSplitActionBar(bl);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSubtitle(CharSequence charSequence) {
        int n = 0;
        this.mSubtitle = charSequence;
        if (this.mSubtitleView != null) {
            this.mSubtitleView.setText(charSequence);
            TextView textView = this.mSubtitleView;
            int n2 = charSequence != null ? n : 8;
            textView.setVisibility(n2);
            int n3 = this.mExpandedActionView == null && (8 & this.mDisplayOptions) != 0 && (!TextUtils.isEmpty((CharSequence)this.mTitle) || !TextUtils.isEmpty((CharSequence)this.mSubtitle)) ? 1 : n;
            LinearLayout linearLayout = this.mTitleLayout;
            if (n3 == 0) {
                n = 8;
            }
            linearLayout.setVisibility(n);
        }
    }

    public void setTitle(CharSequence charSequence) {
        this.mUserTitle = true;
        this.setTitleImpl(charSequence);
    }

    public void setWindowCallback(Window.Callback callback) {
        this.mWindowCallback = callback;
    }

    public void setWindowTitle(CharSequence charSequence) {
        if (!this.mUserTitle) {
            this.setTitleImpl(charSequence);
        }
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    private class ExpandedActionViewMenuPresenter
    implements MenuPresenter {
        MenuItemImpl mCurrentExpandedItem;
        MenuBuilder mMenu;

        private ExpandedActionViewMenuPresenter() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean collapseItemActionView(MenuBuilder menuBuilder, MenuItemImpl menuItemImpl) {
            if (ActionBarView.this.mExpandedActionView instanceof CollapsibleActionView) {
                ((CollapsibleActionView)ActionBarView.this.mExpandedActionView).onActionViewCollapsed();
            }
            ActionBarView.this.removeView(ActionBarView.this.mExpandedActionView);
            ActionBarView.this.removeView((View)ActionBarView.this.mExpandedHomeLayout);
            ActionBarView.this.mExpandedActionView = null;
            if ((2 & ActionBarView.this.mDisplayOptions) != 0) {
                ActionBarView.this.mHomeLayout.setVisibility(0);
            }
            if ((8 & ActionBarView.this.mDisplayOptions) != 0) {
                if (ActionBarView.this.mTitleLayout == null) {
                    ActionBarView.this.initTitle();
                } else {
                    ActionBarView.this.mTitleLayout.setVisibility(0);
                }
            }
            if (ActionBarView.this.mTabScrollView != null && ActionBarView.this.mNavigationMode == 2) {
                ActionBarView.this.mTabScrollView.setVisibility(0);
            }
            if (ActionBarView.this.mSpinner != null && ActionBarView.this.mNavigationMode == 1) {
                ActionBarView.this.mSpinner.setVisibility(0);
            }
            if (ActionBarView.this.mCustomNavView != null && (0x10 & ActionBarView.this.mDisplayOptions) != 0) {
                ActionBarView.this.mCustomNavView.setVisibility(0);
            }
            ActionBarView.this.mExpandedHomeLayout.setIcon(null);
            this.mCurrentExpandedItem = null;
            ActionBarView.this.requestLayout();
            menuItemImpl.setActionViewExpanded(false);
            return true;
        }

        @Override
        public boolean expandItemActionView(MenuBuilder menuBuilder, MenuItemImpl menuItemImpl) {
            ActionBarView.this.mExpandedActionView = menuItemImpl.getActionView();
            ActionBarView.this.mExpandedHomeLayout.setIcon(ActionBarView.this.mIcon.getConstantState().newDrawable());
            this.mCurrentExpandedItem = menuItemImpl;
            if (ActionBarView.this.mExpandedActionView.getParent() != ActionBarView.this) {
                ActionBarView.this.addView(ActionBarView.this.mExpandedActionView);
            }
            if (ActionBarView.this.mExpandedHomeLayout.getParent() != ActionBarView.this) {
                ActionBarView.this.addView((View)ActionBarView.this.mExpandedHomeLayout);
            }
            ActionBarView.this.mHomeLayout.setVisibility(8);
            if (ActionBarView.this.mTitleLayout != null) {
                ActionBarView.this.mTitleLayout.setVisibility(8);
            }
            if (ActionBarView.this.mTabScrollView != null) {
                ActionBarView.this.mTabScrollView.setVisibility(8);
            }
            if (ActionBarView.this.mSpinner != null) {
                ActionBarView.this.mSpinner.setVisibility(8);
            }
            if (ActionBarView.this.mCustomNavView != null) {
                ActionBarView.this.mCustomNavView.setVisibility(8);
            }
            ActionBarView.this.requestLayout();
            menuItemImpl.setActionViewExpanded(true);
            if (ActionBarView.this.mExpandedActionView instanceof CollapsibleActionView) {
                ((CollapsibleActionView)ActionBarView.this.mExpandedActionView).onActionViewExpanded();
            }
            return true;
        }

        @Override
        public boolean flagActionItems() {
            return false;
        }

        @Override
        public int getId() {
            return 0;
        }

        @Override
        public MenuView getMenuView(ViewGroup viewGroup) {
            return null;
        }

        @Override
        public void initForMenu(Context context, MenuBuilder menuBuilder) {
            if (this.mMenu != null && this.mCurrentExpandedItem != null) {
                this.mMenu.collapseItemActionView(this.mCurrentExpandedItem);
            }
            this.mMenu = menuBuilder;
        }

        @Override
        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
        }

        @Override
        public void onRestoreInstanceState(Parcelable parcelable) {
        }

        @Override
        public Parcelable onSaveInstanceState() {
            return null;
        }

        @Override
        public boolean onSubMenuSelected(SubMenuBuilder subMenuBuilder) {
            return false;
        }

        @Override
        public void setCallback(MenuPresenter.Callback callback) {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void updateMenuView(boolean bl) {
            if (this.mCurrentExpandedItem == null) return;
            boolean bl2 = false;
            if (this.mMenu != null) {
                int n = this.mMenu.size();
                int n2 = 0;
                while (true) {
                    if (n2 >= n) break;
                    if (this.mMenu.getItem(n2) == this.mCurrentExpandedItem) {
                        return;
                    }
                    ++n2;
                }
            }
            if (bl2) return;
            this.collapseItemActionView(this.mMenu, this.mCurrentExpandedItem);
        }
    }

    public static class HomeView
    extends FrameLayout {
        private ImageView mIconView;
        private View mUpView;
        private int mUpWidth;

        public HomeView(Context context) {
            this(context, null);
        }

        public HomeView(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public boolean dispatchHoverEvent(MotionEvent motionEvent) {
            return this.onHoverEvent(motionEvent);
        }

        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            this.onPopulateAccessibilityEvent(accessibilityEvent);
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getLeftOffset() {
            if (this.mUpView.getVisibility() != 8) return 0;
            return this.mUpWidth;
        }

        protected void onFinishInflate() {
            this.mUpView = this.findViewById(R.id.abs__up);
            this.mIconView = (ImageView)this.findViewById(R.id.abs__home);
        }

        protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
            int n5 = (n4 - n2) / 2;
            int n6 = 0;
            if (this.mUpView.getVisibility() != 8) {
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mUpView.getLayoutParams();
                int n7 = this.mUpView.getMeasuredHeight();
                int n8 = this.mUpView.getMeasuredWidth();
                int n9 = n5 - n7 / 2;
                this.mUpView.layout(0, n9, n8, n9 + n7);
                n6 = n8 + layoutParams.leftMargin + layoutParams.rightMargin;
                n += n6;
            }
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mIconView.getLayoutParams();
            int n10 = this.mIconView.getMeasuredHeight();
            int n11 = this.mIconView.getMeasuredWidth();
            int n12 = (n3 - n) / 2;
            int n13 = n6 + Math.max(layoutParams.leftMargin, n12 - n11 / 2);
            int n14 = Math.max(layoutParams.topMargin, n5 - n10 / 2);
            this.mIconView.layout(n13, n14, n13 + n11, n14 + n10);
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void onMeasure(int n, int n2) {
            this.measureChildWithMargins(this.mUpView, n, 0, n2, 0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mUpView.getLayoutParams();
            this.mUpWidth = layoutParams.leftMargin + this.mUpView.getMeasuredWidth() + layoutParams.rightMargin;
            int n3 = this.mUpView.getVisibility() == 8 ? 0 : this.mUpWidth;
            int n4 = layoutParams.topMargin + this.mUpView.getMeasuredHeight() + layoutParams.bottomMargin;
            this.measureChildWithMargins((View)this.mIconView, n, n3, n2, 0);
            FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)this.mIconView.getLayoutParams();
            int n5 = n3 + (layoutParams2.leftMargin + this.mIconView.getMeasuredWidth() + layoutParams2.rightMargin);
            int n6 = Math.max(n4, layoutParams2.topMargin + this.mIconView.getMeasuredHeight() + layoutParams2.bottomMargin);
            int n7 = View.MeasureSpec.getMode((int)n);
            int n8 = View.MeasureSpec.getMode((int)n2);
            int n9 = View.MeasureSpec.getSize((int)n);
            int n10 = View.MeasureSpec.getSize((int)n2);
            switch (n7) {
                case -2147483648: {
                    n5 = Math.min(n5, n9);
                }
                default: {
                    break;
                }
                case 0x40000000: {
                    n5 = n9;
                }
            }
            switch (n8) {
                case -2147483648: {
                    n6 = Math.min(n6, n10);
                }
                default: {
                    break;
                }
                case 0x40000000: {
                    n6 = n10;
                }
            }
            this.setMeasuredDimension(n5, n6);
        }

        public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            CharSequence charSequence;
            if (Build.VERSION.SDK_INT >= 14) {
                super.onPopulateAccessibilityEvent(accessibilityEvent);
            }
            if (!TextUtils.isEmpty((CharSequence)(charSequence = this.getContentDescription()))) {
                accessibilityEvent.getText().add(charSequence);
            }
        }

        public void setIcon(Drawable drawable2) {
            this.mIconView.setImageDrawable(drawable2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setUp(boolean bl) {
            View view = this.mUpView;
            int n = bl ? 0 : 8;
            view.setVisibility(n);
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        int expandedMenuItemId;
        boolean isOverflowOpen;

        /*
         * Enabled aggressive block sorting
         */
        private SavedState(Parcel parcel) {
            super(parcel);
            this.expandedMenuItemId = parcel.readInt();
            boolean bl = parcel.readInt() != 0;
            this.isOverflowOpen = bl;
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeInt(this.expandedMenuItemId);
            int n2 = this.isOverflowOpen ? 1 : 0;
            parcel.writeInt(n2);
        }
    }
}

