/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.actionbarsherlock.R;
import com.actionbarsherlock.internal.nineoldandroids.widget.NineFrameLayout;
import com.actionbarsherlock.internal.widget.ActionBarView;
import com.actionbarsherlock.internal.widget.ScrollingTabContainerView;

public class ActionBarContainer
extends NineFrameLayout {
    private ActionBarView mActionBarView;
    private Drawable mBackground;
    private boolean mIsSplit;
    private boolean mIsStacked;
    private boolean mIsTransitioning;
    private Drawable mSplitBackground;
    private Drawable mStackedBackground;
    private View mTabContainer;

    public ActionBarContainer(Context context) {
        this(context, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ActionBarContainer(Context context, AttributeSet attributeSet) {
        boolean bl = true;
        super(context, attributeSet);
        this.setBackgroundDrawable(null);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SherlockActionBar);
        this.mBackground = typedArray.getDrawable(2);
        this.mStackedBackground = typedArray.getDrawable(12);
        if (this.getId() == R.id.abs__split_action_bar) {
            this.mIsSplit = bl;
            this.mSplitBackground = typedArray.getDrawable(3);
        }
        typedArray.recycle();
        if (this.mIsSplit) {
            if (this.mSplitBackground != null) {
                bl = false;
            }
        } else if (this.mBackground != null || this.mStackedBackground != null) {
            bl = false;
        }
        this.setWillNotDraw(bl);
    }

    public View getTabContainer() {
        return this.mTabContainer;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onDraw(Canvas canvas) {
        if (this.getWidth() == 0) return;
        if (this.getHeight() == 0) {
            return;
        }
        if (this.mIsSplit) {
            if (this.mSplitBackground == null) return;
            this.mSplitBackground.draw(canvas);
            return;
        }
        if (this.mBackground != null) {
            this.mBackground.draw(canvas);
        }
        if (this.mStackedBackground == null) return;
        if (!this.mIsStacked) return;
        this.mStackedBackground.draw(canvas);
    }

    public void onFinishInflate() {
        super.onFinishInflate();
        this.mActionBarView = (ActionBarView)this.findViewById(R.id.abs__action_bar);
    }

    public boolean onHoverEvent(MotionEvent motionEvent) {
        super.onHoverEvent(motionEvent);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (this.mIsTransitioning) return true;
        if (super.onInterceptTouchEvent(motionEvent)) return true;
        return false;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        boolean bl2;
        block7: {
            super.onLayout(bl, n, n2, n3, n4);
            boolean bl3 = this.mTabContainer != null && this.mTabContainer.getVisibility() != 8;
            boolean bl4 = true;
            while (true) {
                int n5;
                int n6;
                block11: {
                    block9: {
                        int n7;
                        block8: {
                            block10: {
                                if (!bl4 || (bl4 = false)) break block8;
                                if (this.mTabContainer == null || this.mTabContainer.getVisibility() == 8) break block9;
                                int n8 = this.getMeasuredHeight();
                                n6 = this.mTabContainer.getMeasuredHeight();
                                if ((2 & this.mActionBarView.getDisplayOptions()) == 0) break block10;
                                this.mTabContainer.layout(n, n8 - n6, n3, n8);
                                break block9;
                            }
                            n7 = this.getChildCount();
                            n5 = 0;
                        }
                        if (n5 < n7) break block11;
                        this.mTabContainer.layout(n, 0, n3, n6);
                    }
                    bl2 = false;
                    if (!this.mIsSplit) break;
                    if (this.mSplitBackground != null) {
                        this.mSplitBackground.setBounds(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
                        bl2 = true;
                    }
                    break block7;
                }
                View view = this.getChildAt(n5);
                if (view != this.mTabContainer && !this.mActionBarView.isCollapsed()) {
                    view.offsetTopAndBottom(n6);
                }
                ++n5;
            }
            if (this.mBackground != null) {
                this.mBackground.setBounds(this.mActionBarView.getLeft(), this.mActionBarView.getTop(), this.mActionBarView.getRight(), this.mActionBarView.getBottom());
                bl2 = true;
            }
            boolean bl5 = bl3 && this.mStackedBackground != null;
            this.mIsStacked = bl5;
            if (bl5) {
                this.mStackedBackground.setBounds(this.mTabContainer.getLeft(), this.mTabContainer.getTop(), this.mTabContainer.getRight(), this.mTabContainer.getBottom());
                bl2 = true;
            }
        }
        if (bl2) {
            this.invalidate();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        if (this.mActionBarView == null) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mActionBarView.getLayoutParams();
        int n3 = this.mActionBarView.isCollapsed() ? 0 : this.mActionBarView.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
        if (this.mTabContainer == null) return;
        if (this.mTabContainer.getVisibility() == 8) return;
        if (View.MeasureSpec.getMode((int)n2) != Integer.MIN_VALUE) return;
        int n4 = View.MeasureSpec.getSize((int)n2);
        this.setMeasuredDimension(this.getMeasuredWidth(), Math.min(n3 + this.mTabContainer.getMeasuredHeight(), n4));
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        super.onTouchEvent(motionEvent);
        return true;
    }

    public void setPrimaryBackground(Drawable drawable2) {
        this.mBackground = drawable2;
        this.invalidate();
    }

    public void setSplitBackground(Drawable drawable2) {
        this.mSplitBackground = drawable2;
        this.invalidate();
    }

    public void setStackedBackground(Drawable drawable2) {
        this.mStackedBackground = drawable2;
        this.invalidate();
    }

    public void setTabContainer(ScrollingTabContainerView scrollingTabContainerView) {
        if (this.mTabContainer != null) {
            this.removeView(this.mTabContainer);
        }
        this.mTabContainer = scrollingTabContainerView;
        if (scrollingTabContainerView != null) {
            this.addView((View)scrollingTabContainerView);
            ViewGroup.LayoutParams layoutParams = scrollingTabContainerView.getLayoutParams();
            layoutParams.width = -1;
            layoutParams.height = -2;
            scrollingTabContainerView.setAllowCollapse(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setTransitioning(boolean bl) {
        this.mIsTransitioning = bl;
        int n = bl ? 393216 : 262144;
        this.setDescendantFocusability(n);
    }
}

