/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.nineoldandroids.animation;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AndroidRuntimeException;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.actionbarsherlock.internal.nineoldandroids.animation.Animator;
import com.actionbarsherlock.internal.nineoldandroids.animation.PropertyValuesHolder;
import com.actionbarsherlock.internal.nineoldandroids.animation.TypeEvaluator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ValueAnimator
extends Animator {
    static final int ANIMATION_FRAME = 1;
    static final int ANIMATION_START = 0;
    private static final long DEFAULT_FRAME_DELAY = 10L;
    public static final int INFINITE = -1;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    static final int RUNNING = 1;
    static final int SEEKED = 2;
    static final int STOPPED;
    private static ThreadLocal<AnimationHandler> sAnimationHandler;
    private static final ThreadLocal<ArrayList<ValueAnimator>> sAnimations;
    private static final Interpolator sDefaultInterpolator;
    private static final ThreadLocal<ArrayList<ValueAnimator>> sDelayedAnims;
    private static final ThreadLocal<ArrayList<ValueAnimator>> sEndingAnims;
    private static long sFrameDelay;
    private static final ThreadLocal<ArrayList<ValueAnimator>> sPendingAnimations;
    private static final ThreadLocal<ArrayList<ValueAnimator>> sReadyAnims;
    private float mCurrentFraction = 0.0f;
    private int mCurrentIteration = 0;
    private long mDelayStartTime;
    private long mDuration = 300L;
    boolean mInitialized = false;
    private Interpolator mInterpolator = sDefaultInterpolator;
    private boolean mPlayingBackwards = false;
    int mPlayingState = 0;
    private int mRepeatCount = 0;
    private int mRepeatMode = 1;
    private boolean mRunning = false;
    long mSeekTime = -1L;
    private long mStartDelay = 0L;
    long mStartTime;
    private boolean mStarted = false;
    private boolean mStartedDelay = false;
    private ArrayList<AnimatorUpdateListener> mUpdateListeners = null;
    PropertyValuesHolder[] mValues;
    HashMap<String, PropertyValuesHolder> mValuesMap;

    static {
        sAnimationHandler = new ThreadLocal();
        sAnimations = new ThreadLocal<ArrayList<ValueAnimator>>(){

            @Override
            protected ArrayList<ValueAnimator> initialValue() {
                return new ArrayList<ValueAnimator>();
            }
        };
        sPendingAnimations = new ThreadLocal<ArrayList<ValueAnimator>>(){

            @Override
            protected ArrayList<ValueAnimator> initialValue() {
                return new ArrayList<ValueAnimator>();
            }
        };
        sDelayedAnims = new ThreadLocal<ArrayList<ValueAnimator>>(){

            @Override
            protected ArrayList<ValueAnimator> initialValue() {
                return new ArrayList<ValueAnimator>();
            }
        };
        sEndingAnims = new ThreadLocal<ArrayList<ValueAnimator>>(){

            @Override
            protected ArrayList<ValueAnimator> initialValue() {
                return new ArrayList<ValueAnimator>();
            }
        };
        sReadyAnims = new ThreadLocal<ArrayList<ValueAnimator>>(){

            @Override
            protected ArrayList<ValueAnimator> initialValue() {
                return new ArrayList<ValueAnimator>();
            }
        };
        sDefaultInterpolator = new AccelerateDecelerateInterpolator();
        sFrameDelay = 10L;
    }

    static /* synthetic */ void access$10(ValueAnimator valueAnimator, boolean bl) {
        valueAnimator.mRunning = bl;
    }

    static /* synthetic */ void access$11(ValueAnimator valueAnimator) {
        valueAnimator.endAnimation();
    }

    static /* synthetic */ long access$12() {
        return sFrameDelay;
    }

    static /* synthetic */ ThreadLocal access$2() {
        return sAnimations;
    }

    static /* synthetic */ ThreadLocal access$3() {
        return sDelayedAnims;
    }

    static /* synthetic */ ThreadLocal access$4() {
        return sPendingAnimations;
    }

    static /* synthetic */ long access$5(ValueAnimator valueAnimator) {
        return valueAnimator.mStartDelay;
    }

    static /* synthetic */ void access$6(ValueAnimator valueAnimator) {
        valueAnimator.startAnimation();
    }

    static /* synthetic */ ThreadLocal access$7() {
        return sReadyAnims;
    }

    static /* synthetic */ ThreadLocal access$8() {
        return sEndingAnims;
    }

    static /* synthetic */ boolean access$9(ValueAnimator valueAnimator, long l) {
        return valueAnimator.delayedAnimationFrame(l);
    }

    public static void clearAllAnimations() {
        sAnimations.get().clear();
        sPendingAnimations.get().clear();
        sDelayedAnims.get().clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean delayedAnimationFrame(long l) {
        boolean bl = true;
        if (!this.mStartedDelay) {
            this.mStartedDelay = bl;
            this.mDelayStartTime = l;
            return false;
        }
        long l2 = l - this.mDelayStartTime;
        if (l2 <= this.mStartDelay) return false;
        this.mStartTime = l - (l2 - this.mStartDelay);
        this.mPlayingState = bl ? 1 : 0;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void endAnimation() {
        sAnimations.get().remove(this);
        sPendingAnimations.get().remove(this);
        sDelayedAnims.get().remove(this);
        this.mPlayingState = 0;
        if (this.mRunning && this.mListeners != null) {
            ArrayList arrayList = (ArrayList)this.mListeners.clone();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ((Animator.AnimatorListener)arrayList.get(i)).onAnimationEnd(this);
            }
        }
        this.mRunning = false;
        this.mStarted = false;
    }

    public static int getCurrentAnimationsCount() {
        return sAnimations.get().size();
    }

    public static long getFrameDelay() {
        return sFrameDelay;
    }

    public static ValueAnimator ofFloat(float ... fArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setFloatValues(fArray);
        return valueAnimator;
    }

    public static ValueAnimator ofInt(int ... nArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setIntValues(nArray);
        return valueAnimator;
    }

    public static ValueAnimator ofObject(TypeEvaluator typeEvaluator, Object ... objectArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setObjectValues(objectArray);
        valueAnimator.setEvaluator(typeEvaluator);
        return valueAnimator;
    }

    public static ValueAnimator ofPropertyValuesHolder(PropertyValuesHolder ... propertyValuesHolderArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setValues(propertyValuesHolderArray);
        return valueAnimator;
    }

    public static void setFrameDelay(long l) {
        sFrameDelay = l;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void start(boolean bl) {
        AnimationHandler animationHandler;
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        this.mPlayingBackwards = bl;
        this.mCurrentIteration = 0;
        this.mPlayingState = 0;
        this.mStarted = true;
        this.mStartedDelay = false;
        sPendingAnimations.get().add(this);
        if (this.mStartDelay == 0L) {
            this.setCurrentPlayTime(this.getCurrentPlayTime());
            this.mPlayingState = 0;
            this.mRunning = true;
            if (this.mListeners != null) {
                ArrayList arrayList = (ArrayList)this.mListeners.clone();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    ((Animator.AnimatorListener)arrayList.get(i)).onAnimationStart(this);
                }
            }
        }
        if ((animationHandler = sAnimationHandler.get()) == null) {
            animationHandler = new AnimationHandler();
            sAnimationHandler.set(animationHandler);
        }
        animationHandler.sendEmptyMessage(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startAnimation() {
        this.initAnimation();
        sAnimations.get().add(this);
        if (this.mStartDelay <= 0L || this.mListeners == null) return;
        ArrayList arrayList = (ArrayList)this.mListeners.clone();
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            ((Animator.AnimatorListener)arrayList.get(n2)).onAnimationStart(this);
            ++n2;
        }
        return;
    }

    public void addUpdateListener(AnimatorUpdateListener animatorUpdateListener) {
        if (this.mUpdateListeners == null) {
            this.mUpdateListeners = new ArrayList();
        }
        this.mUpdateListeners.add(animatorUpdateListener);
    }

    /*
     * Enabled aggressive block sorting
     */
    void animateValue(float f) {
        float f2;
        this.mCurrentFraction = f2 = this.mInterpolator.getInterpolation(f);
        int n = this.mValues.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                if (this.mUpdateListeners == null) return;
                break;
            }
            this.mValues[n2].calculateValue(f2);
            ++n2;
        }
        int n3 = this.mUpdateListeners.size();
        int n4 = 0;
        while (n4 < n3) {
            this.mUpdateListeners.get(n4).onAnimationUpdate(this);
            ++n4;
        }
        return;
    }

    /*
     * Unable to fully structure code
     */
    boolean animationFrame(long var1_1) {
        block13: {
            block15: {
                block14: {
                    block12: {
                        block17: {
                            block16: {
                                var3_2 = false;
                                if (this.mPlayingState != 0) break block16;
                                this.mPlayingState = 1;
                                if (this.mSeekTime >= 0L) break block17;
                                this.mStartTime = var1_1;
                            }
lbl7:
                            // 2 sources

                            while (true) {
                                switch (this.mPlayingState) {
                                    default: lbl-1000:
                                    // 2 sources

                                    {
                                        return var3_2;
                                    }
                                    case 1: 
                                    case 2: {
                                        if (this.mDuration <= 0L) break block12;
                                    }
                                }
                                break;
                            }
                        }
                        this.mStartTime = var1_1 - this.mSeekTime;
                        this.mSeekTime = -1L;
                        ** while (true)
                        var4_3 = (float)(var1_1 - this.mStartTime) / (float)this.mDuration;
lbl19:
                        // 2 sources

                        while (true) {
                            if (!(var4_3 >= 1.0f)) ** GOTO lbl35
                            if (this.mCurrentIteration >= this.mRepeatCount && this.mRepeatCount != -1) break block13;
                            if (this.mListeners == null) ** GOTO lbl27
                            var6_4 = this.mListeners.size();
                            var7_5 = 0;
lbl25:
                            // 2 sources

                            while (true) {
                                if (var7_5 < var6_4) break block14;
lbl27:
                                // 2 sources

                                if (this.mRepeatMode != 2) ** GOTO lbl32
                                if (!this.mPlayingBackwards) break block15;
                                var5_6 = false;
lbl30:
                                // 2 sources

                                while (true) {
                                    this.mPlayingBackwards = var5_6;
lbl32:
                                    // 2 sources

                                    this.mCurrentIteration += (int)var4_3;
                                    var4_3 %= 1.0f;
                                    this.mStartTime += this.mDuration;
lbl35:
                                    // 3 sources

                                    while (true) {
                                        if (this.mPlayingBackwards) {
                                            var4_3 = 1.0f - var4_3;
                                        }
                                        this.animateValue(var4_3);
                                        ** continue;
                                        break;
                                    }
                                    break;
                                }
                                break;
                            }
                            break;
                        }
                    }
                    var4_3 = 1.0f;
                    ** while (true)
                }
                ((Animator.AnimatorListener)this.mListeners.get(var7_5)).onAnimationRepeat(this);
                ++var7_5;
                ** while (true)
            }
            var5_6 = true;
            ** while (true)
        }
        var3_2 = true;
        var4_3 = Math.min(var4_3, 1.0f);
        ** while (true)
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    @Override
    public void cancel() {
        if (this.mPlayingState == 0 && !sPendingAnimations.get().contains(this) && !sDelayedAnims.get().contains(this)) return;
        boolean bl = true;
        while (true) {
            Iterator iterator;
            block5: {
                block4: {
                    block3: {
                        if (!bl || (bl = false)) break block3;
                        if (!this.mRunning || this.mListeners == null) break block4;
                        iterator = ((ArrayList)this.mListeners.clone()).iterator();
                    }
                    if (iterator.hasNext()) break block5;
                }
                this.endAnimation();
                return;
            }
            ((Animator.AnimatorListener)iterator.next()).onAnimationCancel(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @Override
    public ValueAnimator clone() {
        ValueAnimator valueAnimator = (ValueAnimator)super.clone();
        if (this.mUpdateListeners != null) {
            ArrayList<AnimatorUpdateListener> arrayList = this.mUpdateListeners;
            valueAnimator.mUpdateListeners = new ArrayList();
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                valueAnimator.mUpdateListeners.add(arrayList.get(n2));
                ++n2;
            }
        }
        valueAnimator.mSeekTime = -1L;
        valueAnimator.mPlayingBackwards = false;
        valueAnimator.mCurrentIteration = 0;
        valueAnimator.mInitialized = false;
        valueAnimator.mPlayingState = 0;
        valueAnimator.mStartedDelay = false;
        PropertyValuesHolder[] propertyValuesHolderArray = this.mValues;
        if (propertyValuesHolderArray == null) return valueAnimator;
        int n = propertyValuesHolderArray.length;
        valueAnimator.mValues = new PropertyValuesHolder[n];
        valueAnimator.mValuesMap = new HashMap(n);
        int n3 = 0;
        while (n3 < n) {
            PropertyValuesHolder propertyValuesHolder;
            valueAnimator.mValues[n3] = propertyValuesHolder = propertyValuesHolderArray[n3].clone();
            valueAnimator.mValuesMap.put(propertyValuesHolder.getPropertyName(), propertyValuesHolder);
            ++n3;
        }
        return valueAnimator;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void end() {
        if (!sAnimations.get().contains(this) && !sPendingAnimations.get().contains(this)) {
            this.mStartedDelay = false;
            this.startAnimation();
        } else if (!this.mInitialized) {
            this.initAnimation();
        }
        if (this.mRepeatCount > 0 && (1 & this.mRepeatCount) == 1) {
            this.animateValue(0.0f);
        } else {
            this.animateValue(1.0f);
        }
        this.endAnimation();
    }

    public float getAnimatedFraction() {
        return this.mCurrentFraction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getAnimatedValue() {
        if (this.mValues == null) return null;
        if (this.mValues.length <= 0) return null;
        return this.mValues[0].getAnimatedValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getAnimatedValue(String string2) {
        PropertyValuesHolder propertyValuesHolder = this.mValuesMap.get(string2);
        if (propertyValuesHolder == null) return null;
        return propertyValuesHolder.getAnimatedValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getCurrentPlayTime() {
        if (!this.mInitialized) return 0L;
        if (this.mPlayingState != 0) return AnimationUtils.currentAnimationTimeMillis() - this.mStartTime;
        return 0L;
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public int getRepeatMode() {
        return this.mRepeatMode;
    }

    @Override
    public long getStartDelay() {
        return this.mStartDelay;
    }

    public PropertyValuesHolder[] getValues() {
        return this.mValues;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void initAnimation() {
        if (this.mInitialized) return;
        int n = this.mValues.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                this.mInitialized = true;
                return;
            }
            this.mValues[n2].init();
            ++n2;
        }
    }

    @Override
    public boolean isRunning() {
        int n = 1;
        if (this.mPlayingState != n && !this.mRunning) {
            n = 0;
        }
        return n;
    }

    @Override
    public boolean isStarted() {
        return this.mStarted;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeAllUpdateListeners() {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.clear();
        this.mUpdateListeners = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeUpdateListener(AnimatorUpdateListener animatorUpdateListener) {
        if (this.mUpdateListeners == null) {
            return;
        }
        this.mUpdateListeners.remove(animatorUpdateListener);
        if (this.mUpdateListeners.size() != 0) return;
        this.mUpdateListeners = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void reverse() {
        boolean bl = !this.mPlayingBackwards;
        this.mPlayingBackwards = bl;
        if (this.mPlayingState == 1) {
            long l = AnimationUtils.currentAnimationTimeMillis();
            long l2 = l - this.mStartTime;
            this.mStartTime = l - (this.mDuration - l2);
            return;
        }
        this.start(true);
    }

    public void setCurrentPlayTime(long l) {
        this.initAnimation();
        long l2 = AnimationUtils.currentAnimationTimeMillis();
        if (this.mPlayingState != 1) {
            this.mSeekTime = l;
            this.mPlayingState = 2;
        }
        this.mStartTime = l2 - l;
        this.animationFrame(l2);
    }

    @Override
    public ValueAnimator setDuration(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + l);
        }
        this.mDuration = l;
        return this;
    }

    public void setEvaluator(TypeEvaluator typeEvaluator) {
        if (typeEvaluator != null && this.mValues != null && this.mValues.length > 0) {
            this.mValues[0].setEvaluator(typeEvaluator);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setFloatValues(float ... fArray) {
        if (fArray == null) return;
        if (fArray.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            PropertyValuesHolder[] propertyValuesHolderArray = new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat("", fArray)};
            this.setValues(propertyValuesHolderArray);
        } else {
            this.mValues[0].setFloatValues(fArray);
        }
        this.mInitialized = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setIntValues(int ... nArray) {
        if (nArray == null) return;
        if (nArray.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            PropertyValuesHolder[] propertyValuesHolderArray = new PropertyValuesHolder[]{PropertyValuesHolder.ofInt("", nArray)};
            this.setValues(propertyValuesHolderArray);
        } else {
            this.mValues[0].setIntValues(nArray);
        }
        this.mInitialized = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setInterpolator(Interpolator interpolator) {
        if (interpolator != null) {
            this.mInterpolator = interpolator;
            return;
        }
        this.mInterpolator = new LinearInterpolator();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setObjectValues(Object ... objectArray) {
        if (objectArray == null) return;
        if (objectArray.length == 0) {
            return;
        }
        if (this.mValues == null || this.mValues.length == 0) {
            PropertyValuesHolder[] propertyValuesHolderArray = new PropertyValuesHolder[]{PropertyValuesHolder.ofObject("", null, objectArray)};
            this.setValues(propertyValuesHolderArray);
        } else {
            this.mValues[0].setObjectValues(objectArray);
        }
        this.mInitialized = false;
    }

    public void setRepeatCount(int n) {
        this.mRepeatCount = n;
    }

    public void setRepeatMode(int n) {
        this.mRepeatMode = n;
    }

    @Override
    public void setStartDelay(long l) {
        this.mStartDelay = l;
    }

    public void setValues(PropertyValuesHolder ... propertyValuesHolderArray) {
        int n = propertyValuesHolderArray.length;
        this.mValues = propertyValuesHolderArray;
        this.mValuesMap = new HashMap(n);
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                this.mInitialized = false;
                return;
            }
            PropertyValuesHolder propertyValuesHolder = propertyValuesHolderArray[n2];
            this.mValuesMap.put(propertyValuesHolder.getPropertyName(), propertyValuesHolder);
            ++n2;
        }
    }

    @Override
    public void start() {
        this.start(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        String string2 = "ValueAnimator@" + Integer.toHexString(this.hashCode());
        if (this.mValues == null) return string2;
        int n = 0;
        while (n < this.mValues.length) {
            string2 = String.valueOf(string2) + "\n    " + this.mValues[n].toString();
            ++n;
        }
        return string2;
    }

    private static class AnimationHandler
    extends Handler {
        private AnimationHandler() {
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         */
        public void handleMessage(Message var1_1) {
            block24: {
                block22: {
                    block23: {
                        var2_2 = true;
                        var3_3 = (ArrayList)ValueAnimator.access$2().get();
                        var4_4 = (ArrayList)ValueAnimator.access$3().get();
                        switch (var1_1.what) {
                            case 0: {
                                var24_5 = (ArrayList)ValueAnimator.access$4().get();
                                if (var3_3.size() > 0 || var4_4.size() > 0) {
                                    var2_2 = false;
                                    ** break;
                                }
                                ** GOTO lbl13
                            }
lbl11:
                            // 2 sources

                            default: {
                                return;
                            }
lbl13:
                            // 3 sources

                            while (true) {
                                if (var24_5.size() > 0) ** break;
                                break;
                            }
                            case 1: 
                        }
                        break block23;
                        break block24;
                    }
                    var5_10 = AnimationUtils.currentAnimationTimeMillis();
                    var7_11 = (ArrayList)ValueAnimator.access$7().get();
                    var8_12 = (ArrayList)ValueAnimator.access$8().get();
                    var9_13 = var4_4.size();
                    var10_14 = 0;
                    while (true) {
                        if (var10_14 >= var9_13) {
                            var13_16 = var7_11.size();
                            if (var13_16 > 0) {
                                break;
                            }
                            break block22;
                        }
                        var11_15 = (ValueAnimator)var4_4.get(var10_14);
                        if (ValueAnimator.access$9(var11_15, var5_10)) {
                            var7_11.add(var11_15);
                        }
                        ++var10_14;
                    }
                    var21_17 = 0;
                    while (true) {
                        if (var21_17 >= var13_16) {
                            var7_11.clear();
                            break;
                        }
                        var22_18 = (ValueAnimator)var7_11.get(var21_17);
                        ValueAnimator.access$6(var22_18);
                        ValueAnimator.access$10(var22_18, true);
                        var4_4.remove(var22_18);
                        ++var21_17;
                    }
                }
                var14_19 = var3_3.size();
                var15_20 = 0;
                while (true) {
                    block25: {
                        if (var15_20 < var14_19) break block25;
                        if (var8_12.size() > 0) {
                            break;
                        }
                        ** GOTO lbl72
                    }
                    var16_21 = (ValueAnimator)var3_3.get(var15_20);
                    if (var16_21.animationFrame(var5_10)) {
                        var8_12.add(var16_21);
                    }
                    if (var3_3.size() == var14_19) {
                        ++var15_20;
                        continue;
                    }
                    --var14_19;
                    var8_12.remove(var16_21);
                }
                var20_22 = 0;
                while (true) {
                    block26: {
                        if (var20_22 < var8_12.size()) break block26;
                        var8_12.clear();
lbl72:
                        // 2 sources

                        if (!(!var2_2 || var3_3.isEmpty() && var4_4.isEmpty())) {
                            this.sendEmptyMessageDelayed(1, Math.max(0L, ValueAnimator.access$12() - (AnimationUtils.currentAnimationTimeMillis() - var5_10)));
                        }
                        ** GOTO lbl11
                    }
                    ValueAnimator.access$11((ValueAnimator)var8_12.get(var20_22));
                    ++var20_22;
                }
            }
            var25_6 = (ArrayList)var24_5.clone();
            var24_5.clear();
            var26_7 = var25_6.size();
            var27_8 = 0;
            while (true) {
                if (var27_8 >= var26_7) ** continue;
                var28_9 = (ValueAnimator)var25_6.get(var27_8);
                if (ValueAnimator.access$5(var28_9) == 0L) {
                    ValueAnimator.access$6(var28_9);
                } else {
                    var4_4.add(var28_9);
                }
                ++var27_8;
            }
        }
    }

    public static interface AnimatorUpdateListener {
        public void onAnimationUpdate(ValueAnimator var1);
    }
}

