/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.nineoldandroids.animation;

import android.util.Log;
import com.actionbarsherlock.internal.nineoldandroids.animation.FloatEvaluator;
import com.actionbarsherlock.internal.nineoldandroids.animation.FloatKeyframeSet;
import com.actionbarsherlock.internal.nineoldandroids.animation.IntEvaluator;
import com.actionbarsherlock.internal.nineoldandroids.animation.IntKeyframeSet;
import com.actionbarsherlock.internal.nineoldandroids.animation.Keyframe;
import com.actionbarsherlock.internal.nineoldandroids.animation.KeyframeSet;
import com.actionbarsherlock.internal.nineoldandroids.animation.TypeEvaluator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PropertyValuesHolder
implements Cloneable {
    private static Class[] DOUBLE_VARIANTS;
    private static Class[] FLOAT_VARIANTS;
    private static Class[] INTEGER_VARIANTS;
    private static final TypeEvaluator sFloatEvaluator;
    private static final HashMap<Class, HashMap<String, Method>> sGetterPropertyMap;
    private static final TypeEvaluator sIntEvaluator;
    private static final HashMap<Class, HashMap<String, Method>> sSetterPropertyMap;
    private Object mAnimatedValue;
    private TypeEvaluator mEvaluator;
    private Method mGetter = null;
    KeyframeSet mKeyframeSet = null;
    final ReentrantReadWriteLock mPropertyMapLock = new ReentrantReadWriteLock();
    String mPropertyName;
    Method mSetter = null;
    final Object[] mTmpValueArray = new Object[1];
    Class mValueType;

    static {
        sIntEvaluator = new IntEvaluator();
        sFloatEvaluator = new FloatEvaluator();
        Class[] classArray = new Class[]{Float.TYPE, Float.class, Double.TYPE, Integer.TYPE, Double.class, Integer.class};
        FLOAT_VARIANTS = classArray;
        Class[] classArray2 = new Class[]{Integer.TYPE, Integer.class, Float.TYPE, Double.TYPE, Float.class, Double.class};
        INTEGER_VARIANTS = classArray2;
        Class[] classArray3 = new Class[]{Double.TYPE, Double.class, Float.TYPE, Integer.TYPE, Float.class, Integer.class};
        DOUBLE_VARIANTS = classArray3;
        sSetterPropertyMap = new HashMap();
        sGetterPropertyMap = new HashMap();
    }

    private PropertyValuesHolder(String string2) {
        this.mPropertyName = string2;
    }

    /* synthetic */ PropertyValuesHolder(String string2, PropertyValuesHolder propertyValuesHolder) {
        this(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getMethodName(String string2, String string3) {
        if (string3 == null) return string2;
        if (string3.length() == 0) {
            return string2;
        }
        char c = Character.toUpperCase(string3.charAt(0));
        String string4 = string3.substring(1);
        return String.valueOf(string2) + c + string4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Method getPropertyFunction(Class clazz, String string2, Class clazz2) {
        Method method = null;
        String string3 = PropertyValuesHolder.getMethodName(string2, this.mPropertyName);
        Class[] classArray = null;
        if (clazz2 == null) {
            try {
                Method method2;
                method = method2 = clazz.getMethod(string3, classArray);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.e((String)"PropertyValuesHolder", (String)(String.valueOf(clazz.getSimpleName()) + " - " + "Couldn't find no-arg method for property " + this.mPropertyName + ": " + noSuchMethodException));
            }
            return method;
        }
        Class[] classArray2 = new Class[1];
        Class[] classArray3 = this.mValueType.equals(Float.class) ? FLOAT_VARIANTS : (this.mValueType.equals(Integer.class) ? INTEGER_VARIANTS : (this.mValueType.equals(Double.class) ? DOUBLE_VARIANTS : new Class[]{this.mValueType}));
        int n = classArray3.length;
        int n2 = 0;
        while (true) {
            Class clazz3;
            if (n2 >= n) {
                Log.e((String)"PropertyValuesHolder", (String)("Couldn't find " + string2 + "ter property " + this.mPropertyName + " for " + clazz.getSimpleName() + " with value type " + this.mValueType));
                return method;
            }
            classArray2[0] = clazz3 = classArray3[n2];
            try {
                method = clazz.getMethod(string3, classArray2);
                this.mValueType = clazz3;
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ++n2;
                continue;
            }
            break;
        }
    }

    public static PropertyValuesHolder ofFloat(String string2, float ... fArray) {
        return new FloatPropertyValuesHolder(string2, fArray);
    }

    public static PropertyValuesHolder ofInt(String string2, int ... nArray) {
        return new IntPropertyValuesHolder(string2, nArray);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PropertyValuesHolder ofKeyframe(String string2, Keyframe ... keyframeArray) {
        void var3_4;
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(keyframeArray);
        if (keyframeSet instanceof IntKeyframeSet) {
            IntPropertyValuesHolder intPropertyValuesHolder = new IntPropertyValuesHolder(string2, (IntKeyframeSet)keyframeSet);
            return var3_4;
        }
        if (keyframeSet instanceof FloatKeyframeSet) {
            FloatPropertyValuesHolder floatPropertyValuesHolder = new FloatPropertyValuesHolder(string2, (FloatKeyframeSet)keyframeSet);
            return var3_4;
        }
        PropertyValuesHolder propertyValuesHolder = new PropertyValuesHolder(string2);
        propertyValuesHolder.mKeyframeSet = keyframeSet;
        propertyValuesHolder.mValueType = keyframeArray[0].getType();
        return var3_4;
    }

    public static PropertyValuesHolder ofObject(String string2, TypeEvaluator typeEvaluator, Object ... objectArray) {
        PropertyValuesHolder propertyValuesHolder = new PropertyValuesHolder(string2);
        propertyValuesHolder.setObjectValues(objectArray);
        propertyValuesHolder.setEvaluator(typeEvaluator);
        return propertyValuesHolder;
    }

    private void setupGetter(Class clazz) {
        this.mGetter = this.setupSetterOrGetter(clazz, sGetterPropertyMap, "get", null);
    }

    private Method setupSetterOrGetter(Class clazz, HashMap<Class, HashMap<String, Method>> hashMap, String string2, Class clazz2) {
        Method method = null;
        try {
            this.mPropertyMapLock.writeLock().lock();
            HashMap<String, Method> hashMap2 = hashMap.get(clazz);
            if (hashMap2 != null) {
                method = hashMap2.get(this.mPropertyName);
            }
            if (method == null) {
                method = this.getPropertyFunction(clazz, string2, clazz2);
                if (hashMap2 == null) {
                    hashMap2 = new HashMap();
                    hashMap.put(clazz, hashMap2);
                }
                hashMap2.put(this.mPropertyName, method);
            }
            return method;
        }
        finally {
            this.mPropertyMapLock.writeLock().unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupValue(Object object, Keyframe keyframe) {
        try {
            if (this.mGetter == null) {
                this.setupGetter(object.getClass());
            }
            keyframe.setValue(this.mGetter.invoke(object, new Object[0]));
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.e((String)"PropertyValuesHolder", (String)invocationTargetException.toString());
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.e((String)"PropertyValuesHolder", (String)illegalAccessException.toString());
            return;
        }
    }

    void calculateValue(float f) {
        this.mAnimatedValue = this.mKeyframeSet.getValue(f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PropertyValuesHolder clone() {
        try {
            PropertyValuesHolder propertyValuesHolder = (PropertyValuesHolder)super.clone();
            propertyValuesHolder.mPropertyName = this.mPropertyName;
            propertyValuesHolder.mKeyframeSet = this.mKeyframeSet.clone();
            propertyValuesHolder.mEvaluator = this.mEvaluator;
            return propertyValuesHolder;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    Object getAnimatedValue() {
        return this.mAnimatedValue;
    }

    public String getPropertyName() {
        return this.mPropertyName;
    }

    /*
     * Enabled aggressive block sorting
     */
    void init() {
        if (this.mEvaluator == null) {
            TypeEvaluator typeEvaluator = this.mValueType == Integer.class ? sIntEvaluator : (this.mValueType == Float.class ? sFloatEvaluator : null);
            this.mEvaluator = typeEvaluator;
        }
        if (this.mEvaluator != null) {
            this.mKeyframeSet.setEvaluator(this.mEvaluator);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setAnimatedValue(Object object) {
        if (this.mSetter == null) return;
        try {
            this.mTmpValueArray[0] = this.getAnimatedValue();
            this.mSetter.invoke(object, this.mTmpValueArray);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.e((String)"PropertyValuesHolder", (String)invocationTargetException.toString());
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.e((String)"PropertyValuesHolder", (String)illegalAccessException.toString());
            return;
        }
    }

    public void setEvaluator(TypeEvaluator typeEvaluator) {
        this.mEvaluator = typeEvaluator;
        this.mKeyframeSet.setEvaluator(typeEvaluator);
    }

    public void setFloatValues(float ... fArray) {
        this.mValueType = Float.TYPE;
        this.mKeyframeSet = KeyframeSet.ofFloat(fArray);
    }

    public void setIntValues(int ... nArray) {
        this.mValueType = Integer.TYPE;
        this.mKeyframeSet = KeyframeSet.ofInt(nArray);
    }

    public void setKeyframes(Keyframe ... keyframeArray) {
        int n = keyframeArray.length;
        Keyframe[] keyframeArray2 = new Keyframe[Math.max(n, 2)];
        this.mValueType = keyframeArray[0].getType();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                this.mKeyframeSet = new KeyframeSet(keyframeArray2);
                return;
            }
            keyframeArray2[n2] = keyframeArray[n2];
            ++n2;
        }
    }

    public void setObjectValues(Object ... objectArray) {
        this.mValueType = objectArray[0].getClass();
        this.mKeyframeSet = KeyframeSet.ofObject(objectArray);
    }

    public void setPropertyName(String string2) {
        this.mPropertyName = string2;
    }

    void setupEndValue(Object object) {
        this.setupValue(object, this.mKeyframeSet.mKeyframes.get(-1 + this.mKeyframeSet.mKeyframes.size()));
    }

    void setupSetter(Class clazz) {
        this.mSetter = this.setupSetterOrGetter(clazz, sSetterPropertyMap, "set", this.mValueType);
    }

    void setupSetterAndGetter(Object object) {
        Class<?> clazz = object.getClass();
        if (this.mSetter == null) {
            this.setupSetter(clazz);
        }
        Iterator<Keyframe> iterator = this.mKeyframeSet.mKeyframes.iterator();
        while (iterator.hasNext()) {
            Keyframe keyframe = iterator.next();
            if (keyframe.hasValue()) continue;
            if (this.mGetter == null) {
                this.setupGetter(clazz);
            }
            try {
                keyframe.setValue(this.mGetter.invoke(object, new Object[0]));
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.e((String)"PropertyValuesHolder", (String)invocationTargetException.toString());
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.e((String)"PropertyValuesHolder", (String)illegalAccessException.toString());
                continue;
            }
            break;
        }
        return;
    }

    void setupStartValue(Object object) {
        this.setupValue(object, this.mKeyframeSet.mKeyframes.get(0));
    }

    public String toString() {
        return String.valueOf(this.mPropertyName) + ": " + this.mKeyframeSet.toString();
    }

    static class FloatPropertyValuesHolder
    extends PropertyValuesHolder {
        float mFloatAnimatedValue;
        FloatKeyframeSet mFloatKeyframeSet;

        public FloatPropertyValuesHolder(String string2, FloatKeyframeSet floatKeyframeSet) {
            super(string2, null);
            this.mValueType = Float.TYPE;
            this.mKeyframeSet = floatKeyframeSet;
            this.mFloatKeyframeSet = (FloatKeyframeSet)this.mKeyframeSet;
        }

        public FloatPropertyValuesHolder(String string2, float ... fArray) {
            super(string2, null);
            this.setFloatValues(fArray);
        }

        @Override
        void calculateValue(float f) {
            this.mFloatAnimatedValue = this.mFloatKeyframeSet.getFloatValue(f);
        }

        @Override
        public FloatPropertyValuesHolder clone() {
            FloatPropertyValuesHolder floatPropertyValuesHolder = (FloatPropertyValuesHolder)super.clone();
            floatPropertyValuesHolder.mFloatKeyframeSet = (FloatKeyframeSet)floatPropertyValuesHolder.mKeyframeSet;
            return floatPropertyValuesHolder;
        }

        @Override
        Object getAnimatedValue() {
            return Float.valueOf(this.mFloatAnimatedValue);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        void setAnimatedValue(Object object) {
            if (this.mSetter == null) return;
            try {
                this.mTmpValueArray[0] = Float.valueOf(this.mFloatAnimatedValue);
                this.mSetter.invoke(object, this.mTmpValueArray);
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.e((String)"PropertyValuesHolder", (String)invocationTargetException.toString());
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.e((String)"PropertyValuesHolder", (String)illegalAccessException.toString());
                return;
            }
        }

        @Override
        public void setFloatValues(float ... fArray) {
            super.setFloatValues(fArray);
            this.mFloatKeyframeSet = (FloatKeyframeSet)this.mKeyframeSet;
        }

        @Override
        void setupSetter(Class clazz) {
            super.setupSetter(clazz);
        }
    }

    static class IntPropertyValuesHolder
    extends PropertyValuesHolder {
        int mIntAnimatedValue;
        IntKeyframeSet mIntKeyframeSet;

        public IntPropertyValuesHolder(String string2, IntKeyframeSet intKeyframeSet) {
            super(string2, null);
            this.mValueType = Integer.TYPE;
            this.mKeyframeSet = intKeyframeSet;
            this.mIntKeyframeSet = (IntKeyframeSet)this.mKeyframeSet;
        }

        public IntPropertyValuesHolder(String string2, int ... nArray) {
            super(string2, null);
            this.setIntValues(nArray);
        }

        @Override
        void calculateValue(float f) {
            this.mIntAnimatedValue = this.mIntKeyframeSet.getIntValue(f);
        }

        @Override
        public IntPropertyValuesHolder clone() {
            IntPropertyValuesHolder intPropertyValuesHolder = (IntPropertyValuesHolder)super.clone();
            intPropertyValuesHolder.mIntKeyframeSet = (IntKeyframeSet)intPropertyValuesHolder.mKeyframeSet;
            return intPropertyValuesHolder;
        }

        @Override
        Object getAnimatedValue() {
            return this.mIntAnimatedValue;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        void setAnimatedValue(Object object) {
            if (this.mSetter == null) return;
            try {
                this.mTmpValueArray[0] = this.mIntAnimatedValue;
                this.mSetter.invoke(object, this.mTmpValueArray);
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.e((String)"PropertyValuesHolder", (String)invocationTargetException.toString());
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.e((String)"PropertyValuesHolder", (String)illegalAccessException.toString());
                return;
            }
        }

        @Override
        public void setIntValues(int ... nArray) {
            super.setIntValues(nArray);
            this.mIntKeyframeSet = (IntKeyframeSet)this.mKeyframeSet;
        }

        @Override
        void setupSetter(Class clazz) {
            super.setupSetter(clazz);
        }
    }
}

