/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.nineoldandroids.animation;

import com.actionbarsherlock.internal.nineoldandroids.animation.PropertyValuesHolder;
import com.actionbarsherlock.internal.nineoldandroids.animation.TypeEvaluator;
import com.actionbarsherlock.internal.nineoldandroids.animation.ValueAnimator;

public final class ObjectAnimator
extends ValueAnimator {
    private static final boolean DBG;
    private String mPropertyName;
    private Object mTarget;

    public ObjectAnimator() {
    }

    private ObjectAnimator(Object object, String string2) {
        this.mTarget = object;
        this.setPropertyName(string2);
    }

    public static ObjectAnimator ofFloat(Object object, String string2, float ... fArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(object, string2);
        objectAnimator.setFloatValues(fArray);
        return objectAnimator;
    }

    public static ObjectAnimator ofInt(Object object, String string2, int ... nArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(object, string2);
        objectAnimator.setIntValues(nArray);
        return objectAnimator;
    }

    public static ObjectAnimator ofObject(Object object, String string2, TypeEvaluator typeEvaluator, Object ... objectArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator(object, string2);
        objectAnimator.setObjectValues(objectArray);
        objectAnimator.setEvaluator(typeEvaluator);
        return objectAnimator;
    }

    public static ObjectAnimator ofPropertyValuesHolder(Object object, PropertyValuesHolder ... propertyValuesHolderArray) {
        ObjectAnimator objectAnimator = new ObjectAnimator();
        objectAnimator.mTarget = object;
        objectAnimator.setValues(propertyValuesHolderArray);
        return objectAnimator;
    }

    @Override
    void animateValue(float f) {
        super.animateValue(f);
        int n = this.mValues.length;
        int n2 = 0;
        while (n2 < n) {
            this.mValues[n2].setAnimatedValue(this.mTarget);
            ++n2;
        }
        return;
    }

    @Override
    public ObjectAnimator clone() {
        return (ObjectAnimator)super.clone();
    }

    public String getPropertyName() {
        return this.mPropertyName;
    }

    public Object getTarget() {
        return this.mTarget;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void initAnimation() {
        if (this.mInitialized) return;
        int n = this.mValues.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                super.initAnimation();
                return;
            }
            this.mValues[n2].setupSetterAndGetter(this.mTarget);
            ++n2;
        }
    }

    @Override
    public ObjectAnimator setDuration(long l) {
        super.setDuration(l);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setFloatValues(float ... fArray) {
        if (this.mValues == null || this.mValues.length == 0) {
            PropertyValuesHolder[] propertyValuesHolderArray = new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat(this.mPropertyName, fArray)};
            this.setValues(propertyValuesHolderArray);
            return;
        }
        super.setFloatValues(fArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setIntValues(int ... nArray) {
        if (this.mValues == null || this.mValues.length == 0) {
            PropertyValuesHolder[] propertyValuesHolderArray = new PropertyValuesHolder[]{PropertyValuesHolder.ofInt(this.mPropertyName, nArray)};
            this.setValues(propertyValuesHolderArray);
            return;
        }
        super.setIntValues(nArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setObjectValues(Object ... objectArray) {
        if (this.mValues == null || this.mValues.length == 0) {
            PropertyValuesHolder[] propertyValuesHolderArray = new PropertyValuesHolder[]{PropertyValuesHolder.ofObject(this.mPropertyName, null, objectArray)};
            this.setValues(propertyValuesHolderArray);
            return;
        }
        super.setObjectValues(objectArray);
    }

    public void setPropertyName(String string2) {
        if (this.mValues != null) {
            PropertyValuesHolder propertyValuesHolder = this.mValues[0];
            String string3 = propertyValuesHolder.getPropertyName();
            propertyValuesHolder.setPropertyName(string2);
            this.mValuesMap.remove(string3);
            this.mValuesMap.put(string2, propertyValuesHolder);
        }
        this.mPropertyName = string2;
        this.mInitialized = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setTarget(Object object) {
        block4: {
            block3: {
                if (this.mTarget == object) break block3;
                Object object2 = this.mTarget;
                this.mTarget = object;
                if (object2 == null || object == null || object2.getClass() != object.getClass()) break block4;
            }
            return;
        }
        this.mInitialized = false;
    }

    @Override
    public void setupEndValues() {
        this.initAnimation();
        int n = this.mValues.length;
        int n2 = 0;
        while (n2 < n) {
            this.mValues[n2].setupEndValue(this.mTarget);
            ++n2;
        }
        return;
    }

    @Override
    public void setupStartValues() {
        this.initAnimation();
        int n = this.mValues.length;
        int n2 = 0;
        while (n2 < n) {
            this.mValues[n2].setupStartValue(this.mTarget);
            ++n2;
        }
        return;
    }

    @Override
    public void start() {
        super.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String toString() {
        String string2 = "ObjectAnimator@" + Integer.toHexString(this.hashCode()) + ", target " + this.mTarget;
        if (this.mValues == null) return string2;
        int n = 0;
        while (n < this.mValues.length) {
            string2 = String.valueOf(string2) + "\n    " + this.mValues[n].toString();
            ++n;
        }
        return string2;
    }
}

