/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.nineoldandroids.animation;

import android.view.animation.Interpolator;
import com.actionbarsherlock.internal.nineoldandroids.animation.Keyframe;
import com.actionbarsherlock.internal.nineoldandroids.animation.KeyframeSet;
import java.util.ArrayList;

class IntKeyframeSet
extends KeyframeSet {
    private int deltaValue;
    private boolean firstTime = true;
    private int firstValue;
    private int lastValue;

    public IntKeyframeSet(Keyframe.IntKeyframe ... intKeyframeArray) {
        super(intKeyframeArray);
    }

    @Override
    public IntKeyframeSet clone() {
        ArrayList arrayList = this.mKeyframes;
        int n = this.mKeyframes.size();
        Keyframe.IntKeyframe[] intKeyframeArray = new Keyframe.IntKeyframe[n];
        int n2 = 0;
        while (n2 < n) {
            intKeyframeArray[n2] = (Keyframe.IntKeyframe)((Keyframe)arrayList.get(n2)).clone();
            ++n2;
        }
        return new IntKeyframeSet(intKeyframeArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getIntValue(float f) {
        if (this.mNumKeyframes == 2) {
            if (this.firstTime) {
                this.firstTime = false;
                this.firstValue = ((Keyframe.IntKeyframe)this.mKeyframes.get(0)).getIntValue();
                this.lastValue = ((Keyframe.IntKeyframe)this.mKeyframes.get(1)).getIntValue();
                this.deltaValue = this.lastValue - this.firstValue;
            }
            if (this.mInterpolator != null) {
                f = this.mInterpolator.getInterpolation(f);
            }
            if (this.mEvaluator != null) return ((Number)this.mEvaluator.evaluate(f, this.firstValue, this.lastValue)).intValue();
            return this.firstValue + (int)(f * (float)this.deltaValue);
        }
        if (f <= 0.0f) {
            Keyframe.IntKeyframe intKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(0);
            Keyframe.IntKeyframe intKeyframe2 = (Keyframe.IntKeyframe)this.mKeyframes.get(1);
            int n = intKeyframe.getIntValue();
            int n2 = intKeyframe2.getIntValue();
            float f2 = intKeyframe.getFraction();
            float f3 = intKeyframe2.getFraction();
            Interpolator interpolator = intKeyframe2.getInterpolator();
            if (interpolator != null) {
                f = interpolator.getInterpolation(f);
            }
            float f4 = (f - f2) / (f3 - f2);
            if (this.mEvaluator != null) return ((Number)this.mEvaluator.evaluate(f4, n, n2)).intValue();
            return n + (int)(f4 * (float)(n2 - n));
        }
        if (f >= 1.0f) {
            Keyframe.IntKeyframe intKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(-2 + this.mNumKeyframes);
            Keyframe.IntKeyframe intKeyframe3 = (Keyframe.IntKeyframe)this.mKeyframes.get(-1 + this.mNumKeyframes);
            int n = intKeyframe.getIntValue();
            int n3 = intKeyframe3.getIntValue();
            float f5 = intKeyframe.getFraction();
            float f6 = intKeyframe3.getFraction();
            Interpolator interpolator = intKeyframe3.getInterpolator();
            if (interpolator != null) {
                f = interpolator.getInterpolation(f);
            }
            float f7 = (f - f5) / (f6 - f5);
            if (this.mEvaluator != null) return ((Number)this.mEvaluator.evaluate(f7, n, n3)).intValue();
            return n + (int)(f7 * (float)(n3 - n));
        }
        Keyframe.IntKeyframe intKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(0);
        int n = 1;
        while (n < this.mNumKeyframes) {
            Keyframe.IntKeyframe intKeyframe4 = (Keyframe.IntKeyframe)this.mKeyframes.get(n);
            if (f < intKeyframe4.getFraction()) {
                Interpolator interpolator = intKeyframe4.getInterpolator();
                if (interpolator != null) {
                    f = interpolator.getInterpolation(f);
                }
                float f8 = (f - intKeyframe.getFraction()) / (intKeyframe4.getFraction() - intKeyframe.getFraction());
                int n4 = intKeyframe.getIntValue();
                int n5 = intKeyframe4.getIntValue();
                if (this.mEvaluator != null) return ((Number)this.mEvaluator.evaluate(f8, n4, n5)).intValue();
                return n4 + (int)(f8 * (float)(n5 - n4));
            }
            intKeyframe = intKeyframe4;
            ++n;
        }
        return ((Number)((Keyframe)this.mKeyframes.get(-1 + this.mNumKeyframes)).getValue()).intValue();
    }

    @Override
    public Object getValue(float f) {
        return this.getIntValue(f);
    }
}

