/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.os.Build;
import android.support.v4.view.MenuItemCompatHoneycomb;
import android.view.MenuItem;

public class MenuCompat {
    static final MenuVersionImpl IMPL;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        if (Build.VERSION.SDK_INT >= 11) {
            IMPL = new HoneycombMenuVersionImpl();
            return;
        }
        IMPL = new BaseMenuVersionImpl();
    }

    public static boolean setShowAsAction(MenuItem menuItem, int n) {
        return IMPL.setShowAsAction(menuItem, n);
    }

    static class HoneycombMenuVersionImpl
    implements MenuVersionImpl {
        HoneycombMenuVersionImpl() {
        }

        @Override
        public boolean setShowAsAction(MenuItem menuItem, int n) {
            MenuItemCompatHoneycomb.setShowAsAction(menuItem, n);
            return true;
        }
    }

    static class BaseMenuVersionImpl
    implements MenuVersionImpl {
        BaseMenuVersionImpl() {
        }

        @Override
        public boolean setShowAsAction(MenuItem menuItem, int n) {
            return false;
        }
    }

    static interface MenuVersionImpl {
        public boolean setShowAsAction(MenuItem var1, int var2);
    }
}

