/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.util;

public class SparseArrayCompat<E> {
    private static final Object DELETED = new Object();
    private boolean mGarbage = false;
    private int[] mKeys;
    private int mSize;
    private Object[] mValues;

    public SparseArrayCompat() {
        this(10);
    }

    public SparseArrayCompat(int n) {
        int n2 = SparseArrayCompat.idealIntArraySize(n);
        this.mKeys = new int[n2];
        this.mValues = new Object[n2];
        this.mSize = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int binarySearch(int[] nArray, int n, int n2, int n3) {
        int n4 = n + n2;
        int n5 = n + -1;
        while (n4 - n5 > 1) {
            int n6 = (n4 + n5) / 2;
            if (nArray[n6] < n3) {
                n5 = n6;
                continue;
            }
            n4 = n6;
        }
        if (n4 == n + n2) {
            return 0xFFFFFFFF ^ n + n2;
        }
        if (nArray[n4] == n3) return n4;
        n4 ^= 0xFFFFFFFF;
        return n4;
    }

    private void gc() {
        int n = this.mSize;
        int n2 = 0;
        int[] nArray = this.mKeys;
        Object[] objectArray = this.mValues;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            if (object == DELETED) continue;
            if (i != n2) {
                nArray[n2] = nArray[i];
                objectArray[n2] = object;
            }
            ++n2;
        }
        this.mGarbage = false;
        this.mSize = n2;
    }

    static int idealByteArraySize(int n) {
        int n2 = 4;
        while (true) {
            block4: {
                block3: {
                    if (n2 >= 32) break block3;
                    if (n > -12 + (1 << n2)) break block4;
                    n = -12 + (1 << n2);
                }
                return n;
            }
            ++n2;
        }
    }

    static int idealIntArraySize(int n) {
        return SparseArrayCompat.idealByteArraySize(n * 4) / 4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void append(int n, E e) {
        int n2;
        if (this.mSize != 0 && n <= this.mKeys[-1 + this.mSize]) {
            this.put(n, e);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if ((n2 = this.mSize) >= this.mKeys.length) {
            int n3 = SparseArrayCompat.idealIntArraySize(n2 + 1);
            int[] nArray = new int[n3];
            Object[] objectArray = new Object[n3];
            System.arraycopy(this.mKeys, 0, nArray, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, objectArray, 0, this.mValues.length);
            this.mKeys = nArray;
            this.mValues = objectArray;
        }
        this.mKeys[n2] = n;
        this.mValues[n2] = e;
        this.mSize = n2 + 1;
    }

    public void clear() {
        int n = this.mSize;
        Object[] objectArray = this.mValues;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public void delete(int n) {
        int n2 = SparseArrayCompat.binarySearch(this.mKeys, 0, this.mSize, n);
        if (n2 >= 0 && this.mValues[n2] != DELETED) {
            this.mValues[n2] = DELETED;
            this.mGarbage = true;
        }
    }

    public E get(int n) {
        return this.get(n, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public E get(int n, E object) {
        void var2_3;
        int n2 = SparseArrayCompat.binarySearch(this.mKeys, 0, this.mSize, n);
        if (n2 < 0 || this.mValues[n2] == DELETED) {
            return var2_3;
        }
        Object object2 = this.mValues[n2];
        return var2_3;
    }

    public int indexOfKey(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return SparseArrayCompat.binarySearch(this.mKeys, 0, this.mSize, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int indexOfValue(E e) {
        if (this.mGarbage) {
            this.gc();
        }
        int n = 0;
        while (n < this.mSize) {
            if (this.mValues[n] == e) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int keyAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[n];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void put(int n, E e) {
        int n2 = SparseArrayCompat.binarySearch(this.mKeys, 0, this.mSize, n);
        if (n2 >= 0) {
            this.mValues[n2] = e;
            return;
        }
        int n3 = ~n2;
        if (n3 < this.mSize && this.mValues[n3] == DELETED) {
            this.mKeys[n3] = n;
            this.mValues[n3] = e;
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
            n3 = 0xFFFFFFFF ^ SparseArrayCompat.binarySearch(this.mKeys, 0, this.mSize, n);
        }
        if (this.mSize >= this.mKeys.length) {
            int n4 = SparseArrayCompat.idealIntArraySize(1 + this.mSize);
            int[] nArray = new int[n4];
            Object[] objectArray = new Object[n4];
            System.arraycopy(this.mKeys, 0, nArray, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, objectArray, 0, this.mValues.length);
            this.mKeys = nArray;
            this.mValues = objectArray;
        }
        if (this.mSize - n3 != 0) {
            System.arraycopy(this.mKeys, n3, this.mKeys, n3 + 1, this.mSize - n3);
            System.arraycopy(this.mValues, n3, this.mValues, n3 + 1, this.mSize - n3);
        }
        this.mKeys[n3] = n;
        this.mValues[n3] = e;
        this.mSize = 1 + this.mSize;
    }

    public void remove(int n) {
        this.delete(n);
    }

    public void removeAt(int n) {
        if (this.mValues[n] != DELETED) {
            this.mValues[n] = DELETED;
            this.mGarbage = true;
        }
    }

    public void removeAtRange(int n, int n2) {
        int n3 = Math.min(this.mSize, n + n2);
        for (int i = n; i < n3; ++i) {
            this.removeAt(i);
        }
    }

    public void setValueAt(int n, E e) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[n] = e;
    }

    public int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public E valueAt(int n) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[n];
    }
}

