/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.NavUtils;
import android.support.v4.app.TaskStackBuilderHoneycomb;
import android.support.v4.app.TaskStackBuilderJellybean;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import java.util.ArrayList;
import java.util.Iterator;

public class TaskStackBuilder
implements Iterable<Intent> {
    private static final TaskStackBuilderImpl IMPL;
    private static final String TAG = "TaskStackBuilder";
    private final ArrayList<Intent> mIntents = new ArrayList();
    private final Context mSourceContext;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        if (Build.VERSION.SDK_INT >= 11) {
            IMPL = new TaskStackBuilderImplHoneycomb();
            return;
        }
        IMPL = new TaskStackBuilderImplBase();
    }

    private TaskStackBuilder(Context context) {
        this.mSourceContext = context;
    }

    public static TaskStackBuilder create(Context context) {
        return new TaskStackBuilder(context);
    }

    public static TaskStackBuilder from(Context context) {
        return TaskStackBuilder.create(context);
    }

    public TaskStackBuilder addNextIntent(Intent intent) {
        this.mIntents.add(intent);
        return this;
    }

    public TaskStackBuilder addParentStack(Activity activity) {
        int n = this.mIntents.size();
        Intent intent = NavUtils.getParentActivityIntent(activity);
        while (intent != null) {
            this.mIntents.add(n, intent);
            try {
                Intent intent2;
                intent = intent2 = NavUtils.getParentActivityIntent((Context)activity, intent.getComponent());
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.e((String)TAG, (String)"Bad ComponentName while traversing activity parent metadata");
                throw new IllegalArgumentException(nameNotFoundException);
            }
        }
        return this;
    }

    public TaskStackBuilder addParentStack(Class<?> clazz) {
        int n = this.mIntents.size();
        try {
            Intent intent = NavUtils.getParentActivityIntent(this.mSourceContext, clazz);
            while (intent != null) {
                Intent intent2;
                this.mIntents.add(n, intent);
                intent = intent2 = NavUtils.getParentActivityIntent(this.mSourceContext, intent.getComponent());
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)TAG, (String)"Bad ComponentName while traversing activity parent metadata");
            throw new IllegalArgumentException(nameNotFoundException);
        }
        return this;
    }

    public Intent editIntentAt(int n) {
        return this.mIntents.get(n);
    }

    public Intent getIntent(int n) {
        return this.editIntentAt(n);
    }

    public int getIntentCount() {
        return this.mIntents.size();
    }

    public Intent[] getIntents() {
        return this.mIntents.toArray(new Intent[this.mIntents.size()]);
    }

    public PendingIntent getPendingIntent(int n, int n2) {
        return this.getPendingIntent(n, n2, null);
    }

    public PendingIntent getPendingIntent(int n, int n2, Bundle bundle) {
        if (this.mIntents.isEmpty()) {
            throw new IllegalStateException("No intents added to TaskStackBuilder; cannot getPendingIntent");
        }
        Intent[] intentArray = this.mIntents.toArray(new Intent[this.mIntents.size()]);
        intentArray[0].addFlags(0x1000C000);
        return IMPL.getPendingIntent(this.mSourceContext, intentArray, n, n2, bundle);
    }

    @Override
    public Iterator<Intent> iterator() {
        return this.mIntents.iterator();
    }

    public void startActivities() {
        this.startActivities(null);
    }

    public void startActivities(Bundle bundle) {
        if (this.mIntents.isEmpty()) {
            throw new IllegalStateException("No intents added to TaskStackBuilder; cannot startActivities");
        }
        Intent[] intentArray = this.mIntents.toArray(new Intent[this.mIntents.size()]);
        intentArray[0].addFlags(0x1000C000);
        if (!ContextCompat.startActivities(this.mSourceContext, intentArray, bundle)) {
            Intent intent = intentArray[-1 + intentArray.length];
            intent.addFlags(0x10000000);
            this.mSourceContext.startActivity(intent);
        }
    }

    static class TaskStackBuilderImplJellybean
    implements TaskStackBuilderImpl {
        TaskStackBuilderImplJellybean() {
        }

        @Override
        public PendingIntent getPendingIntent(Context context, Intent[] intentArray, int n, int n2, Bundle bundle) {
            intentArray[0].addFlags(0x10008000);
            return TaskStackBuilderJellybean.getActivitiesPendingIntent(context, n, intentArray, n2, bundle);
        }
    }

    static class TaskStackBuilderImplHoneycomb
    implements TaskStackBuilderImpl {
        TaskStackBuilderImplHoneycomb() {
        }

        @Override
        public PendingIntent getPendingIntent(Context context, Intent[] intentArray, int n, int n2, Bundle bundle) {
            intentArray[0].addFlags(0x10008000);
            return TaskStackBuilderHoneycomb.getActivitiesPendingIntent(context, n, intentArray, n2);
        }
    }

    static class TaskStackBuilderImplBase
    implements TaskStackBuilderImpl {
        TaskStackBuilderImplBase() {
        }

        @Override
        public PendingIntent getPendingIntent(Context context, Intent[] intentArray, int n, int n2, Bundle bundle) {
            Intent intent = intentArray[-1 + intentArray.length];
            intent.addFlags(0x10000000);
            return PendingIntent.getActivity((Context)context, (int)n, (Intent)intent, (int)n2);
        }
    }

    static interface TaskStackBuilderImpl {
        public PendingIntent getPendingIntent(Context var1, Intent[] var2, int var3, int var4, Bundle var5);
    }
}

