/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.v4.app.NavUtilsJB;

public class NavUtils {
    private static final NavUtilsImpl IMPL;
    public static final String PARENT_ACTIVITY = "android.support.PARENT_ACTIVITY";
    private static final String TAG = "NavUtils";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        if (Build.VERSION.SDK_INT >= 16) {
            IMPL = new NavUtilsImplJB();
            return;
        }
        IMPL = new NavUtilsImplBase();
    }

    private NavUtils() {
    }

    public static Intent getParentActivityIntent(Activity activity) {
        return IMPL.getParentActivityIntent(activity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Intent getParentActivityIntent(Context context, ComponentName componentName) throws PackageManager.NameNotFoundException {
        String string2 = NavUtils.getParentActivityName(context, componentName);
        if (string2 != null) return new Intent().setClassName(componentName.getPackageName(), string2);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Intent getParentActivityIntent(Context context, Class<?> clazz) throws PackageManager.NameNotFoundException {
        String string2 = NavUtils.getParentActivityName(context, new ComponentName(context, clazz));
        if (string2 != null) return new Intent().setClassName(context, string2);
        return null;
    }

    public static String getParentActivityName(Activity activity) {
        try {
            String string2 = NavUtils.getParentActivityName((Context)activity, activity.getComponentName());
            return string2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalArgumentException(nameNotFoundException);
        }
    }

    public static String getParentActivityName(Context context, ComponentName componentName) throws PackageManager.NameNotFoundException {
        ActivityInfo activityInfo = context.getPackageManager().getActivityInfo(componentName, 128);
        return IMPL.getParentActivityName(context, activityInfo);
    }

    public static void navigateUpFromSameTask(Activity activity) {
        Intent intent = NavUtils.getParentActivityIntent(activity);
        if (intent == null) {
            throw new IllegalArgumentException("Activity " + activity.getClass().getSimpleName() + " does not have a parent activity name specified." + " (Did you forget to add the android.support.PARENT_ACTIVITY <meta-data> " + " element in your manifest?)");
        }
        NavUtils.navigateUpTo(activity, intent);
    }

    public static void navigateUpTo(Activity activity, Intent intent) {
        IMPL.navigateUpTo(activity, intent);
    }

    public static boolean shouldUpRecreateTask(Activity activity, Intent intent) {
        return IMPL.shouldUpRecreateTask(activity, intent);
    }

    static class NavUtilsImplJB
    extends NavUtilsImplBase {
        NavUtilsImplJB() {
        }

        @Override
        public Intent getParentActivityIntent(Activity activity) {
            Intent intent = NavUtilsJB.getParentActivityIntent(activity);
            if (intent == null) {
                intent = super.getParentActivityIntent(activity);
            }
            return intent;
        }

        @Override
        public String getParentActivityName(Context context, ActivityInfo activityInfo) {
            String string2 = NavUtilsJB.getParentActivityName(activityInfo);
            if (string2 == null) {
                string2 = super.getParentActivityName(context, activityInfo);
            }
            return string2;
        }

        @Override
        public void navigateUpTo(Activity activity, Intent intent) {
            NavUtilsJB.navigateUpTo(activity, intent);
        }

        @Override
        public boolean shouldUpRecreateTask(Activity activity, Intent intent) {
            return NavUtilsJB.shouldUpRecreateTask(activity, intent);
        }
    }

    static class NavUtilsImplBase
    implements NavUtilsImpl {
        NavUtilsImplBase() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Intent getParentActivityIntent(Activity activity) {
            String string2 = NavUtils.getParentActivityName(activity);
            if (string2 != null) return new Intent().setClassName((Context)activity, string2);
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public String getParentActivityName(Context context, ActivityInfo activityInfo) {
            if (activityInfo.metaData == null) {
                return null;
            }
            String string2 = activityInfo.metaData.getString(NavUtils.PARENT_ACTIVITY);
            if (string2 == null) {
                return null;
            }
            if (string2.charAt(0) != '.') return string2;
            return context.getPackageName() + string2;
        }

        @Override
        public void navigateUpTo(Activity activity, Intent intent) {
            intent.addFlags(0x4000000);
            activity.startActivity(intent);
            activity.finish();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean shouldUpRecreateTask(Activity activity, Intent intent) {
            String string2 = activity.getIntent().getAction();
            if (string2 == null) return false;
            if (string2.equals("android.intent.action.MAIN")) return false;
            return true;
        }
    }

    static interface NavUtilsImpl {
        public Intent getParentActivityIntent(Activity var1);

        public String getParentActivityName(Context var1, ActivityInfo var2);

        public void navigateUpTo(Activity var1, Intent var2);

        public boolean shouldUpRecreateTask(Activity var1, Intent var2);
    }
}

