/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.support.v4.app.ActivityCompatHoneycomb;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentManagerImpl;
import android.support.v4.app.LoaderManager;
import android.support.v4.app.LoaderManagerImpl;
import android.support.v4.util.SparseArrayCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;

public class FragmentActivity
extends Activity {
    private static final String FRAGMENTS_TAG = "android:support:fragments";
    private static final int HONEYCOMB = 11;
    static final int MSG_REALLY_STOPPED = 1;
    static final int MSG_RESUME_PENDING = 2;
    private static final String TAG = "FragmentActivity";
    SparseArrayCompat<LoaderManagerImpl> mAllLoaderManagers;
    boolean mCheckedForLoaderManager;
    boolean mCreated;
    final FragmentManagerImpl mFragments;
    final Handler mHandler = new Handler(){

        /*
         * Enabled aggressive block sorting
         */
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    super.handleMessage(message);
                    return;
                }
                case 1: {
                    if (!FragmentActivity.this.mStopped) return;
                    FragmentActivity.this.doReallyStop(false);
                    return;
                }
                case 2: 
            }
            FragmentActivity.this.onResumeFragments();
            FragmentActivity.this.mFragments.execPendingActions();
        }
    };
    LoaderManagerImpl mLoaderManager;
    boolean mLoadersStarted;
    boolean mOptionsMenuInvalidated;
    boolean mReallyStopped;
    boolean mResumed;
    boolean mRetaining;
    boolean mStopped;

    public FragmentActivity() {
        this.mFragments = new FragmentManagerImpl();
    }

    void doReallyStop(boolean bl) {
        if (!this.mReallyStopped) {
            this.mReallyStopped = true;
            this.mRetaining = bl;
            this.mHandler.removeMessages(1);
            this.onReallyStop();
        }
    }

    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        if (Build.VERSION.SDK_INT >= 11) {
            // empty if block
        }
        printWriter.print(string2);
        printWriter.print("Local FragmentActivity ");
        printWriter.print(Integer.toHexString(System.identityHashCode((Object)this)));
        printWriter.println(" State:");
        String string3 = string2 + "  ";
        printWriter.print(string3);
        printWriter.print("mCreated=");
        printWriter.print(this.mCreated);
        printWriter.print("mResumed=");
        printWriter.print(this.mResumed);
        printWriter.print(" mStopped=");
        printWriter.print(this.mStopped);
        printWriter.print(" mReallyStopped=");
        printWriter.println(this.mReallyStopped);
        printWriter.print(string3);
        printWriter.print("mLoadersStarted=");
        printWriter.println(this.mLoadersStarted);
        if (this.mLoaderManager != null) {
            printWriter.print(string2);
            printWriter.print("Loader Manager ");
            printWriter.print(Integer.toHexString(System.identityHashCode(this.mLoaderManager)));
            printWriter.println(":");
            this.mLoaderManager.dump(string2 + "  ", fileDescriptor, printWriter, stringArray);
        }
        this.mFragments.dump(string2, fileDescriptor, printWriter, stringArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getLastCustomNonConfigurationInstance() {
        NonConfigurationInstances nonConfigurationInstances = (NonConfigurationInstances)this.getLastNonConfigurationInstance();
        if (nonConfigurationInstances == null) return null;
        return nonConfigurationInstances.custom;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    LoaderManagerImpl getLoaderManager(int n, boolean bl, boolean bl2) {
        LoaderManagerImpl loaderManagerImpl;
        if (this.mAllLoaderManagers == null) {
            this.mAllLoaderManagers = new SparseArrayCompat();
        }
        if ((loaderManagerImpl = this.mAllLoaderManagers.get(n)) == null) {
            if (bl2) {
                loaderManagerImpl = new LoaderManagerImpl(this, bl);
                this.mAllLoaderManagers.put(n, loaderManagerImpl);
            }
            return loaderManagerImpl;
        }
        loaderManagerImpl.updateActivity(this);
        return loaderManagerImpl;
    }

    public FragmentManager getSupportFragmentManager() {
        return this.mFragments;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LoaderManager getSupportLoaderManager() {
        if (this.mLoaderManager != null) {
            return this.mLoaderManager;
        }
        this.mCheckedForLoaderManager = true;
        this.mLoaderManager = this.getLoaderManager(-1, this.mLoadersStarted, true);
        return this.mLoaderManager;
    }

    void invalidateSupportFragmentIndex(int n) {
        LoaderManagerImpl loaderManagerImpl;
        if (this.mAllLoaderManagers != null && (loaderManagerImpl = this.mAllLoaderManagers.get(n)) != null && !loaderManagerImpl.mRetaining) {
            loaderManagerImpl.doDestroy();
            this.mAllLoaderManagers.remove(n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onActivityResult(int n, int n2, Intent intent) {
        int n3 = n >> 16;
        if (n3 != 0) {
            int n4 = n3 + -1;
            if (this.mFragments.mActive == null || n4 < 0 || n4 >= this.mFragments.mActive.size()) {
                Log.w((String)TAG, (String)("Activity result fragment index out of range: 0x" + Integer.toHexString(n)));
                return;
            }
            Fragment fragment = this.mFragments.mActive.get(n4);
            if (fragment == null) {
                Log.w((String)TAG, (String)("Activity result no fragment exists for index: 0x" + Integer.toHexString(n)));
                return;
            }
            fragment.onActivityResult(0xFFFF & n, n2, intent);
            return;
        }
        super.onActivityResult(n, n2, intent);
    }

    public void onAttachFragment(Fragment fragment) {
    }

    public void onBackPressed() {
        if (!this.mFragments.popBackStackImmediate()) {
            this.finish();
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.mFragments.dispatchConfigurationChanged(configuration);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onCreate(Bundle bundle) {
        this.mFragments.attachActivity(this);
        if (this.getLayoutInflater().getFactory() == null) {
            this.getLayoutInflater().setFactory((LayoutInflater.Factory)this);
        }
        super.onCreate(bundle);
        NonConfigurationInstances nonConfigurationInstances = (NonConfigurationInstances)this.getLastNonConfigurationInstance();
        if (nonConfigurationInstances != null) {
            this.mAllLoaderManagers = nonConfigurationInstances.loaders;
        }
        if (bundle != null) {
            Parcelable parcelable = bundle.getParcelable(FRAGMENTS_TAG);
            FragmentManagerImpl fragmentManagerImpl = this.mFragments;
            ArrayList<Fragment> arrayList = nonConfigurationInstances != null ? nonConfigurationInstances.fragments : null;
            fragmentManagerImpl.restoreAllState(parcelable, arrayList);
        }
        this.mFragments.dispatchCreate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onCreatePanelMenu(int n, Menu menu2) {
        if (n != 0) return super.onCreatePanelMenu(n, menu2);
        boolean bl = super.onCreatePanelMenu(n, menu2) | this.mFragments.dispatchCreateOptionsMenu(menu2, this.getMenuInflater());
        if (Build.VERSION.SDK_INT < 11) return true;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public View onCreateView(String string2, Context context, AttributeSet attributeSet) {
        Fragment fragment = null;
        int n = 0;
        if (!"fragment".equals(string2)) {
            return super.onCreateView(string2, context, attributeSet);
        }
        String string3 = attributeSet.getAttributeValue(fragment, "class");
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, FragmentTag.Fragment);
        if (string3 == null) {
            string3 = typedArray.getString(n);
        }
        int n2 = typedArray.getResourceId(1, -1);
        String string4 = typedArray.getString(2);
        typedArray.recycle();
        if (n == -1 && n2 == -1 && string4 == null) {
            throw new IllegalArgumentException(attributeSet.getPositionDescription() + ": Must specify unique android:id, android:tag, or have a parent with an id for " + string3);
        }
        if (n2 != -1) {
            fragment = this.mFragments.findFragmentById(n2);
        }
        if (fragment == null && string4 != null) {
            fragment = this.mFragments.findFragmentByTag(string4);
        }
        if (fragment == null && n != -1) {
            fragment = this.mFragments.findFragmentById(n);
        }
        if (FragmentManagerImpl.DEBUG) {
            Log.v((String)TAG, (String)("onCreateView: id=0x" + Integer.toHexString(n2) + " fname=" + string3 + " existing=" + fragment));
        }
        if (fragment == null) {
            fragment = Fragment.instantiate((Context)this, string3);
            fragment.mFromLayout = true;
            int n3 = n2 != 0 ? n2 : n;
            fragment.mFragmentId = n3;
            fragment.mContainerId = n;
            fragment.mTag = string4;
            fragment.mInLayout = true;
            fragment.mFragmentManager = this.mFragments;
            fragment.onInflate(this, attributeSet, fragment.mSavedFragmentState);
            this.mFragments.addFragment(fragment, true);
        } else {
            if (fragment.mInLayout) {
                throw new IllegalArgumentException(attributeSet.getPositionDescription() + ": Duplicate id 0x" + Integer.toHexString(n2) + ", tag " + string4 + ", or parent id 0x" + Integer.toHexString(n) + " with another fragment for " + string3);
            }
            fragment.mInLayout = true;
            if (!fragment.mRetaining) {
                fragment.onInflate(this, attributeSet, fragment.mSavedFragmentState);
            }
            this.mFragments.moveToState(fragment);
        }
        if (fragment.mView == null) {
            throw new IllegalStateException("Fragment " + string3 + " did not create a view.");
        }
        if (n2 != 0) {
            fragment.mView.setId(n2);
        }
        if (fragment.mView.getTag() != null) return fragment.mView;
        fragment.mView.setTag((Object)string4);
        return fragment.mView;
    }

    protected void onDestroy() {
        super.onDestroy();
        this.doReallyStop(false);
        this.mFragments.dispatchDestroy();
        if (this.mLoaderManager != null) {
            this.mLoaderManager.doDestroy();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (Build.VERSION.SDK_INT >= 5) return super.onKeyDown(n, keyEvent);
        if (n != 4) return super.onKeyDown(n, keyEvent);
        if (keyEvent.getRepeatCount() != 0) return super.onKeyDown(n, keyEvent);
        this.onBackPressed();
        return true;
    }

    public void onLowMemory() {
        super.onLowMemory();
        this.mFragments.dispatchLowMemory();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onMenuItemSelected(int n, MenuItem menuItem) {
        if (super.onMenuItemSelected(n, menuItem)) {
            return true;
        }
        switch (n) {
            default: {
                return false;
            }
            case 0: {
                return this.mFragments.dispatchOptionsItemSelected(menuItem);
            }
            case 6: 
        }
        return this.mFragments.dispatchContextItemSelected(menuItem);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onPanelClosed(int n, Menu menu2) {
        switch (n) {
            default: {
                break;
            }
            case 0: {
                this.mFragments.dispatchOptionsMenuClosed(menu2);
            }
        }
        super.onPanelClosed(n, menu2);
    }

    protected void onPause() {
        super.onPause();
        this.mResumed = false;
        if (this.mHandler.hasMessages(2)) {
            this.mHandler.removeMessages(2);
            this.onResumeFragments();
        }
        this.mFragments.dispatchPause();
    }

    protected void onPostResume() {
        super.onPostResume();
        this.mHandler.removeMessages(2);
        this.onResumeFragments();
        this.mFragments.execPendingActions();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onPreparePanel(int n, View view, Menu menu2) {
        boolean bl = false;
        if (n != 0) return super.onPreparePanel(n, view, menu2);
        if (menu2 == null) return super.onPreparePanel(n, view, menu2);
        if (this.mOptionsMenuInvalidated) {
            this.mOptionsMenuInvalidated = bl;
            menu2.clear();
            this.onCreatePanelMenu(n, menu2);
        }
        if (!(super.onPreparePanel(n, view, menu2) | this.mFragments.dispatchPrepareOptionsMenu(menu2))) return bl;
        if (!menu2.hasVisibleItems()) return bl;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    void onReallyStop() {
        if (this.mLoadersStarted) {
            this.mLoadersStarted = false;
            if (this.mLoaderManager != null) {
                if (!this.mRetaining) {
                    this.mLoaderManager.doStop();
                } else {
                    this.mLoaderManager.doRetain();
                }
            }
        }
        this.mFragments.dispatchReallyStop();
    }

    protected void onResume() {
        super.onResume();
        this.mHandler.sendEmptyMessage(2);
        this.mResumed = true;
        this.mFragments.execPendingActions();
    }

    protected void onResumeFragments() {
        this.mFragments.dispatchResume();
    }

    public Object onRetainCustomNonConfigurationInstance() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final Object onRetainNonConfigurationInstance() {
        if (this.mStopped) {
            this.doReallyStop(true);
        }
        Object object = this.onRetainCustomNonConfigurationInstance();
        ArrayList<Fragment> arrayList = this.mFragments.retainNonConfig();
        boolean bl = false;
        if (this.mAllLoaderManagers != null) {
            for (int i = -1 + this.mAllLoaderManagers.size(); i >= 0; --i) {
                LoaderManagerImpl loaderManagerImpl = this.mAllLoaderManagers.valueAt(i);
                if (loaderManagerImpl.mRetaining) {
                    bl = true;
                    continue;
                }
                loaderManagerImpl.doDestroy();
                this.mAllLoaderManagers.removeAt(i);
            }
        }
        if (arrayList == null && !bl && object == null) {
            return null;
        }
        NonConfigurationInstances nonConfigurationInstances = new NonConfigurationInstances();
        nonConfigurationInstances.activity = null;
        nonConfigurationInstances.custom = object;
        nonConfigurationInstances.children = null;
        nonConfigurationInstances.fragments = arrayList;
        nonConfigurationInstances.loaders = this.mAllLoaderManagers;
        return nonConfigurationInstances;
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        Parcelable parcelable = this.mFragments.saveAllState();
        if (parcelable != null) {
            bundle.putParcelable(FRAGMENTS_TAG, parcelable);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onStart() {
        super.onStart();
        this.mStopped = false;
        this.mReallyStopped = false;
        this.mHandler.removeMessages(1);
        if (!this.mCreated) {
            this.mCreated = true;
            this.mFragments.dispatchActivityCreated();
        }
        this.mFragments.noteStateNotSaved();
        this.mFragments.execPendingActions();
        if (!this.mLoadersStarted) {
            this.mLoadersStarted = true;
            if (this.mLoaderManager != null) {
                this.mLoaderManager.doStart();
            } else if (!this.mCheckedForLoaderManager) {
                this.mLoaderManager = this.getLoaderManager(-1, this.mLoadersStarted, false);
            }
            this.mCheckedForLoaderManager = true;
        }
        this.mFragments.dispatchStart();
        if (this.mAllLoaderManagers != null) {
            for (int i = -1 + this.mAllLoaderManagers.size(); i >= 0; --i) {
                LoaderManagerImpl loaderManagerImpl = this.mAllLoaderManagers.valueAt(i);
                loaderManagerImpl.finishRetain();
                loaderManagerImpl.doReportStart();
            }
        }
    }

    protected void onStop() {
        super.onStop();
        this.mStopped = true;
        this.mHandler.sendEmptyMessage(1);
        this.mFragments.dispatchStop();
    }

    public void startActivityForResult(Intent intent, int n) {
        if (n != -1 && (0xFFFF0000 & n) != 0) {
            throw new IllegalArgumentException("Can only use lower 16 bits for requestCode");
        }
        super.startActivityForResult(intent, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startActivityFromFragment(Fragment fragment, Intent intent, int n) {
        if (n == -1) {
            super.startActivityForResult(intent, -1);
            return;
        }
        if ((0xFFFF0000 & n) != 0) {
            throw new IllegalArgumentException("Can only use lower 16 bits for requestCode");
        }
        super.startActivityForResult(intent, (1 + fragment.mIndex << 16) + (0xFFFF & n));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void supportInvalidateOptionsMenu() {
        if (Build.VERSION.SDK_INT >= 11) {
            ActivityCompatHoneycomb.invalidateOptionsMenu(this);
            return;
        }
        this.mOptionsMenuInvalidated = true;
    }

    static class FragmentTag {
        public static final int[] Fragment;
        public static final int Fragment_id = 1;
        public static final int Fragment_name = 0;
        public static final int Fragment_tag = 2;

        static {
            int[] nArray = new int[]{0x1010003, 0x10100D0, 0x10100D1};
            Fragment = nArray;
        }

        FragmentTag() {
        }
    }

    static final class NonConfigurationInstances {
        Object activity;
        HashMap<String, Object> children;
        Object custom;
        ArrayList<Fragment> fragments;
        SparseArrayCompat<LoaderManagerImpl> loaders;

        NonConfigurationInstances() {
        }
    }
}

