/*
 * Decompiled with CFR 0.152.
 */
package p.rn.name;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import p.rn.ClassInfo;
import p.rn.Scann;
import p.rn.util.AccUtils;

public class InitOut {
    private static Set<String> keywords = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));
    private int clzIndex = 0;
    private Set<String> clzMap = new TreeSet<String>();
    private Set<String> clzSet = new TreeSet<String>();
    private File from;
    private int maxLength = 40;
    private Set<String> memberMap = new TreeSet<String>();
    private int minLength = 2;
    private int pkgIndex = 0;
    private Set<String> pkgMap = new TreeSet<String>();
    private Set<String> pkgSet = new TreeSet<String>();

    private void doClass(String clz) {
        if (this.clzSet.contains(clz)) {
            return;
        }
        this.clzSet.add(clz);
        int index = clz.lastIndexOf(36);
        if (index > 0) {
            this.doClass(clz.substring(0, index));
            String cName = clz.substring(index + 1);
            try {
                Integer.parseInt(cName);
            }
            catch (Exception exception) {
                if (this.shouldRename(cName)) {
                    this.clzMap.add(String.format("c %s=CI%03d%s", clz, this.clzIndex++, this.short4LongName(cName)));
                }
            }
        } else {
            index = clz.lastIndexOf(47);
            if (index > 0) {
                this.doPkg(clz.substring(0, index));
                String cName = clz.substring(index + 1);
                if (this.shouldRename(cName)) {
                    this.clzMap.add(String.format("c %s=C%03d%s", clz, this.clzIndex++, this.short4LongName(cName)));
                }
            } else if (this.shouldRename(clz)) {
                this.clzMap.add(String.format("c %s=CI_%03d%s", clz, this.clzIndex++, this.short4LongName(clz)));
            }
        }
    }

    private String short4LongName(String name) {
        if (name.length() > this.maxLength) {
            return "x" + Integer.toHexString(name.hashCode());
        }
        return name;
    }

    private void doMethod(String owner, ClassInfo.MemberInfo member, int x) {
        if (x > 0 || this.shouldRename(member.name)) {
            if (member.desc.indexOf(40) >= 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(AccUtils.isStatic(member.access) ? "M" : "m");
                if (AccUtils.isPrivate(member.access)) {
                    sb.append("p");
                } else if (AccUtils.isPublic(member.access)) {
                    sb.append("P");
                }
                if (x > 0) {
                    sb.append(x);
                }
                sb.append(this.short4LongName(member.name));
                if (x > 0) {
                    this.memberMap.add("m " + owner + "." + member.name + member.desc + "=" + sb.toString());
                } else {
                    this.memberMap.add("m " + owner + "." + member.name + member.desc.substring(0, member.desc.indexOf(41) + 1) + "=" + sb.toString());
                }
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(AccUtils.isStatic(member.access) ? "F" : "f");
                if (AccUtils.isPrivate(member.access)) {
                    sb.append("p");
                } else if (AccUtils.isPublic(member.access)) {
                    sb.append("P");
                }
                if (x > 0) {
                    sb.append(x);
                }
                sb.append(this.short4LongName(member.name));
                if (x > 0) {
                    this.memberMap.add("m " + owner + "." + member.name + "[" + member.desc + "]" + "=" + sb.toString());
                } else {
                    this.memberMap.add("m " + owner + "." + member.name + "=" + sb.toString());
                }
            }
        }
    }

    private void doOut() throws IOException {
        Map<String, ClassInfo> map = Scann.scanLib(this.from);
        for (ClassInfo info : map.values()) {
            this.doClass(info.name);
            for (List<ClassInfo.MemberInfo> ms : info.members.values()) {
                if (ms.size() == 1) {
                    for (ClassInfo.MemberInfo m : ms) {
                        this.doMethod(info.name, m, 0);
                    }
                    continue;
                }
                int i = 1;
                for (ClassInfo.MemberInfo m : ms) {
                    this.doMethod(info.name, m, i++);
                }
            }
        }
    }

    private void doPkg(String pkg) {
        if (this.pkgSet.contains(pkg)) {
            return;
        }
        this.pkgSet.add(pkg);
        int index = pkg.lastIndexOf(47);
        if (index > 0) {
            this.doPkg(pkg.substring(0, index));
            String cName = pkg.substring(index + 1);
            if (this.shouldRename(cName)) {
                this.pkgMap.add(String.format("p %s=p%02d%s", pkg, this.pkgIndex++, this.short4LongName(cName)));
            }
        } else if (this.shouldRename(pkg)) {
            this.pkgMap.add(String.format("p %s=p%02d%s", pkg, this.pkgIndex++, this.short4LongName(pkg)));
        }
    }

    public InitOut from(File from) {
        this.from = from;
        return this;
    }

    public InitOut maxLength(int m) {
        this.maxLength = m;
        return this;
    }

    public InitOut minLength(int m) {
        this.minLength = m;
        return this;
    }

    private boolean shouldRename(String s) {
        return s.length() > this.maxLength || s.length() < this.minLength || keywords.contains(s);
    }

    public void to(File config) throws IOException {
        this.doOut();
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.pkgMap);
        list.addAll(this.clzMap);
        list.addAll(this.memberMap);
        FileUtils.writeLines((File)config, (String)"UTF-8", list);
    }
}

