/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.Constant;
import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Local;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.ValueBox;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.StmtList;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.ir.ts.BaseLiveAnalyze;
import com.googlecode.dex2jar.ir.ts.Cfg;
import com.googlecode.dex2jar.ir.ts.Transformer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ZeroTransformer
implements Transformer {
    private static final Integer ZERO = 0;

    @Override
    public void transform(IrMethod irMethod) {
        ZeroAnalyze za = new ZeroAnalyze(irMethod);
        za.analyze();
        List<Local> locals = irMethod.locals;
        int localSize = locals.size();
        StmtList stmts = irMethod.stmts;
        Stmt p = stmts.getFirst();
        while (p != null) {
            BaseLiveAnalyze.Phi[] frame = (BaseLiveAnalyze.Phi[])p._ls_forward_frame;
            if (frame != null && p._cfg_visited) {
                switch (p.et) {
                    case E0: {
                        if (p.st != Stmt.ST.LABEL || p._cfg_froms.size() <= 0) break;
                        int i = 0;
                        while (i < localSize) {
                            ZeroAnalyzePhi phi = (ZeroAnalyzePhi)frame[i];
                            Local local = locals.get(i);
                            if (phi != null && Boolean.FALSE.equals(phi.isZero)) {
                                for (Stmt from : p._cfg_froms) {
                                    if (!this.needInsertX(from, i)) continue;
                                    this.insertX(stmts, (LabelStmt)p, from, i, local);
                                }
                            }
                            ++i;
                        }
                        break;
                    }
                    case E1: {
                        Stmt.E1Stmt e1 = (Stmt.E1Stmt)p;
                        this.replace(e1.op, frame);
                        break;
                    }
                    case E2: {
                        Stmt.E2Stmt e2 = (Stmt.E2Stmt)p;
                        if (e2.op1.value.vt != Value.VT.LOCAL) {
                            this.replace(e2.op1, frame);
                        }
                        this.replace(e2.op2, frame);
                        break;
                    }
                    case En: {
                        Stmt.EnStmt en = (Stmt.EnStmt)p;
                        ValueBox[] valueBoxArray = en.ops;
                        int n = en.ops.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ValueBox vb = valueBoxArray[n2];
                            this.replace(vb, frame);
                            ++n2;
                        }
                        break;
                    }
                }
            }
            p = p.getNext();
        }
    }

    private void insertX(StmtList stmts, LabelStmt ls, Stmt p, int index, Local local) {
        switch (p.st) {
            case GOTO: 
            case IF: 
            case LOOKUP_SWITCH: 
            case TABLE_SWITCH: {
                stmts.insertBefore(p, Stmts.nAssign(local, Constant.nInt(0)));
            }
        }
    }

    private boolean needInsertX(Stmt p, int index) {
        BaseLiveAnalyze.Phi[] frame = (BaseLiveAnalyze.Phi[])p._ls_forward_frame;
        if (frame == null) {
            return false;
        }
        ZeroAnalyzePhi phi = (ZeroAnalyzePhi)frame[index];
        if (phi == null || phi.isZero == null) {
            return false;
        }
        return phi.isZero;
    }

    private void replace(ValueBox op, BaseLiveAnalyze.Phi[] frame) {
        if (op == null) {
            return;
        }
        Value value = op.value;
        switch (value.et) {
            case E0: {
                Value.E0Expr e0 = (Value.E0Expr)value;
                if (e0.vt != Value.VT.LOCAL) break;
                Local local = (Local)e0;
                ZeroAnalyzePhi phi = (ZeroAnalyzePhi)frame[local._ls_index];
                if (!Boolean.TRUE.equals(phi.isZero)) break;
                op.value = Constant.nInt(0);
                break;
            }
            case E1: {
                Value.E1Expr e1 = (Value.E1Expr)value;
                this.replace(e1.op, frame);
                break;
            }
            case E2: {
                Value.E2Expr e2 = (Value.E2Expr)value;
                this.replace(e2.op1, frame);
                this.replace(e2.op2, frame);
                break;
            }
            case En: {
                Value.EnExpr en = (Value.EnExpr)value;
                ValueBox[] valueBoxArray = en.ops;
                int n = en.ops.length;
                int n2 = 0;
                while (n2 < n) {
                    ValueBox vb = valueBoxArray[n2];
                    this.replace(vb, frame);
                    ++n2;
                }
                break;
            }
        }
    }

    private static class ZeroAnalyze
    extends BaseLiveAnalyze {
        @Override
        protected BaseLiveAnalyze.Phi newPhi() {
            return new ZeroAnalyzePhi();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            Stmt stmt = this.method.stmts.getFirst();
            while (stmt != null) {
                BaseLiveAnalyze.Phi[] frame = (BaseLiveAnalyze.Phi[])stmt._ls_forward_frame;
                if (frame != null) {
                    BaseLiveAnalyze.Phi[] phiArray = frame;
                    int n = frame.length;
                    int n2 = 0;
                    while (n2 < n) {
                        BaseLiveAnalyze.Phi p = phiArray[n2];
                        if (p == null) {
                            sb.append("_");
                        } else {
                            sb.append(p.toString());
                        }
                        ++n2;
                    }
                    sb.append(" | ");
                }
                sb.append(stmt.toString()).append('\n');
                stmt = stmt.getNext();
            }
            return sb.toString();
        }

        public ZeroAnalyze(IrMethod irMethod) {
            super(irMethod);
        }

        @Override
        protected void initCFG() {
            Cfg.createCFG(this.method);
        }

        @Override
        protected void onAssignLocal(BaseLiveAnalyze.Phi[] frame, BaseLiveAnalyze.Phi phi, Value value) {
            if (value.vt == Value.VT.CONSTANT) {
                ZeroAnalyzePhi zaf = (ZeroAnalyzePhi)phi;
                Constant c = (Constant)value;
                zaf.isZero = c.value instanceof Integer && ZERO.equals(c.value) ? Boolean.TRUE : Boolean.FALSE;
            } else if (value.vt == Value.VT.LOCAL) {
                Local local = (Local)value;
                ZeroAnalyzePhi zaf1 = (ZeroAnalyzePhi)phi;
                ZeroAnalyzePhi zaf2 = (ZeroAnalyzePhi)frame[local._ls_index];
                zaf1.assignFrom.add(zaf2);
                zaf2.assignTo.add(zaf1);
            } else {
                ZeroAnalyzePhi zaf = (ZeroAnalyzePhi)phi;
                zaf.isZero = Boolean.FALSE;
            }
        }

        @Override
        protected void analyzePhi() {
            super.analyzePhi();
            LinkedList<ZeroAnalyzePhi> queue = new LinkedList<ZeroAnalyzePhi>();
            queue.addAll(this.phis);
            while (!queue.isEmpty()) {
                ZeroAnalyzePhi cp;
                ZeroAnalyzePhi phi = (ZeroAnalyzePhi)queue.poll();
                if (!Boolean.FALSE.equals(phi.isZero)) continue;
                for (BaseLiveAnalyze.Phi p : phi.children) {
                    cp = (ZeroAnalyzePhi)p;
                    if (cp.isZero != null) continue;
                    cp.isZero = Boolean.FALSE;
                    queue.add(cp);
                }
                for (BaseLiveAnalyze.Phi p : phi.assignTo) {
                    cp = (ZeroAnalyzePhi)p;
                    if (cp.isZero != null) continue;
                    cp.isZero = Boolean.FALSE;
                    queue.add(cp);
                }
            }
            for (BaseLiveAnalyze.Phi p : this.phis) {
                ZeroAnalyzePhi cp = (ZeroAnalyzePhi)p;
                if (cp.isZero != null) continue;
                cp.isZero = Boolean.TRUE;
            }
        }
    }

    static class ZeroAnalyzePhi
    extends BaseLiveAnalyze.Phi {
        public Boolean isZero = null;
        public Set<BaseLiveAnalyze.Phi> assignFrom = new HashSet<BaseLiveAnalyze.Phi>(3);
        public Set<BaseLiveAnalyze.Phi> assignTo = new HashSet<BaseLiveAnalyze.Phi>(3);

        ZeroAnalyzePhi() {
        }

        @Override
        public String toString() {
            if (this.isZero == null) {
                return "?";
            }
            return this.isZero != false ? "Z" : ".";
        }
    }
}

