/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.DedexerTask;
import hu.uw.pallergabor.dedexer.DexInstructionParser;
import java.io.IOException;
import java.util.ArrayList;

public class TaskCollection
extends DedexerTask {
    private ArrayList<DedexerTask> taskList = new ArrayList();

    public TaskCollection(DexInstructionParser instrParser, DedexerTask initialTask) {
        super(instrParser, 0L, 0L);
        this.taskList.add(initialTask);
    }

    @Override
    public void doTask(boolean isSecondPass) throws IOException {
        for (int i = 0; i < this.taskList.size(); ++i) {
            this.taskList.get(i).doTask(isSecondPass);
        }
    }

    @Override
    public void renderTask(long position) throws IOException {
        for (int i = 0; i < this.taskList.size(); ++i) {
            DedexerTask task = this.taskList.get(i);
            task.renderTask(position);
        }
    }

    @Override
    public boolean equals(String str) {
        for (int i = 0; i < this.taskList.size(); ++i) {
            if (!this.taskList.get(i).equals(str)) continue;
            return true;
        }
        return false;
    }

    public void addTask(DedexerTask task) {
        for (int i = 0; i < this.taskList.size(); ++i) {
            DedexerTask existingTask = this.taskList.get(i);
            if (!task.equals(existingTask)) continue;
            return;
        }
        int taskPriority = task.getPriority();
        boolean found = false;
        for (int i = 0; i < this.taskList.size(); ++i) {
            int listTaskPriority = this.taskList.get(i).getPriority();
            if (taskPriority <= listTaskPriority) continue;
            this.taskList.add(i, task);
            found = true;
            break;
        }
        if (!found) {
            this.taskList.add(task);
        }
    }

    @Override
    public int getPriority() {
        int priority = 0;
        for (int i = 0; i < this.taskList.size(); ++i) {
            int taskPriority = this.taskList.get(i).getPriority();
            if (taskPriority <= priority) continue;
            priority = taskPriority;
        }
        return priority;
    }

    @Override
    public boolean getParseFlag(long position) {
        for (int i = 0; i < this.taskList.size(); ++i) {
            if (!this.taskList.get(i).getParseFlag(position)) continue;
            return true;
        }
        return false;
    }
}

