/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.DedexerTask;
import hu.uw.pallergabor.dedexer.DexInstructionParser;
import java.io.IOException;

public class SparseSwitchTask
extends DedexerTask {
    private long tableLength = 0L;
    private long[] jumpTable = null;
    private String[] switchKeys;
    private String[] switchValues;
    private int reg = 0;
    private String defaultLabelName;

    public SparseSwitchTask(DexInstructionParser instrParser, long base, long offset) {
        super(instrParser, base, offset);
    }

    @Override
    public boolean equals(DedexerTask o) {
        if (!(o instanceof SparseSwitchTask)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public void doTask(boolean isSecondPass) throws IOException {
        if (!isSecondPass) {
            if (this.jumpTable == null) {
                this.readJumpTable();
            }
            String sparseLabelPrefix = "sp" + Long.toHexString(this.base) + "_";
            this.instrParser.placeTask(this.base, this);
            this.defaultLabelName = sparseLabelPrefix + "default";
            this.instrParser.placeLabel(this.base + 6L, this.defaultLabelName);
            this.switchValues = new String[this.jumpTable.length];
            for (int i = 0; i < this.jumpTable.length; ++i) {
                long target = this.jumpTable[i];
                String labelName = sparseLabelPrefix + Long.toHexString(target);
                this.instrParser.placeLabel(target, labelName);
                this.switchValues[i] = labelName;
            }
            this.instrParser.placeTask(this.offset, this);
        }
    }

    @Override
    public void renderTask(long position) throws IOException {
        if (position == this.base) {
            this.instrParser.getCodeGenerator().renderSparseSwitch(this.reg, this.defaultLabelName, this.switchKeys, this.switchValues);
        } else if (position == this.offset) {
            long endTablePosition = this.instrParser.getFilePosition() + this.tableLength;
            this.instrParser.setFilePosition(endTablePosition);
        }
    }

    public void setReg(int reg) {
        this.reg = reg;
    }

    public long[] readJumpTable() throws IOException {
        int i;
        long origPos = this.instrParser.getFilePosition();
        this.instrParser.setFilePosition(this.offset);
        long tableBasePos = this.instrParser.getFilePosition();
        int tableType = this.instrParser.read16Bit();
        if (tableType != 512) {
            throw new IOException("Invalid sparse-switch table type (0x" + Integer.toHexString(tableType) + ") at offset 0x" + Long.toHexString(this.instrParser.getFilePosition() - 2L));
        }
        int tableElements = this.instrParser.read16Bit();
        this.switchKeys = new String[tableElements];
        for (i = 0; i < tableElements; ++i) {
            this.switchKeys[i] = Integer.toString(this.instrParser.readSigned32Bit());
        }
        this.jumpTable = new long[tableElements];
        for (i = 0; i < tableElements; ++i) {
            long targetOffset = this.instrParser.readSigned32Bit();
            this.jumpTable[i] = this.base + targetOffset * 2L;
        }
        this.tableLength = this.instrParser.getFilePosition() - tableBasePos;
        this.instrParser.setFilePosition(origPos);
        return this.jumpTable;
    }

    @Override
    public boolean getParseFlag(long position) {
        return position == this.offset;
    }
}

