/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.CodeGenerator;
import hu.uw.pallergabor.dedexer.DedexerTask;
import hu.uw.pallergabor.dedexer.DexAnnotationParser;
import hu.uw.pallergabor.dedexer.DexClassDefsBlock;
import hu.uw.pallergabor.dedexer.DexDebugInfoParser;
import hu.uw.pallergabor.dedexer.DexEncodedArrayParser;
import hu.uw.pallergabor.dedexer.DexFieldIdsBlock;
import hu.uw.pallergabor.dedexer.DexInstructionParser;
import hu.uw.pallergabor.dedexer.DexMethodHeadParser;
import hu.uw.pallergabor.dedexer.DexMethodIdsBlock;
import hu.uw.pallergabor.dedexer.DexOffsetResolver;
import hu.uw.pallergabor.dedexer.DexSignatureBlock;
import hu.uw.pallergabor.dedexer.DexStringIdsBlock;
import hu.uw.pallergabor.dedexer.DexTryCatchBlockParser;
import hu.uw.pallergabor.dedexer.DexTypeIdsBlock;
import hu.uw.pallergabor.dedexer.LineNumberTask;
import hu.uw.pallergabor.dedexer.RegisterTraces;
import hu.uw.pallergabor.dedexer.StaticArray;
import hu.uw.pallergabor.dedexer.UnknownInstructionException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class JasminStyleCodeGenerator
implements CodeGenerator {
    private DexSignatureBlock dexSignatureBlock = null;
    private DexStringIdsBlock dexStringIdsBlock = null;
    private DexTypeIdsBlock dexTypeIdsBlock = null;
    private DexFieldIdsBlock dexFieldIdsBlock = null;
    private DexMethodIdsBlock dexMethodIdsBlock = null;
    private DexClassDefsBlock dexClassDefsBlock = null;
    private DexOffsetResolver dexOffsetResolver = null;
    private String generatedSourceBaseDir = null;
    private RandomAccessFile file;
    private PrintStream currentOutput;
    private PrintStream dump;
    private boolean regTraceLog = false;
    private boolean regTracing = false;
    private static final boolean DEBUG_EXCP = false;
    private static final boolean DEBUG_REGMAPS = false;
    private static final boolean DEBUG_REGTRACE = false;
    private static final boolean DEBUG_MERGE = false;
    private static final boolean DEBUG_FLOW = false;
    private static final int REVISIT_LIMIT = 100;

    public void generate() throws IOException, UnknownInstructionException {
        Iterator<Integer> classIterator = this.dexClassDefsBlock.getClassIterator();
        while (classIterator.hasNext()) {
            String methodName;
            int i;
            PrintStream ps;
            File targetFile;
            File parent;
            Integer ci = classIterator.next();
            int classidx = ci;
            String className = this.dexClassDefsBlock.getClassNameOnly(classidx);
            System.out.println("Processing " + className);
            if (this.dump != null) {
                this.dump.println("--------------------------------------");
                this.dump.println("Class: " + className);
            }
            if ((parent = (targetFile = new File(this.generatedSourceBaseDir + "/" + className + ".ddx")).getParentFile()) != null) {
                parent.mkdirs();
            }
            this.currentOutput = ps = new PrintStream(targetFile);
            if (this.dexClassDefsBlock.isInterface(classidx)) {
                ps.println(".interface " + this.dexClassDefsBlock.getClassName(classidx));
            } else {
                ps.println(".class " + this.dexClassDefsBlock.getClassName(classidx));
            }
            String superClass = this.dexClassDefsBlock.getSuperClass(classidx);
            if (superClass != null) {
                ps.println(".super " + this.dexClassDefsBlock.getSuperClass(classidx));
            }
            if (this.dexClassDefsBlock.getSourceName(classidx) != null) {
                ps.println(".source " + this.dexClassDefsBlock.getSourceName(classidx));
            }
            for (i = 0; i < this.dexClassDefsBlock.getInterfacesSize(classidx); ++i) {
                ps.println(".implements " + this.dexClassDefsBlock.getInterface(classidx, i));
            }
            ps.println();
            if (this.dexClassDefsBlock.getDexAnnotationParser(classidx) != null) {
                this.generateClassAnnotations(ps, classidx);
            }
            for (i = 0; i < this.dexClassDefsBlock.getStaticFieldsSize(classidx); ++i) {
                Object initializer = this.dexClassDefsBlock.getStaticFieldInitializer(classidx, i);
                String initializerString = "";
                if (initializer != null) {
                    if (initializer instanceof Integer) {
                        Integer iv = (Integer)initializer;
                        initializerString = " = " + iv.toString() + "\t; 0x" + Integer.toHexString(iv);
                    } else if (initializer instanceof Long) {
                        Long lv = (Long)initializer;
                        initializerString = " = " + lv.toString() + "\t; 0x" + Long.toHexString(lv);
                    } else {
                        initializerString = " = " + initializer.toString();
                    }
                }
                ps.println(".field " + this.dexClassDefsBlock.getStaticField(classidx, i) + initializerString);
                String shortFieldName = this.dexClassDefsBlock.getStaticFieldShortName(classidx, i);
                this.addFieldAnnotation(ps, shortFieldName, classidx, i);
            }
            for (i = 0; i < this.dexClassDefsBlock.getInstanceFieldsSize(classidx); ++i) {
                ps.println(".field " + this.dexClassDefsBlock.getInstanceField(classidx, i));
                String shortFieldName = this.dexClassDefsBlock.getInstanceFieldShortName(classidx, i);
                this.addFieldAnnotation(ps, shortFieldName, classidx, i);
            }
            ps.println();
            for (i = 0; i < this.dexClassDefsBlock.getDirectMethodsFieldsSize(classidx); ++i) {
                methodName = this.dexClassDefsBlock.getDirectMethodName(classidx, i);
                ps.println(".method " + methodName);
                this.dumpMethodName(methodName);
                this.addMethodAnnotation(ps, this.dexClassDefsBlock.getDirectMethodShortName(classidx, i), classidx, i);
                if ((this.dexClassDefsBlock.getDirectMethodAccess(classidx, i) & 0x500) == 0) {
                    this.generateMethodBody(methodName, this.dexClassDefsBlock.getDirectMethodOffset(classidx, i), ps, classidx, i, true);
                }
                ps.println(".end method");
                ps.println();
            }
            for (i = 0; i < this.dexClassDefsBlock.getVirtualMethodsFieldsSize(classidx); ++i) {
                methodName = this.dexClassDefsBlock.getVirtualMethodName(classidx, i);
                ps.println(".method " + methodName);
                this.addMethodAnnotation(ps, this.dexClassDefsBlock.getVirtualMethodShortName(classidx, i), classidx, i);
                this.dumpMethodName(methodName);
                int access = this.dexClassDefsBlock.getVirtualMethodAccess(classidx, i);
                if ((access & 0x500) == 0) {
                    this.generateMethodBody(methodName, this.dexClassDefsBlock.getVirtualMethodOffset(classidx, i), ps, classidx, i, false);
                }
                ps.println(".end method");
                ps.println();
            }
            ps.println();
            this.currentOutput = null;
            ps.close();
        }
    }

    public void setDexSignatureBlock(DexSignatureBlock dexSignatureBlock) {
        this.dexSignatureBlock = dexSignatureBlock;
    }

    public void setDexStringIdsBlock(DexStringIdsBlock dexStringIdsBlock) {
        this.dexStringIdsBlock = dexStringIdsBlock;
    }

    public void setDexTypeIdsBlock(DexTypeIdsBlock dexTypeIdsBlock) {
        this.dexTypeIdsBlock = dexTypeIdsBlock;
    }

    public void setDexFieldIdsBlock(DexFieldIdsBlock dexFieldIdsBlock) {
        this.dexFieldIdsBlock = dexFieldIdsBlock;
    }

    public void setDexMethodIdsBlock(DexMethodIdsBlock dexMethodIdsBlock) {
        this.dexMethodIdsBlock = dexMethodIdsBlock;
    }

    public void setDexClassDefsBlock(DexClassDefsBlock dexClassDefsBlock) {
        this.dexClassDefsBlock = dexClassDefsBlock;
    }

    public void setDexOffsetResolver(DexOffsetResolver dexOffsetResolver) {
        this.dexOffsetResolver = dexOffsetResolver;
    }

    public void setGeneratedSourceBaseDir(String generatedSourceBaseDir) {
        this.generatedSourceBaseDir = generatedSourceBaseDir;
    }

    public void setRandomAccessFile(RandomAccessFile file) {
        this.file = file;
    }

    public void setDumpFile(PrintStream dump) {
        this.dump = dump;
    }

    public void setRegTracing(boolean regTracing) {
        this.regTracing = regTracing;
    }

    public void setRegTraceLog(boolean regTraceLog) {
        this.regTraceLog = regTraceLog;
    }

    @Override
    public void renderLabel(String label) throws IOException {
        this.currentOutput.println(label + ":");
    }

    @Override
    public void renderLineNumber(int lineNumber) throws IOException {
        this.currentOutput.println(".line " + Integer.toString(lineNumber));
    }

    @Override
    public void renderPackedSwitch(int reg, int low, String defaultLabelName, ArrayList<String> labels) throws IOException {
        this.currentOutput.println("\tpacked-switch\tv" + reg + "," + low);
        int labelCtr = low;
        int i = 0;
        while (i < labels.size()) {
            this.currentOutput.println("\t\t" + labels.get(i) + "\t; case " + labelCtr);
            ++i;
            ++labelCtr;
        }
        this.currentOutput.println("\t\tdefault: " + defaultLabelName);
    }

    @Override
    public void renderSparseSwitch(int reg, String defaultLabelName, String[] switchKeys, String[] switchValues) throws IOException {
        this.currentOutput.println("\tsparse-switch\tv" + reg);
        for (int i = 0; i < switchKeys.length; ++i) {
            this.currentOutput.println("\t\t" + switchKeys[i] + " : " + switchValues[i]);
        }
        this.currentOutput.println("\t\tdefault: " + defaultLabelName);
    }

    @Override
    public void openDataArray(String label) throws IOException {
        this.currentOutput.println(label + ":\tdata-array");
    }

    @Override
    public void writeElement(long elementIdx, String element) throws IOException {
        this.currentOutput.println("\t\t" + element + "\t; #" + elementIdx);
    }

    public void writeByteArray(String element) throws IOException {
        this.currentOutput.println("\t\t" + element);
    }

    @Override
    public void closeDataArray(String label) throws IOException {
        this.currentOutput.println("\tend data-array");
    }

    @Override
    public void writeTryCatchBlock(String startLabel, String endLabel, String exception, String handlerLabel) throws IOException {
        this.currentOutput.println(".catch " + exception + " from " + startLabel + " to " + endLabel + " using " + handlerLabel);
    }

    @Override
    public void writeLocalVariable(int regNum, String variableName, String variableType, String startOffsetLabel, String endOffsetLabel) {
        this.currentOutput.println(".var " + regNum + " is " + variableName + " " + variableType + " from " + startOffsetLabel + " to " + endOffsetLabel);
    }

    @Override
    public void writeClassAnnotation(int classIdx, int visibility, String type, ArrayList<String> parmNames, ArrayList<Object> parmValues) {
        this.currentOutput.println(".annotation " + this.getVisibility(visibility) + " " + type);
        for (int i = 0; i < parmNames.size(); ++i) {
            Object o = parmValues.get(i);
            this.currentOutput.println("  " + parmNames.get(i) + " " + DexEncodedArrayParser.getTypeString(o) + " = " + o.toString());
        }
        this.currentOutput.println(".end annotation");
        this.currentOutput.println();
    }

    private void generateMethodBody(String methodName, long pos, PrintStream ps, int classidx, int methodidx, boolean direct) throws IOException, UnknownInstructionException {
        DexMethodHeadParser dexMethodHeadParser = new DexMethodHeadParser();
        dexMethodHeadParser.setRandomAccessFile(this.file);
        dexMethodHeadParser.setDexSignatureBlock(this.dexSignatureBlock);
        dexMethodHeadParser.setDumpFile(this.dump);
        dexMethodHeadParser.parse(pos);
        int regSize = dexMethodHeadParser.getRegistersSize();
        ps.println(".limit registers " + regSize);
        ArrayList parmRegs = direct ? this.dexClassDefsBlock.getDirectMethodParameterOffsets(classidx, methodidx, regSize) : this.dexClassDefsBlock.getVirtualMethodParameterOffsets(classidx, methodidx, regSize);
        int accessFlags = direct ? this.dexClassDefsBlock.getDirectMethodAccess(classidx, methodidx) : this.dexClassDefsBlock.getVirtualMethodAccess(classidx, methodidx);
        HashMap<Integer, String> initRegMap = new HashMap<Integer, String>();
        if ((accessFlags & 8) == 0) {
            int thisReg = 0;
            thisReg = parmRegs.size() < 2 ? regSize - 1 : (Integer)parmRegs.get(0) - 1;
            String type = "L" + this.dexClassDefsBlock.getClassNameOnly(classidx) + ";";
            ps.println("; this: v" + thisReg + " (" + type + ")");
            initRegMap.put(new Integer(thisReg), type);
        }
        int parmctr = 0;
        int i = 0;
        while (i < parmRegs.size()) {
            ps.println("; parameter[" + parmctr + "] : v" + (Integer)parmRegs.get(i) + " (" + (String)parmRegs.get(i + 1) + ")");
            initRegMap.put((Integer)parmRegs.get(i), DexInstructionParser.convertJavaTypeToInternal((String)parmRegs.get(i + 1)));
            i += 2;
            ++parmctr;
        }
        long startPos = dexMethodHeadParser.getInstructionBase();
        long endPos = dexMethodHeadParser.getInstructionEnd();
        DexInstructionParser instructionParser = new DexInstructionParser();
        instructionParser.setDexSignatureBlock(this.dexSignatureBlock);
        instructionParser.setDexStringIdsBlock(this.dexStringIdsBlock);
        instructionParser.setDexTypeIdsBlock(this.dexTypeIdsBlock);
        instructionParser.setDexFieldIdsBlock(this.dexFieldIdsBlock);
        instructionParser.setDexMethodIdsBlock(this.dexMethodIdsBlock);
        instructionParser.setDexOffsetResolver(this.dexOffsetResolver);
        instructionParser.setCodeGenerator(this);
        instructionParser.setDumpFile(this.dump);
        instructionParser.setRandomAccessFile(this.file);
        instructionParser.setDumpOff();
        BitSet visitSet = new BitSet((int)(endPos - startPos));
        Stack<VisitStackEntry> visitStack = new Stack<VisitStackEntry>();
        HashMap<Long, String> regTraceMap = null;
        ArrayList<ExceptionHandlerMapEntry> exceptionHandlerEntryPointList = null;
        ArrayList<RegisterTraces> regTraces = null;
        HashMap<Long, HashMap> registerMaps = null;
        HashMap<Long, Integer> overrunCounter = null;
        if (this.regTraceLog) {
            regTraceMap = new HashMap<Long, String>();
        }
        if (this.regTracing) {
            exceptionHandlerEntryPointList = new ArrayList<ExceptionHandlerMapEntry>();
            regTraces = new ArrayList<RegisterTraces>();
            registerMaps = new HashMap<Long, HashMap>();
            overrunCounter = new HashMap<Long, Integer>();
        }
        if (dexMethodHeadParser.getTriesSize() != 0) {
            this.processTryCatchBlock(methodName, instructionParser, dexMethodHeadParser, visitStack, initRegMap, exceptionHandlerEntryPointList);
        }
        DexDebugInfoParser debugInfoParser = null;
        if (dexMethodHeadParser.getDebugOffset() != 0L) {
            debugInfoParser = this.parseDebugInfoBlock(instructionParser, dexMethodHeadParser);
            if (regTraces != null) {
                this.initializeRegTrace(regTraces, debugInfoParser, dexMethodHeadParser);
                instructionParser.setRegTraces(regTraces);
            }
        }
        instructionParser.setFilePosition(dexMethodHeadParser.getInstructionBase());
        instructionParser.setPass(false);
        instructionParser.setRegisterMap((HashMap)initRegMap.clone());
        while (true) {
            long filePos = instructionParser.getFilePosition();
            while (filePos < endPos) {
                int i2;
                filePos = instructionParser.getFilePosition();
                int basePos = (int)(filePos - startPos);
                boolean haveBeenHere = visitSet.get(basePos);
                if (haveBeenHere) {
                    if (registerMaps == null) break;
                    Long posObj = new Long(filePos);
                    HashMap savedRegMap = (HashMap)registerMaps.get(posObj);
                    HashMap<Integer, String> currentRegMap = instructionParser.getRegisterMap();
                    if (registerMaps.containsKey(posObj) && savedRegMap == null) {
                        registerMaps.put(posObj, (HashMap)currentRegMap.clone());
                    } else if (savedRegMap != null) {
                        if (!this.overrunCheck(posObj, overrunCounter) || !this.mergeCheckRegTraceMaps(currentRegMap, savedRegMap)) break;
                        registerMaps.put(posObj, (HashMap)currentRegMap.clone());
                    }
                }
                if (exceptionHandlerEntryPointList != null) {
                    this.handleRegMaps(methodName, exceptionHandlerEntryPointList, instructionParser);
                }
                instructionParser.parse();
                if (regTraceMap != null && instructionParser.getAffectedRegisters() != null) {
                    this.saveRegTraceMap(instructionParser, regTraceMap);
                }
                int instructionEndPos = (int)(instructionParser.getFilePosition() - startPos);
                visitSet.set(basePos, instructionEndPos);
                DexInstructionParser.ForkStatus forkStatus = instructionParser.getForkStatus();
                if (forkStatus == DexInstructionParser.ForkStatus.TERMINATE) break;
                if (forkStatus != DexInstructionParser.ForkStatus.FORK_UNCONDITIONALLY && forkStatus != DexInstructionParser.ForkStatus.FORK_AND_CONTINUE) continue;
                int baseIndex = forkStatus == DexInstructionParser.ForkStatus.FORK_UNCONDITIONALLY ? 1 : 0;
                long[] forkData = instructionParser.getForkData();
                if (registerMaps != null) {
                    for (i2 = 0; i2 < forkData.length; ++i2) {
                        Long targetObj = new Long(forkData[i2]);
                        if (registerMaps.containsKey(targetObj)) continue;
                        registerMaps.put(targetObj, null);
                    }
                }
                for (i2 = baseIndex; i2 < forkData.length; ++i2) {
                    long target = forkData[i2];
                    if (target < startPos || target > endPos) continue;
                    HashMap<Integer, String> currentRegMap = instructionParser.getRegisterMap();
                    HashMap clonedCurrentRegMap = (HashMap)currentRegMap.clone();
                    visitStack.push(new VisitStackEntry(target, clonedCurrentRegMap));
                }
                if (forkStatus != DexInstructionParser.ForkStatus.FORK_UNCONDITIONALLY) continue;
                instructionParser.setFilePosition(forkData[0]);
            }
            if (visitStack.empty()) break;
            VisitStackEntry entry = visitStack.pop();
            long target = entry.getLocation();
            Long targetObj = new Long(target);
            instructionParser.setRegisterMap(entry.getRegMap());
            instructionParser.setFilePosition(target);
        }
        instructionParser.postPassProcessing(false);
        if (debugInfoParser != null) {
            this.processDebugInfoBlock(debugInfoParser, instructionParser, dexMethodHeadParser);
        }
        instructionParser.setFilePosition(dexMethodHeadParser.getInstructionBase());
        instructionParser.setDumpFile(ps);
        instructionParser.setPass(true);
        long actualPosition = 0L;
        while ((actualPosition = instructionParser.getFilePosition()) < endPos) {
            DedexerTask task = instructionParser.getTaskForAddress(actualPosition);
            boolean parseFlag = false;
            if (task != null) {
                try {
                    task.renderTask(actualPosition);
                    parseFlag = task.getParseFlag(actualPosition);
                }
                catch (IOException ex) {
                    System.out.println("*** ERROR ***: " + ex.getMessage());
                }
            }
            if (parseFlag) continue;
            int visitOffset = (int)(actualPosition - startPos);
            if (visitSet.get(visitOffset)) {
                long tracePos;
                String s;
                instructionParser.parse();
                if (!this.regTraceLog || (s = regTraceMap.get(new Long(tracePos = instructionParser.getFilePosition()))) == null) continue;
                ps.println("; " + s);
                continue;
            }
            String label = DexInstructionParser.labelForAddress(instructionParser.getFilePosition());
            this.openDataArray(label);
            StringBuilder element = new StringBuilder();
            boolean firstByte = true;
            while (!((actualPosition = instructionParser.getFilePosition()) >= endPos || visitSet.get(visitOffset++) || (task = instructionParser.getTaskForAddress(actualPosition)) != null && task.getParseFlag(actualPosition))) {
                if (!firstByte) {
                    element.append(", ");
                } else {
                    firstByte = false;
                }
                int b = instructionParser.read8Bit();
                element.append("0x");
                element.append(instructionParser.dumpByte(b));
            }
            this.writeByteArray(new String(element));
            this.closeDataArray(label);
        }
        instructionParser.postPassProcessing(true);
    }

    private void generateClassAnnotations(PrintStream ps, int classIdx) {
        DexAnnotationParser dap = this.dexClassDefsBlock.getDexAnnotationParser(classIdx);
        for (int i = 0; i < dap.getAnnotationBlocksSize(DexAnnotationParser.AnnotationType.CLASS); ++i) {
            for (int n = 0; n < dap.getAnnotationsSize(DexAnnotationParser.AnnotationType.CLASS, i); ++n) {
                int visibility = dap.getAnnotationVisibilityFlag(DexAnnotationParser.AnnotationType.CLASS, i, n);
                String type = dap.getAnnotationType(DexAnnotationParser.AnnotationType.CLASS, i, n);
                if ("Ldalvik/annotation/MemberClasses;".equals(type)) {
                    this.printMemberClassesAnnotation(ps, classIdx, dap, i, n);
                } else if ("Ldalvik/annotation/EnclosingClass;".equals(type)) {
                    this.printEnclosingClassesAnnotation(ps, classIdx, dap, i, n);
                } else if ("Ldalvik/annotation/EnclosingMethod;".equals(type)) {
                    this.printEnclosingMethodAnnotation(ps, classIdx, dap, i, n);
                }
                if (DexAnnotationParser.isSystemAnnotation(type)) continue;
                ArrayList<String> parmNames = new ArrayList<String>();
                ArrayList<Object> parmValues = new ArrayList<Object>();
                for (int k = 0; k < dap.getAnnotationElementsSize(DexAnnotationParser.AnnotationType.CLASS, i, n); ++k) {
                    parmNames.add(dap.getAnnotationElementName(DexAnnotationParser.AnnotationType.CLASS, i, n, k));
                    parmValues.add(dap.getAnnotationElementValue(DexAnnotationParser.AnnotationType.CLASS, i, n, k));
                    this.writeClassAnnotation(classIdx, visibility, type, parmNames, parmValues);
                }
            }
        }
    }

    private void processTryCatchBlock(String methodName, DexInstructionParser instructionParser, DexMethodHeadParser dexMethodHeadParser, Stack<VisitStackEntry> visitStack, HashMap<Integer, String> initRegMap, ArrayList<ExceptionHandlerMapEntry> exceptionHandlerList) throws IOException {
        DexTryCatchBlockParser dtcb = new DexTryCatchBlockParser();
        dtcb.setDexMethodHeadParser(dexMethodHeadParser);
        dtcb.setDexTypeIdsBlock(this.dexTypeIdsBlock);
        dtcb.setDumpFile(this.dump);
        dtcb.setRandomAccessFile(this.file);
        dtcb.parse();
        for (int i = dtcb.getTriesSize() - 1; i >= 0; --i) {
            long start = dtcb.getTryStartOffset(i);
            long end = dtcb.getTryEndOffset(i);
            String startLabel = DexInstructionParser.labelForAddress(start);
            String endLabel = DexInstructionParser.labelForAddress(end);
            instructionParser.placeLabel(start, startLabel);
            instructionParser.placeLabel(end, endLabel);
            for (int n = 0; n < dtcb.getTryHandlersSize(i); ++n) {
                String excpType = dtcb.getTryHandlerType(i, n);
                long handlerOffset = dtcb.getTryHandlerOffset(i, n);
                HashMap clonedInitRegMap = (HashMap)initRegMap.clone();
                visitStack.push(new VisitStackEntry(handlerOffset, clonedInitRegMap));
                String handlerOffsetName = DexInstructionParser.labelForAddress(handlerOffset);
                if (exceptionHandlerList != null) {
                    clonedInitRegMap = (HashMap)initRegMap.clone();
                    this.saveExceptionHandlerMapMarker(methodName, exceptionHandlerList, start, end, handlerOffset, excpType, clonedInitRegMap);
                }
                instructionParser.placeLabel(handlerOffset, handlerOffsetName);
                instructionParser.getCodeGenerator().writeTryCatchBlock(startLabel, endLabel, excpType, handlerOffsetName);
            }
        }
    }

    private void saveExceptionHandlerMapMarker(String methodName, ArrayList<ExceptionHandlerMapEntry> exceptionHandlerList, long start, long end, long handlerOffset, String exceptionType, HashMap<Integer, String> regMap) {
        ExceptionHandlerMapEntry entry = new ExceptionHandlerMapEntry(start, end, handlerOffset, exceptionType, regMap);
        exceptionHandlerList.add(entry);
    }

    private void handleRegMaps(String methodName, ArrayList<ExceptionHandlerMapEntry> exceptionHandlerEntryPointList, DexInstructionParser instructionParser) throws IOException {
        long pos = instructionParser.getFilePosition();
        for (int i = 0; i < exceptionHandlerEntryPointList.size(); ++i) {
            ExceptionHandlerMapEntry entry = exceptionHandlerEntryPointList.get(i);
            if (entry.withinRange(pos)) {
                HashMap<Integer, String> regMap = instructionParser.getRegisterMap();
                this.mergeExcpRegMaps(entry.getRegMap(), regMap);
            }
            if (!entry.atHandler(pos)) continue;
            HashMap excpRegMap = entry.getRegMap();
            excpRegMap = (HashMap)excpRegMap.clone();
            excpRegMap.put(DexInstructionParser.REGMAP_RESULT_KEY, entry.getExceptionType());
            instructionParser.setRegisterMap(excpRegMap);
        }
    }

    private DexDebugInfoParser parseDebugInfoBlock(DexInstructionParser instructionParser, DexMethodHeadParser dexMethodHeadParser) throws IOException {
        DexDebugInfoParser ddp = new DexDebugInfoParser();
        ddp.setDexStringIdsBlock(this.dexStringIdsBlock);
        ddp.setDexTypeIdsBlock(this.dexTypeIdsBlock);
        ddp.setDumpFile(this.dump);
        ddp.setRandomAccessFile(this.file);
        ddp.setFilePosition(dexMethodHeadParser.getDebugOffset());
        ddp.parse();
        return ddp;
    }

    private void processDebugInfoBlock(DexDebugInfoParser ddp, DexInstructionParser instructionParser, DexMethodHeadParser dexMethodHeadParser) {
        int i;
        for (i = 0; i < ddp.getLineNumbers(); ++i) {
            int lineNumber = ddp.getLineNumber(i);
            int address = ddp.getLineNumberAddress(i);
            int fileOffset = (int)dexMethodHeadParser.getInstructionBase() + address * 2;
            instructionParser.placeTask(fileOffset, new LineNumberTask(instructionParser, lineNumber));
        }
        for (i = 0; i < ddp.getLocalVariables(); ++i) {
            int regNum = ddp.getLocalVariableRegNum(i);
            String variableName = ddp.getLocalVariableName(i);
            String variableType = ddp.getLocalVariableType(i);
            int startOffset = ddp.getLocalVariableStartOffset(i);
            int endOffset = ddp.getLocalVariableEndOffset(i);
            if (regNum < 0) continue;
            startOffset = startOffset * 2 + (int)dexMethodHeadParser.getInstructionBase();
            endOffset = endOffset * 2 + (int)dexMethodHeadParser.getInstructionBase();
            String startOffsetLabel = DexInstructionParser.labelForAddress(startOffset);
            String endOffsetLabel = DexInstructionParser.labelForAddress(endOffset);
            instructionParser.placeLabel(startOffset, startOffsetLabel);
            instructionParser.placeLabel(endOffset, endOffsetLabel);
            this.writeLocalVariable(regNum, variableName, variableType, startOffsetLabel, endOffsetLabel);
        }
    }

    private void initializeRegTrace(ArrayList<RegisterTraces> regTraces, DexDebugInfoParser debugInfoParser, DexMethodHeadParser dexMethodHeadParser) {
        for (int i = 0; i < debugInfoParser.getLocalVariables(); ++i) {
            int regNum = debugInfoParser.getLocalVariableRegNum(i);
            String variableType = debugInfoParser.getLocalVariableType(i);
            int startOffset = debugInfoParser.getLocalVariableStartOffset(i);
            int endOffset = debugInfoParser.getLocalVariableEndOffset(i);
            if (regNum < 0) continue;
            startOffset = startOffset * 2 + (int)dexMethodHeadParser.getInstructionBase();
            endOffset = endOffset * 2 + (int)dexMethodHeadParser.getInstructionBase();
            RegisterTraces t = new RegisterTraces(startOffset, endOffset, variableType, regNum);
            regTraces.add(t);
        }
    }

    private void dumpMethodName(String methodName) throws IOException {
        if (this.dump != null) {
            this.dump.println("****************************");
            this.dump.println("Method: " + methodName);
        }
    }

    private String getVisibility(int visibility) {
        String returnValue = "";
        switch (visibility) {
            case 0: {
                returnValue = "buildVisibility";
                break;
            }
            case 1: {
                returnValue = "runtimeVisibility";
                break;
            }
            case 2: {
                returnValue = "systemVisibility";
            }
        }
        return returnValue;
    }

    private void addFieldAnnotation(PrintStream ps, String fieldShortName, int classidx, int i) {
        int annotationIdx;
        DexAnnotationParser dap = this.dexClassDefsBlock.getDexAnnotationParser(classidx);
        if (dap != null && (annotationIdx = dap.getBlockIndexFromAsset(DexAnnotationParser.AnnotationType.FIELD, fieldShortName)) >= 0) {
            for (int n = 0; n < dap.getAnnotationsSize(DexAnnotationParser.AnnotationType.FIELD, annotationIdx); ++n) {
                int visibility = dap.getAnnotationVisibilityFlag(DexAnnotationParser.AnnotationType.FIELD, annotationIdx, n);
                String type = dap.getAnnotationType(DexAnnotationParser.AnnotationType.FIELD, annotationIdx, n);
                ps.println("  .annotation " + this.getVisibility(visibility) + " " + type);
                for (int k = 0; k < dap.getAnnotationElementsSize(DexAnnotationParser.AnnotationType.FIELD, annotationIdx, n); ++k) {
                    String parmName = dap.getAnnotationElementName(DexAnnotationParser.AnnotationType.FIELD, annotationIdx, n, k);
                    Object o = dap.getAnnotationElementValue(DexAnnotationParser.AnnotationType.FIELD, annotationIdx, n, k);
                    ps.println("    " + parmName + " " + DexEncodedArrayParser.getTypeString(o) + " = " + o.toString());
                }
                ps.println("  .end annotation");
            }
            ps.println(".end field");
        }
    }

    private void addMethodAnnotation(PrintStream ps, String methodShortName, int classidx, int i) {
        int annotationIdx;
        DexAnnotationParser dap = this.dexClassDefsBlock.getDexAnnotationParser(classidx);
        if (dap != null && (annotationIdx = dap.getBlockIndexFromAsset(DexAnnotationParser.AnnotationType.METHOD, methodShortName)) >= 0) {
            String type;
            int visibility;
            int n;
            int throwsIdx = dap.searchAnnotationType(DexAnnotationParser.AnnotationType.METHOD, annotationIdx, "Ldalvik/annotation/Throws;");
            if (throwsIdx >= 0) {
                this.printThrows(ps, dap, annotationIdx, throwsIdx);
            }
            for (n = 0; n < dap.getAnnotationsSize(DexAnnotationParser.AnnotationType.METHOD, annotationIdx); ++n) {
                visibility = dap.getAnnotationVisibilityFlag(DexAnnotationParser.AnnotationType.METHOD, annotationIdx, n);
                type = dap.getAnnotationType(DexAnnotationParser.AnnotationType.METHOD, annotationIdx, n);
                if (DexAnnotationParser.isSystemAnnotation(type)) continue;
                ps.println(".annotation " + this.getVisibility(visibility) + " " + type);
                this.printElements(ps, dap, DexAnnotationParser.AnnotationType.METHOD, annotationIdx, n);
                ps.println(".end annotation");
            }
            for (n = 0; n < dap.getAnnotationsSize(DexAnnotationParser.AnnotationType.PARAMETER, annotationIdx); ++n) {
                visibility = dap.getAnnotationVisibilityFlag(DexAnnotationParser.AnnotationType.PARAMETER, annotationIdx, n);
                type = dap.getAnnotationType(DexAnnotationParser.AnnotationType.PARAMETER, annotationIdx, n);
                int paramNumber = dap.getAnnotationParameterIndex(DexAnnotationParser.AnnotationType.PARAMETER, annotationIdx, n) + 1;
                ps.println(".annotation " + this.getVisibility(visibility) + " param " + paramNumber + " " + type);
                this.printElements(ps, dap, DexAnnotationParser.AnnotationType.PARAMETER, annotationIdx, n);
                ps.println(".end annotation");
            }
        }
    }

    private void printElements(PrintStream ps, DexAnnotationParser dap, DexAnnotationParser.AnnotationType type, int annotationIdx, int n) {
        for (int k = 0; k < dap.getAnnotationElementsSize(type, annotationIdx, n); ++k) {
            String parmName = dap.getAnnotationElementName(type, annotationIdx, n, k);
            Object o = dap.getAnnotationElementValue(type, annotationIdx, n, k);
            ps.println("    " + parmName + " " + DexEncodedArrayParser.getTypeString(o) + " = " + o.toString());
        }
    }

    private void printThrows(PrintStream ps, DexAnnotationParser dap, int annotationIdx, int throwsIdx) {
        int elementsSize = dap.getAnnotationElementsSize(DexAnnotationParser.AnnotationType.METHOD, annotationIdx, throwsIdx);
        for (int i = 0; i < elementsSize; ++i) {
            Object o;
            String elementName = dap.getAnnotationElementName(DexAnnotationParser.AnnotationType.METHOD, annotationIdx, throwsIdx, i);
            if (!"value".equals(elementName) || !((o = dap.getAnnotationElementValue(DexAnnotationParser.AnnotationType.METHOD, annotationIdx, throwsIdx, i)) instanceof StaticArray)) continue;
            StaticArray array = (StaticArray)o;
            for (int n = 0; n < array.length(); ++n) {
                ps.println(".throws " + array.get(n));
            }
        }
    }

    private void printMemberClassesAnnotation(PrintStream ps, int classIdx, DexAnnotationParser dap, int i, int n) {
        int elementsSize = dap.getAnnotationElementsSize(DexAnnotationParser.AnnotationType.CLASS, i, n);
        for (int k = 0; k < elementsSize; ++k) {
            Object o;
            String elementName = dap.getAnnotationElementName(DexAnnotationParser.AnnotationType.CLASS, i, n, k);
            if (!"value".equals(elementName) || !((o = dap.getAnnotationElementValue(DexAnnotationParser.AnnotationType.CLASS, i, n, k)) instanceof StaticArray)) continue;
            String outerName = this.dexClassDefsBlock.getClassNameOnly(classIdx);
            StaticArray array = (StaticArray)o;
            for (int l = 0; l < array.length(); ++l) {
                String memberClassName = (String)array.get(l);
                String classNameOnly = DexClassDefsBlock.getClassNameWithoutPackage(memberClassName);
                String memberClassNameWithoutPrePostfix = DexClassDefsBlock.getClassNameWithoutPrePostfix(memberClassName);
                ps.println(".inner class " + classNameOnly + " inner " + memberClassNameWithoutPrePostfix + " outer " + outerName);
            }
        }
    }

    private void printEnclosingClassesAnnotation(PrintStream ps, int classIdx, DexAnnotationParser dap, int i, int n) {
        int elementsSize = dap.getAnnotationElementsSize(DexAnnotationParser.AnnotationType.CLASS, i, n);
        for (int k = 0; k < elementsSize; ++k) {
            Object o;
            String elementName = dap.getAnnotationElementName(DexAnnotationParser.AnnotationType.CLASS, i, n, k);
            if (!"value".equals(elementName) || !((o = dap.getAnnotationElementValue(DexAnnotationParser.AnnotationType.CLASS, i, n, k)) instanceof String)) continue;
            String innerClassFullName = this.dexClassDefsBlock.getClassNameOnly(classIdx);
            String outerClassFullName = (String)o;
            String innerClassNameWithoutPrePostfix = DexClassDefsBlock.getClassNameWithoutPrePostfix(innerClassFullName);
            String innerClassShortName = DexClassDefsBlock.getClassNameWithoutPackage(innerClassFullName);
            String outerClassNameWithoutPrePostfix = DexClassDefsBlock.getClassNameWithoutPrePostfix(outerClassFullName);
            ps.println(".inner class " + innerClassShortName + " inner " + innerClassNameWithoutPrePostfix + " outer " + outerClassNameWithoutPrePostfix);
        }
    }

    private void printEnclosingMethodAnnotation(PrintStream ps, int classIdx, DexAnnotationParser dap, int i, int n) {
        int elementsSize = dap.getAnnotationElementsSize(DexAnnotationParser.AnnotationType.CLASS, i, n);
        for (int k = 0; k < elementsSize; ++k) {
            Object o;
            String elementName = dap.getAnnotationElementName(DexAnnotationParser.AnnotationType.CLASS, i, n, k);
            if (!"value".equals(elementName) || !((o = dap.getAnnotationElementValue(DexAnnotationParser.AnnotationType.CLASS, i, n, k)) instanceof String)) continue;
            String methodName = (String)o;
            ps.println(".enclosing method " + methodName);
        }
    }

    private void saveRegTraceMap(DexInstructionParser instructionParser, HashMap<Long, String> regTraceMap) throws IOException {
        StringBuilder sb = new StringBuilder();
        int[] affectedRegisters = instructionParser.getAffectedRegisters();
        for (int i = 0; i < affectedRegisters.length; ++i) {
            if (i > 0) {
                sb.append(" , ");
            }
            int reg = affectedRegisters[i];
            sb.append("v" + reg + " : ");
            HashMap<Integer, String> regMap = instructionParser.getRegisterMap();
            sb.append(regMap.get(new Integer(reg)));
        }
        long pos = instructionParser.getFilePosition();
        String line = new String(sb);
        regTraceMap.put(new Long(pos), line);
    }

    private StringBuilder dumpRegMap(HashMap<Integer, String> regMap) {
        StringBuilder b = new StringBuilder();
        for (Integer i : regMap.keySet()) {
            String value = regMap.get(i);
            b.append(" v" + i + " : " + value);
        }
        return b;
    }

    private boolean mergeCheckRegTraceMaps(HashMap<Integer, String> newRegTraceMap, HashMap<Integer, String> oldRegTraceMap) {
        boolean revisit = false;
        for (Integer key : oldRegTraceMap.keySet()) {
            String oldValue = oldRegTraceMap.get(key);
            String newValue = newRegTraceMap.get(key);
            if (newValue == null) {
                newRegTraceMap.put(key, oldValue);
                continue;
            }
            if (oldValue == null || newValue.equals(oldValue)) continue;
            if ("single-length".equals(oldValue) && this.isClass(newValue)) {
                revisit = true;
                continue;
            }
            if (this.isClass(newValue) && this.isClass(oldValue)) {
                if (this.dexOffsetResolver != null) {
                    String ancestor = this.dexOffsetResolver.findCommonAncestor(newValue, oldValue);
                    ancestor = "L" + ancestor + ";";
                    if (newValue.equals(ancestor) || oldValue.equals(ancestor)) continue;
                    newRegTraceMap.put(key, ancestor);
                    revisit = true;
                    continue;
                }
                if (newValue.equals(oldValue) || oldValue.equals("Ljava/lang/Object;")) continue;
                newRegTraceMap.put(key, "Ljava/lang/Object;");
                revisit = true;
                continue;
            }
            if (newValue.equals(oldValue)) continue;
            revisit = false;
            break;
        }
        return revisit;
    }

    private void mergeExcpRegMaps(HashMap<Integer, String> exceptionMap, HashMap<Integer, String> currentMap) {
        for (Integer key : currentMap.keySet()) {
            String excpValue = exceptionMap.get(key);
            String currentValue = currentMap.get(key);
            if (excpValue == null) {
                exceptionMap.put(key, currentValue);
                continue;
            }
            if (currentValue == null || !"single-length".equals(excpValue) || !currentValue.startsWith("[") && !currentValue.startsWith("L")) continue;
            exceptionMap.put(key, currentValue);
        }
    }

    private boolean isClass(String className) {
        return className.startsWith("[") || className.startsWith("L");
    }

    private boolean overrunCheck(Long posObj, HashMap<Long, Integer> overrunCounter) {
        if (overrunCounter == null) {
            return true;
        }
        Integer ctr = overrunCounter.get(posObj);
        if (ctr == null) {
            ctr = new Integer(1);
            overrunCounter.put(posObj, ctr);
            return true;
        }
        int ctrv = ctr + 1;
        if (ctrv > 100) {
            return false;
        }
        overrunCounter.put(posObj, new Integer(ctrv));
        return true;
    }

    class ExceptionHandlerMapEntry {
        private long start;
        private long end;
        private long handler;
        private String exceptionType;
        private HashMap<Integer, String> regMap;

        public ExceptionHandlerMapEntry(long start, long end, long handler, String exceptionType, HashMap<Integer, String> regMap) {
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.exceptionType = exceptionType;
            this.regMap = regMap;
        }

        public boolean withinRange(long pos) {
            return pos >= this.start && pos < this.end;
        }

        public boolean atHandler(long pos) {
            return pos == this.handler;
        }

        public HashMap<Integer, String> getRegMap() {
            return this.regMap;
        }

        public String getExceptionType() {
            return this.exceptionType;
        }

        public long getHandler() {
            return this.handler;
        }

        public String toString() {
            return "ExceptionHandlerMapEntry: start: 0x" + Long.toHexString(this.start) + "; end: 0x" + Long.toHexString(this.end) + "; handler: " + Long.toHexString(this.handler) + "; exceptionType: " + this.exceptionType;
        }
    }

    class VisitStackEntry {
        private long location;
        private HashMap<Integer, String> regMap;

        public VisitStackEntry(long location, HashMap<Integer, String> regMap) {
            this.location = location;
            this.regMap = regMap == null ? new HashMap() : (HashMap)regMap.clone();
        }

        public long getLocation() {
            return this.location;
        }

        public HashMap<Integer, String> getRegMap() {
            return this.regMap;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("VisitStackEntry: 0x" + Long.toHexString(this.location));
            b.append(" {");
            b.append((CharSequence)JasminStyleCodeGenerator.this.dumpRegMap(this.regMap));
            b.append("}");
            return new String(b);
        }
    }
}

