/*
 * Decompiled with CFR 0.152.
 */
package hu.uw.pallergabor.dedexer;

import hu.uw.pallergabor.dedexer.DexParser;
import hu.uw.pallergabor.dedexer.DexPointerBlock;
import hu.uw.pallergabor.dedexer.DexSignatureBlock;
import java.io.IOException;

public class DexStringIdsBlock
extends DexParser {
    private String[] strings = null;
    private DexPointerBlock dexPointerBlock = null;
    private DexSignatureBlock dexSignatureBlock;
    private static final String HEXCHAR = "0123456789ABCDEF";

    @Override
    public void parse() throws IOException {
        int i;
        this.setDexOptimizationData(this.dexSignatureBlock.getDexOptimizationData());
        int stringsSize = (int)this.dexPointerBlock.getStringIdsSize();
        this.file.seek(this.dexPointerBlock.getStringIdsOffset());
        long[] stringsPos = new long[stringsSize];
        for (i = 0; i < stringsSize; ++i) {
            stringsPos[i] = this.readFileOffset();
            this.dump("string[" + i + "]: at 0x" + this.dumpLong(stringsPos[i]));
        }
        this.setDumpOff();
        this.strings = new String[stringsSize];
        for (i = 0; i < this.strings.length; ++i) {
            this.file.seek(stringsPos[i]);
            this.strings[i] = this.readString();
            this.dump("// string[" + i + "]: " + this.strings[i]);
        }
        this.setDumpOn();
    }

    public int getStringsSize() {
        return (int)this.dexPointerBlock.getStringIdsSize();
    }

    public String getString(int idx) {
        return this.strings[idx];
    }

    public void setDexPointerBlock(DexPointerBlock dexPointerBlock) {
        this.dexPointerBlock = dexPointerBlock;
    }

    public void setDexSignatureBlock(DexSignatureBlock dexSignatureBlock) {
        this.dexSignatureBlock = dexSignatureBlock;
    }

    public static String escapeString(String input) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c;
            char ci = c = input.charAt(i);
            if (c == '\\') {
                b.append("\\\\");
                continue;
            }
            if (c == '\"') {
                b.append("\\\"");
                continue;
            }
            if (ci >= ' ' && ci <= '\u007f') {
                b.append(c);
                continue;
            }
            if (ci == '\u0000') {
                b.append("\\0");
                continue;
            }
            if (ci == '\u0007') {
                b.append("\\a");
                continue;
            }
            if (ci == '\b') {
                b.append("\\b");
                continue;
            }
            if (ci == '\t') {
                b.append("\\t");
                continue;
            }
            if (ci == '\f') {
                b.append("\\f");
                continue;
            }
            if (ci == '\n') {
                b.append("\\n");
                continue;
            }
            if (ci == '\r') {
                b.append("\\r");
                continue;
            }
            b.append("\\u");
            b.append(HEXCHAR.charAt((ci & 0xF000) >> 12));
            b.append(HEXCHAR.charAt((ci & 0xF00) >> 8));
            b.append(HEXCHAR.charAt((ci & 0xF0) >> 4));
            b.append(HEXCHAR.charAt(ci & 0xF));
        }
        return new String(b);
    }
}

