/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.util.base64;

public class Base64Engine {
    private static final byte ED = 64;
    private static final byte IL = 65;
    private static byte[] base64DecodeTable;
    private static byte[] base64EncodeTable;
    private LineEnding lineEnd = LineEnding.CR;
    private int lineLength = 76;
    boolean lineEndsAtBreaks = false;
    private static char[] bitsToChar;
    private static final byte[] charToBits;

    public Base64Engine() {
    }

    public Base64Engine(int n, LineEnding lineEnding) {
        this.lineLength = n;
        this.lineEnd = lineEnding;
    }

    public Base64Engine(int n, LineEnding lineEnding, boolean bl) {
        this(n, lineEnding);
        this.lineEndsAtBreaks = bl;
    }

    public int decode(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        return this.decode(byArray, n, n2, byArray2, n3, byArray2.length);
    }

    public int decode(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        return this.decode(byArray, n, n2, byArray2, n3, n4, 0);
    }

    public int decode(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (byArray2 != null) {
            n6 = Math.min(byArray2.length - n3, n4);
        }
        if (n2 > byArray.length - n) {
            n2 = byArray.length - n;
        }
        while (n2 > 0) {
            int n10 = 0;
            int n11 = 0;
            while (n10 < 4 && n2-- > 0) {
                byte by;
                if ((by = base64DecodeTable[byArray[n++] & 0x7F]) < 64) {
                    n11 = (n11 << 6) + by;
                    ++n10;
                    continue;
                }
                if (by != 64 || n10 == 0) continue;
                n2 = 0;
                break;
            }
            switch (n10) {
                case 1: {
                    n11 <<= 6;
                }
                case 2: {
                    n11 <<= 6;
                }
                case 3: {
                    n11 <<= 6;
                }
            }
            if (n10 >= 1) {
                if (n6 > 0 && n9 >= n5) {
                    --n6;
                    ++n7;
                    byArray2[n3 + n8++] = (byte)(n11 >> 16);
                }
                ++n9;
            }
            if (n10 >= 3) {
                if (n6 > 0 && n9 >= n5) {
                    --n6;
                    ++n7;
                    byArray2[n3 + n8++] = (byte)(n11 >> 8);
                }
                ++n9;
            }
            if (n10 != 4) continue;
            if (n6 > 0 && n9 >= n5) {
                --n6;
                ++n7;
                byArray2[n3 + n8++] = (byte)n11;
            }
            ++n9;
        }
        return n7;
    }

    public int encode(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        return this.encode(byArray, n, n2, byArray2, n3, 0);
    }

    public int encode(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        int n5;
        int n6;
        byte[] byArray3;
        int n7 = 0;
        int n8 = 0;
        if (byArray2 != null) {
            n7 = byArray2.length - n3;
        }
        if (n2 > byArray.length - n) {
            n2 = byArray.length - n;
        }
        int n9 = n4 % this.lineLength;
        while (n2 >= 3) {
            if (n9 == this.lineLength) {
                byArray3 = this.lineEnd.getEnding();
                for (n6 = 0; n6 < byArray3.length; ++n6) {
                    if (n7-- <= 0) continue;
                    byArray2[n3++] = byArray3[n6];
                    ++n8;
                }
                n9 = 0;
            }
            n5 = (byArray[n++] & 0xFF) << 16;
            n5 += (byArray[n++] & 0xFF) << 8;
            n5 += byArray[n++] & 0xFF;
            if (n7-- > 0) {
                byArray2[n3++] = base64EncodeTable[n5 >>> 18];
            }
            if (n7-- > 0) {
                byArray2[n3++] = base64EncodeTable[n5 >>> 12 & 0x3F];
            }
            if (n7-- > 0) {
                byArray2[n3++] = base64EncodeTable[n5 >>> 6 & 0x3F];
            }
            if (n7-- > 0) {
                byArray2[n3++] = base64EncodeTable[n5 & 0x3F];
            }
            n2 -= 3;
            n8 += 4;
            n9 += 4;
        }
        if ((n2 > 0 || this.lineEndsAtBreaks) && n9 == this.lineLength) {
            byArray3 = this.lineEnd.getEnding();
            for (n6 = 0; n6 < byArray3.length; ++n6) {
                if (n7-- <= 0) continue;
                byArray2[n3++] = byArray3[n6];
                ++n8;
            }
            n9 = 0;
        }
        if (n2 > 0) {
            n5 = (byArray[n++] & 0xFF) << 16;
            if (n2 > 1) {
                n5 += (byArray[n] & 0xFF) << 8;
            }
            if (n7-- > 0) {
                byArray2[n3++] = base64EncodeTable[n5 >>> 18];
            }
            if (n7-- > 0) {
                byArray2[n3++] = base64EncodeTable[n5 >>> 12 & 0x3F];
            }
            if (n7-- > 0) {
                byArray2[n3++] = n2 > 1 ? base64EncodeTable[n5 >>> 6 & 0x3F] : 61;
            }
            if (n7-- > 0) {
                byArray2[n3++] = 61;
            }
            n8 += 4;
        }
        return n8;
    }

    public char[] encode(byte[] byArray, int n, int n2) {
        int n3;
        char[] cArray = new char[(n2 * 8 + 23) / 24 * 4];
        int n4 = 0;
        while (n2 >= 3) {
            n3 = (byArray[n++] & 0xFF) << 16;
            n3 |= (byArray[n++] & 0xFF) << 8;
            cArray[n4++] = bitsToChar[(n3 |= byArray[n++] & 0xFF) >>> 18 & 0x3F];
            cArray[n4++] = bitsToChar[n3 >>> 12 & 0x3F];
            cArray[n4++] = bitsToChar[n3 >>> 6 & 0x3F];
            cArray[n4++] = bitsToChar[n3 & 0x3F];
            n2 -= 3;
        }
        if (n2 > 0) {
            n3 = (byArray[n++] & 0xFF) << 16;
            if (n2 > 1) {
                n3 |= (byArray[n] & 0xFF) << 8;
            }
            cArray[n4++] = bitsToChar[n3 >>> 18 & 0x3F];
            cArray[n4++] = bitsToChar[n3 >>> 12 & 0x3F];
            cArray[n4++] = n2 > 1 ? bitsToChar[n3 >>> 6 & 0x3F] : 61;
            cArray[n4++] = 61;
        }
        return cArray;
    }

    public byte[] decode(String string) {
        int n = string.length();
        if (n % 4 != 0) {
            return null;
        }
        int n2 = 3 * n / 4;
        if (n > 0 && string.charAt(n - 1) == '=') {
            --n;
            --n2;
        }
        if (n > 0 && string.charAt(n - 1) == '=') {
            --n;
            --n2;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            char c;
            if ((c = string.charAt(n4++)) > charToBits.length) {
                return null;
            }
            byte by = charToBits[c];
            if ((c = string.charAt(n4++)) > charToBits.length) {
                return null;
            }
            byte by2 = charToBits[c];
            int n5 = 0;
            if (n4 < n) {
                if ((c = string.charAt(n4++)) > charToBits.length) {
                    return null;
                }
                n5 = charToBits[c];
            }
            int n6 = 0;
            if (n4 < n) {
                if ((c = string.charAt(n4++)) > charToBits.length) {
                    return null;
                }
                n6 = charToBits[c];
            }
            if (by < 0 || by2 < 0 || n5 < 0 || n6 < 0) {
                return null;
            }
            byArray[n3++] = (byte)((by & 0x3F) << 2 | (by2 & 0x30) >> 4);
            if (n3 >= n2) continue;
            byArray[n3++] = (byte)((by2 & 0xF) << 4 | (n5 & 0x3C) >> 2);
            if (n3 >= n2) continue;
            byArray[n3++] = (byte)((n5 & 3) << 6 | n6 & 0x3F);
        }
        return byArray;
    }

    static {
        int n;
        base64DecodeTable = new byte[128];
        base64EncodeTable = new byte[64];
        for (n = 0; n < 128; ++n) {
            Base64Engine.base64DecodeTable[n] = 65;
        }
        for (n = 0; n < 26; ++n) {
            Base64Engine.base64DecodeTable[65 + n] = (byte)n;
            Base64Engine.base64EncodeTable[n] = (byte)(65 + n);
            Base64Engine.base64DecodeTable[97 + n] = (byte)(n + 26);
            Base64Engine.base64EncodeTable[n + 26] = (byte)(97 + n);
        }
        for (n = 0; n < 10; ++n) {
            Base64Engine.base64DecodeTable[48 + n] = (byte)(n + 52);
            Base64Engine.base64EncodeTable[n + 52] = (byte)(48 + n);
        }
        Base64Engine.base64DecodeTable[43] = 62;
        Base64Engine.base64EncodeTable[62] = 43;
        Base64Engine.base64DecodeTable[47] = 63;
        Base64Engine.base64EncodeTable[63] = 47;
        Base64Engine.base64DecodeTable[61] = 64;
        bitsToChar = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        charToBits = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};
    }

    public static final class LineEnding {
        private byte[] ending;
        private static final byte[] lf = new byte[]{10};
        public static final LineEnding LF = new LineEnding(lf);
        private static final byte[] cr = new byte[]{13};
        public static final LineEnding CR = new LineEnding(cr);
        private static final byte[] crlf = new byte[]{13, 10};
        public static final LineEnding CRLF = new LineEnding(crlf);
        private static final byte[] none = new byte[0];
        public static final LineEnding NONE = new LineEnding(none);

        private LineEnding(byte[] byArray) {
            this.ending = byArray;
        }

        protected byte[] getEnding() {
            return this.ending;
        }

        protected int length() {
            return this.ending.length;
        }
    }
}

