/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io.stream;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.InputStreamImpl;
import java.io.IOException;
import java.io.InputStream;

public abstract class InputByteStreamImpl
implements InputByteStream {
    protected int mark = 0;

    protected InputByteStreamImpl() {
    }

    public abstract InputByteStream slice(long var1, long var3) throws IOException;

    public InputByteStream slice() throws IOException {
        return this.slice(0L, this.length());
    }

    public abstract int read() throws IOException;

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int unget() throws IOException {
        this.seek(this.getPosition() - 1L);
        int n = this.read();
        this.seek(this.getPosition() - 1L);
        return n;
    }

    public abstract InputByteStream seek(long var1) throws IOException;

    public abstract long getPosition() throws IOException;

    public abstract long length() throws IOException;

    public long bytesAvailable() throws IOException {
        return this.length() - this.getPosition();
    }

    public boolean eof() throws IOException {
        return this.getPosition() >= this.length();
    }

    public abstract void close() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string = "";
        byte[] byArray = new byte[100];
        InputByteStream inputByteStream = null;
        try {
            inputByteStream = this.slice(this.getPosition(), Math.min(this.length() - this.getPosition(), (long)byArray.length));
            inputByteStream.read(byArray);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (inputByteStream != null) {
                    inputByteStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        try {
            string = new String("InputByteStream [ position = " + this.getPosition() + ", limit = " + this.length() + ", available = " + this.bytesAvailable() + ", mark = " + this.mark + " ] ") + new String(byArray, "US-ASCII");
        }
        catch (IOException iOException) {
            string = "";
        }
        return string;
    }

    public InputStream toInputStream() throws IOException {
        InputByteStream inputByteStream = this.slice();
        return new InputStreamImpl(inputByteStream);
    }
}

