/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io.stream;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.InputByteStreamImpl;
import java.io.IOException;
import java.util.ArrayList;

final class ChainedInputByteStream
extends InputByteStreamImpl {
    private InputByteStream[] mByteStreams;
    private long[] mLengths;
    private int mCurrentByteStreamIndex;
    private long mPosition;
    private long mTotalLength;

    ChainedInputByteStream(InputByteStream[] inputByteStreamArray) throws IOException {
        this.mByteStreams = inputByteStreamArray;
        this.mLengths = new long[this.mByteStreams.length];
        for (int i = 0; i < this.mLengths.length; ++i) {
            this.mByteStreams[i].seek(0L);
            this.mLengths[i] = this.mByteStreams[i].length();
            this.mTotalLength += this.mLengths[i];
        }
    }

    public long getPosition() throws IOException {
        return this.mPosition;
    }

    public long length() throws IOException {
        return this.mTotalLength;
    }

    public InputByteStream seek(long l) throws IOException {
        if (l < 0L) {
            l = 0L;
        }
        if (l >= this.mTotalLength) {
            l = this.mTotalLength - 1L;
        }
        this.mPosition = l;
        this.mCurrentByteStreamIndex = 0;
        while (l >= this.mLengths[this.mCurrentByteStreamIndex]) {
            l -= this.mLengths[this.mCurrentByteStreamIndex];
            ++this.mCurrentByteStreamIndex;
        }
        this.mByteStreams[this.mCurrentByteStreamIndex].seek(l);
        return this;
    }

    public InputByteStream slice(long l, long l2) throws IOException {
        int n;
        if (l < 0L || l >= this.mTotalLength || l2 < 0L || l + l2 > this.mTotalLength) {
            throw new IOException("Invalid Parameter");
        }
        ArrayList<InputByteStream> arrayList = new ArrayList<InputByteStream>();
        long l3 = l + l2;
        long l4 = l;
        int n2 = 0;
        while (l4 >= this.mLengths[n2]) {
            l4 -= this.mLengths[n2];
            ++n2;
        }
        int n3 = 0;
        while (l3 > this.mLengths[n3]) {
            l3 -= this.mLengths[n3];
            ++n3;
        }
        for (n = n2; n < n3; ++n) {
            arrayList.add(this.mByteStreams[n].slice(l4, this.mLengths[n] - l4));
            l4 = 0L;
        }
        arrayList.add(this.mByteStreams[n].slice(l4, l3 - l4));
        InputByteStream[] inputByteStreamArray = new InputByteStream[arrayList.size()];
        System.arraycopy(arrayList.toArray(), 0, inputByteStreamArray, 0, arrayList.size());
        return new ChainedInputByteStream(inputByteStreamArray);
    }

    public void close() throws IOException {
        for (int i = 0; i < this.mByteStreams.length; ++i) {
            this.mByteStreams[i].close();
        }
        this.mByteStreams = null;
    }

    public int read() throws IOException {
        if (this.mCurrentByteStreamIndex >= this.mLengths.length) {
            return -1;
        }
        int n = this.mByteStreams[this.mCurrentByteStreamIndex].read();
        if (n == -1) {
            ++this.mCurrentByteStreamIndex;
            if (this.mCurrentByteStreamIndex == this.mLengths.length) {
                return -1;
            }
            this.mByteStreams[this.mCurrentByteStreamIndex].seek(0L);
            n = this.read();
        } else {
            ++this.mPosition;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (this.mCurrentByteStreamIndex >= this.mLengths.length) {
            return -1;
        }
        while (n3 < n2) {
            int n4 = this.mByteStreams[this.mCurrentByteStreamIndex].read(byArray, n + n3, n2 - n3);
            if (n4 == -1) {
                ++this.mCurrentByteStreamIndex;
                if (this.mCurrentByteStreamIndex < this.mLengths.length) continue;
                if (n3 != 0) break;
                return -1;
            }
            n3 += n4;
        }
        this.mPosition += (long)n3;
        return n3;
    }
}

