/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.utils;

public class Version
implements Comparable<Version> {
    private final Integer major;
    private final Integer minor;
    private final Integer bugFix;
    private final Integer build;

    private static int cmp(Integer i1, Integer i2) {
        int j2;
        int j1 = i1 != null ? i1 : 0;
        int n = j2 = i2 != null ? i2 : 0;
        if (j1 > j2) {
            return 1;
        }
        if (j1 < j2) {
            return -1;
        }
        return 0;
    }

    public Version(Integer major, Integer minor, Integer bugFix, Integer build) {
        assert (major >= 0) : "major version number cannot be negative";
        assert (minor == null || minor >= 0) : "minor version number cannot be negative";
        assert (bugFix == null || bugFix >= 0) : "bugFix version number cannot be negative";
        assert (build == null || build >= 0) : "build version number cannot be negative";
        this.major = major;
        this.minor = minor;
        this.bugFix = bugFix;
        this.build = build;
    }

    public Version(int major, int minor, int bugFix) {
        this(major, minor, bugFix, null);
    }

    public Version(int major, int minor) {
        this(major, minor, null, null);
    }

    public Version(int major) {
        this(major, null, null, null);
    }

    public Version(String versionString) {
        this(versionString.split("\\."));
    }

    private Version(String[] parts) {
        int n = parts.length;
        assert (1 <= n && n <= 4) : "version string should have 1-4 parts";
        this.major = Integer.parseInt(parts[0]);
        this.minor = n >= 2 ? Integer.valueOf(Integer.parseInt(parts[1])) : null;
        this.bugFix = n >= 3 ? Integer.valueOf(Integer.parseInt(parts[2])) : null;
        this.build = n == 4 ? Integer.valueOf(Integer.parseInt(parts[3])) : null;
    }

    public String toString() {
        return this.getDisplayString();
    }

    @Override
    public int compareTo(Version other) {
        int compareBugFix = this.compareBugFixVersionTo(other);
        if (compareBugFix != 0) {
            return compareBugFix;
        }
        return Version.cmp(this.build, other.build);
    }

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public Integer getBugFix() {
        return this.bugFix;
    }

    public Integer getBuild() {
        return this.build;
    }

    public String getDisplayString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major);
        if (this.minor != null) {
            sb.append('.');
            sb.append(this.minor);
        }
        if (this.bugFix != null) {
            sb.append('.');
            sb.append(this.bugFix);
        }
        if (this.build != null) {
            sb.append('.');
            sb.append(this.build);
        }
        return sb.toString();
    }

    public int compareMajorVersionTo(Version other) {
        return Version.cmp(this.major, other.major);
    }

    public int compareMinorVersionTo(Version other) {
        int compareMajor = this.compareMajorVersionTo(other);
        if (compareMajor != 0) {
            return compareMajor;
        }
        return Version.cmp(this.minor, other.minor);
    }

    public int compareBugFixVersionTo(Version other) {
        int compareMinor = this.compareMinorVersionTo(other);
        if (compareMinor != 0) {
            return compareMinor;
        }
        return Version.cmp(this.bugFix, other.bugFix);
    }
}

