/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.utils;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class IntMap {
    private int[] keys;
    private Object[] values;
    private int size;

    public IntMap() {
        this(10);
    }

    public IntMap(int capacity) {
        this.keys = new int[capacity];
        this.values = new Object[capacity];
    }

    public int capacity() {
        return this.keys.length;
    }

    private int find(int k) {
        int lo = 0;
        int hi = this.size - 1;
        while (lo <= hi) {
            int i = lo + hi >>> 1;
            int m = this.keys[i];
            if (k > m) {
                lo = i + 1;
                continue;
            }
            if (k < m) {
                hi = i - 1;
                continue;
            }
            return i;
        }
        return -(lo + 1);
    }

    public Object remove(int k) {
        Object old = null;
        int i = this.find(k);
        if (i >= 0) {
            old = this.values[i];
            System.arraycopy(this.keys, i + 1, this.keys, i, this.size - i - 1);
            System.arraycopy(this.values, i + 1, this.values, i, this.size - i - 1);
            --this.size;
        }
        return old;
    }

    public void clear() {
        this.size = 0;
    }

    public Object put(int k, Object v) {
        if (this.size == 0 || k > this.keys[this.size - 1]) {
            if (this.size == this.keys.length) {
                this.grow();
            }
            this.keys[this.size] = k;
            this.values[this.size] = v;
            ++this.size;
            return null;
        }
        int i = this.find(k);
        if (i >= 0) {
            Object old = this.values[i];
            this.values[i] = v;
            return old;
        }
        i = -i - 1;
        if (this.size == this.keys.length) {
            this.grow();
        }
        System.arraycopy(this.keys, i, this.keys, i + 1, this.size - i);
        System.arraycopy(this.values, i, this.values, i + 1, this.size - i);
        this.keys[i] = k;
        this.values[i] = v;
        ++this.size;
        return null;
    }

    private void grow() {
        int[] newkeys = new int[this.size * 2];
        System.arraycopy(this.keys, 0, newkeys, 0, this.size);
        this.keys = newkeys;
        Object[] newvalues = new Object[this.size * 2];
        System.arraycopy(this.values, 0, newvalues, 0, this.size);
        this.values = newvalues;
    }

    public Object get(int k) {
        int i = this.find(k);
        return i >= 0 ? this.values[i] : null;
    }

    public boolean contains(int k) {
        return this.find(k) >= 0;
    }

    public Object getNextAdjacent(int k) {
        int i = this.find(k);
        return i >= 0 && i + 1 < this.size ? this.values[i + 1] : null;
    }

    public Iterator<Map.Entry<Integer, Object>> iterator() {
        return new Iterator<Map.Entry<Integer, Object>>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < IntMap.this.size;
            }

            @Override
            public Map.Entry<Integer, Object> next() {
                if (this.i >= IntMap.this.size) {
                    throw new NoSuchElementException();
                }
                final int j = this.i++;
                return new Map.Entry<Integer, Object>(){

                    @Override
                    public Integer getKey() {
                        return IntMap.this.keys[j];
                    }

                    @Override
                    public Object getValue() {
                        return IntMap.this.values[j];
                    }

                    @Override
                    public Object setValue(Object value) {
                        Object old = IntMap.this.values[j];
                        ((IntMap)IntMap.this).values[j] = value;
                        return old;
                    }
                };
            }

            @Override
            public void remove() {
                System.arraycopy(IntMap.this.keys, this.i, IntMap.this.keys, this.i - 1, IntMap.this.size - this.i);
                System.arraycopy(IntMap.this.values, this.i, IntMap.this.values, this.i - 1, IntMap.this.size - this.i);
                IntMap.this.size--;
            }
        };
    }

    public int size() {
        return this.size;
    }

    public Object[] valuesToArray(Object[] ar) {
        System.arraycopy(this.values, 0, ar, 0, this.size);
        return ar;
    }

    public int[] keySetToArray() {
        int[] ar = new int[this.size()];
        System.arraycopy(this.keys, 0, ar, 0, this.size);
        return ar;
    }
}

