/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.utils;

import com.adobe.flash.utils.FilenameNormalization;
import java.io.File;
import java.util.Locale;

public class FileID {
    private final String lowerCasePath;
    private final File originalFile;

    public FileID(File file) {
        this.lowerCasePath = FileID.fileToLowerCaseString(file);
        assert (this.lowerCasePath != null);
        this.originalFile = file;
    }

    public String toString() {
        return this.lowerCasePath;
    }

    public boolean equals(Object other) {
        if (!(other instanceof FileID)) {
            return false;
        }
        FileID otherId = (FileID)other;
        return this.lowerCasePath.equals(otherId.lowerCasePath);
    }

    public int hashCode() {
        return this.lowerCasePath.hashCode();
    }

    public File getFile() {
        return this.originalFile;
    }

    static String fileToLowerCaseString(File f) {
        String normalizedPath = FilenameNormalization.normalize(f.getAbsolutePath());
        return normalizedPath.toLowerCase(Locale.US);
    }

    String getLowerCasePath() {
        return this.lowerCasePath;
    }
}

