/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CheapArray {
    private CheapArray() {
    }

    public static Object create(int initialCapacity) {
        return new ArrayList(initialCapacity);
    }

    public static Object[] toArray(Object array, Object[] emptyArray) {
        assert (emptyArray.length == 0);
        if (array instanceof List) {
            return ((List)array).toArray(emptyArray);
        }
        return (Object[])array;
    }

    public static int size(Object array) {
        if (array == null) {
            return 0;
        }
        if (array instanceof List) {
            return ((List)array).size();
        }
        return ((Object[])array).length;
    }

    public static Object get(int i, Object array) {
        if (array instanceof List) {
            return ((List)array).get(i);
        }
        return ((Object[])array)[i];
    }

    public static void add(Object item, Object array) {
        assert (array instanceof List);
        ((List)array).add(item);
    }

    public static void sort(Object array, Comparator comparator) {
        if (array instanceof List) {
            Collections.sort((List)array, comparator);
        } else {
            Arrays.sort((Object[])array, comparator);
        }
    }

    public static Object add(Object item, Object array, Object[] emptyArray) {
        if (array instanceof List) {
            ((List)array).add(item);
            return array;
        }
        int oldSize = ((Object[])array).length;
        Object[] newArray = (Object[])Array.newInstance(emptyArray.getClass().getComponentType(), oldSize + 1);
        System.arraycopy(array, 0, newArray, 0, oldSize);
        newArray[oldSize] = item;
        return newArray;
    }

    public static void add(int index, Object item, Object array) {
        assert (array instanceof List);
        ((List)array).add(index, item);
    }

    public static void replace(int index, Object item, Object array) {
        if (array instanceof List) {
            ((List)array).remove(index);
            ((List)array).add(index, item);
        } else {
            ((Object[])array)[index] = item;
        }
    }

    public static void remove(Object item, Object array) {
        assert (array instanceof List);
        ((List)array).remove(item);
    }

    public static Object remove(Object item, Object array, Object[] emptyArray) {
        if (array instanceof List) {
            ((List)array).remove(item);
            return array;
        }
        int oldSize = ((Object[])array).length;
        for (int i = 0; i < oldSize; ++i) {
            if (!((Object[])array)[i].equals(item)) continue;
            Object[] newArray = (Object[])Array.newInstance(emptyArray.getClass().getComponentType(), oldSize - 1);
            System.arraycopy(array, 0, newArray, 0, i);
            System.arraycopy(array, i + 1, newArray, i, oldSize - i - 1);
            return newArray;
        }
        return array;
    }

    public static Object optimize(Object array, Object[] emptyArray) {
        assert (emptyArray.length == 0);
        if (array instanceof List) {
            if (((List)array).size() == 0) {
                return emptyArray;
            }
            return ((List)array).toArray(emptyArray);
        }
        return array;
    }
}

