/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.swf.tags;

import com.adobe.flash.swf.TagType;
import com.adobe.flash.swf.tags.IManagedTag;
import com.adobe.flash.swf.tags.Tag;
import java.util.Date;

public class ProductInfoTag
extends Tag
implements IManagedTag {
    private Edition edition;
    private Product product;
    private byte majorVersion;
    private byte minorVersion;
    private long build;
    private long compileDate;

    public ProductInfoTag(Product product, Edition edition, byte majorVersion, byte minorVersion, long build, long compileDate) {
        super(TagType.ProductInfo);
        this.product = product;
        this.edition = edition;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.build = build;
        this.compileDate = compileDate;
    }

    public Edition getEdition() {
        return this.edition;
    }

    public void setEdition(Edition edition) {
        this.edition = edition;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public byte getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(byte majorVersion) {
        this.majorVersion = majorVersion;
    }

    public byte getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(byte minorVersion) {
        this.minorVersion = minorVersion;
    }

    public long getBuild() {
        return this.build;
    }

    public void setBuild(long build) {
        this.build = build;
    }

    public long getCompileDate() {
        return this.compileDate;
    }

    public void setCompileDate(long compileDate) {
        this.compileDate = compileDate;
    }

    @Override
    public String description() {
        return String.format("product=%s, edition=%s, version=%d.%d build %d, compiled on %s", new Object[]{this.product, this.edition, this.majorVersion, this.minorVersion, this.build, new Date(this.compileDate)});
    }

    public static enum Edition {
        DEVELOPER(0, "Developer Edition"),
        FULL_COMMERCIAL(1, "Full Commercial Edition"),
        NON_COMMERCIAL(2, "Non-Commercial Edition"),
        EDUCATIONAL(3, "Educational Edition"),
        NFR(4, "NFR Edition"),
        TRIAL(5, "Trial Edition"),
        NONE(6, "");

        private final int code;
        private final String name;

        public static Edition fromCode(int code) {
            for (Edition edition : Edition.values()) {
                if (edition.code != code) continue;
                return edition;
            }
            return null;
        }

        private Edition(int code, String name) {
            this.code = code;
            this.name = name;
        }

        public int getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Product {
        UNKNOWN(0, "unknown"),
        J2EE(1, "Macromedia Flex for J2EE"),
        DOTNET(2, "Macromedia Flex for .NET"),
        FLEX(3, "Adobe Flex");

        private final int code;
        private final String name;

        public static Product fromCode(int code) {
            for (Product product : Product.values()) {
                if (product.code != code) continue;
                return product;
            }
            return null;
        }

        private Product(int code, String name) {
            this.code = code;
            this.name = name;
        }

        public int getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }
    }
}

