/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.swf.tags;

import com.adobe.flash.swf.TagType;
import com.adobe.flash.swf.tags.CharacterTag;
import com.adobe.flash.swf.tags.DefineScalingGridTag;
import com.adobe.flash.swf.tags.ICharacterReferrer;
import com.adobe.flash.swf.tags.ICharacterTag;
import com.adobe.flash.swf.tags.IImportClassName;
import com.adobe.flash.swf.tags.IScalableTag;
import com.adobe.flash.swf.tags.ITag;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefineSpriteTag
extends CharacterTag
implements ICharacterReferrer,
IScalableTag,
IImportClassName {
    private final int frameCount;
    private final List<ITag> controlTags;
    private DefineScalingGridTag scalingGrid;

    public DefineSpriteTag(int frameCount, List<ITag> controlTags) {
        super(TagType.DefineSprite);
        this.frameCount = frameCount;
        this.controlTags = controlTags;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public List<ITag> getControlTags() {
        return this.controlTags;
    }

    @Override
    public DefineScalingGridTag getScalingGrid() {
        return this.scalingGrid;
    }

    @Override
    public void setScalingGrid(DefineScalingGridTag scalingGrid) {
        this.scalingGrid = scalingGrid;
    }

    @Override
    public String description() {
        StringBuilder result = new StringBuilder();
        result.append(String.format("#%d, including %d frame(s)", this.getCharacterID(), this.frameCount));
        for (ITag tag : this.controlTags) {
            result.append("\n  >> ").append(tag);
        }
        return result.toString();
    }

    @Override
    public Iterable<ICharacterTag> getReferences() {
        ArrayList<ICharacterTag> result = new ArrayList<ICharacterTag>();
        for (ITag controlTag : this.controlTags) {
            if (!(controlTag instanceof ICharacterReferrer)) continue;
            for (ICharacterTag tag : ((ICharacterReferrer)((Object)controlTag)).getReferences()) {
                assert (tag != null);
                result.add(tag);
            }
        }
        return result;
    }

    @Override
    public Set<String> getClassNames() {
        HashSet<String> result = new HashSet<String>();
        for (ITag controlTag : this.controlTags) {
            if (!(controlTag instanceof IImportClassName)) continue;
            result.addAll(((IImportClassName)((Object)controlTag)).getClassNames());
        }
        return result;
    }
}

