/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.swf.io;

import com.adobe.flash.swc.io.ISWFWriterFactory;
import com.adobe.flash.swf.Header;
import com.adobe.flash.swf.ISWF;
import com.adobe.flash.swf.io.IOutputBitStream;
import com.adobe.flash.swf.io.ISWFWriter;
import com.adobe.flash.swf.io.SWFWriter;
import com.adobe.flash.swf.io.SizeReport;
import com.adobe.flash.swf.tags.CharacterTag;
import com.adobe.flash.swf.tags.DefineBinaryDataTag;
import com.adobe.flash.swf.tags.DefineFont2Tag;
import com.adobe.flash.swf.tags.DefineFont4Tag;
import com.adobe.flash.swf.tags.DefineFontNameTag;
import com.adobe.flash.swf.tags.DefineFontTag;
import com.adobe.flash.swf.tags.DefineShapeTag;
import com.adobe.flash.swf.tags.DefineSoundTag;
import com.adobe.flash.swf.tags.DefineSpriteTag;
import com.adobe.flash.swf.tags.DefineVideoStreamTag;
import com.adobe.flash.swf.tags.DoABCTag;
import com.adobe.flash.swf.tags.FileAttributesTag;
import com.adobe.flash.swf.tags.FrameLabelTag;
import com.adobe.flash.swf.tags.ITag;
import com.adobe.flash.swf.tags.SymbolClassTag;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import org.apache.commons.io.output.CountingOutputStream;

public class SWFWriterAndSizeReporter
extends SWFWriter {
    private final File sizeReportFile;
    private final SizeReport report;
    private boolean definingSprite = false;

    public static ISWFWriterFactory getSWFWriterFactory(File sizeReport) {
        if (sizeReport != null) {
            return new SWFWriterFactory(sizeReport);
        }
        return SWFWriter.DEFAULT_SWF_WRITER_FACTORY;
    }

    public SWFWriterAndSizeReporter(ISWF swf, Header.Compression useCompression, boolean enableDebug, File sizeReport) {
        super(swf, useCompression, enableDebug);
        assert (sizeReport != null);
        this.sizeReportFile = sizeReport;
        this.report = new SizeReport();
    }

    @Override
    public int writeTo(File outputFile) throws FileNotFoundException, IOException {
        int bytes = super.writeTo(outputFile);
        this.report.setCompressedSize(bytes);
        return bytes;
    }

    @Override
    public void writeTo(OutputStream output) {
        CountingOutputStream countingOutput = new CountingOutputStream(output);
        super.writeTo((OutputStream)countingOutput);
        this.report.setCompressedSize(countingOutput.getCount());
        this.writeSizeReport();
    }

    @Override
    protected void finishTag(ITag tag, IOutputBitStream tagData, IOutputBitStream out) {
        int startPos = out.size();
        super.finishTag(tag, tagData, out);
        int recordLength = out.size() - startPos;
        switch (tag.getTagType()) {
            case DoABC: {
                this.reportDoABC((DoABCTag)tag, recordLength);
                break;
            }
            case FileAttributes: {
                this.reportFileAttributes((FileAttributesTag)tag, recordLength);
                break;
            }
            case SymbolClass: {
                this.reportSymbolClass((SymbolClassTag)tag, recordLength);
                break;
            }
            case ShowFrame: {
                this.reportShowFrame(recordLength);
                break;
            }
            case SetBackgroundColor: {
                this.reportSetBackgroundColor(recordLength);
                break;
            }
            case EnableDebugger2: {
                this.reportEnableDebugger2(recordLength);
                break;
            }
            case ScriptLimits: {
                this.reportScriptLimits(recordLength);
                break;
            }
            case Metadata: {
                this.reportMetadata(recordLength);
                break;
            }
            case DefineBits: 
            case DefineBitsJPEG2: 
            case DefineBitsJPEG3: 
            case DefineBitsLossless2: {
                this.reportBitmap((CharacterTag)tag, recordLength);
                break;
            }
            case DefineBinaryData: {
                this.reportDefineBinaryData((DefineBinaryDataTag)tag, recordLength);
                break;
            }
            case DefineShape: 
            case DefineShape2: 
            case DefineShape3: 
            case DefineShape4: {
                this.reportDefineShape((DefineShapeTag)tag, recordLength);
                break;
            }
            case DefineSprite: {
                this.reportDefineSprite((DefineSpriteTag)tag, recordLength);
                break;
            }
            case ExportAssets: {
                this.reportExportAssets(recordLength);
                break;
            }
            case DefineFont: {
                this.reportDefineFont((DefineFontTag)tag, recordLength);
                break;
            }
            case DefineFont2: 
            case DefineFont3: {
                this.reportDefineFont2or3((DefineFont2Tag)tag, recordLength);
                break;
            }
            case DefineFont4: {
                this.reportDefineFont4((DefineFont4Tag)tag, recordLength);
                break;
            }
            case DefineSound: {
                this.reportDefineSound((DefineSoundTag)tag, recordLength);
                break;
            }
            case DefineVideoStream: {
                this.reportDefineVideoStream((DefineVideoStreamTag)tag, recordLength);
                break;
            }
            case End: {
                this.reportEnd();
                break;
            }
            case FrameLabel: {
                this.reportFrameLabel((FrameLabelTag)tag, recordLength);
            }
        }
    }

    @Override
    protected void writeCompressibleHeader() {
        super.writeCompressibleHeader();
        this.tagBuffer.flush();
        this.report.startEntry(5, 0, -1, "swfHeader");
        this.report.endEntry(5, this.tagBuffer.size() + 12);
    }

    @Override
    protected void writeDefineSprite(DefineSpriteTag tag, Collection<ITag> extraTags) {
        this.definingSprite = true;
        super.writeDefineSprite(tag, extraTags);
        this.definingSprite = false;
    }

    private void reportShowFrame(int recordLength) {
        if (!this.definingSprite) {
            this.report.addEntry(4, -1, 2, "showFrame");
            this.report.endEntry(3, 0);
        }
    }

    private void reportDefineBinaryData(DefineBinaryDataTag tag, int recordLength) {
        this.report.addEntry(0, tag.getCharacterID(), recordLength);
    }

    private void reportDefineShape(DefineShapeTag tag, int recordLength) {
        this.report.addEntry(7, tag.getCharacterID(), recordLength);
    }

    public void reportDoABC(DoABCTag tag, int recordLength) {
        this.report.addEntry(6, -1, recordLength, tag.getName());
    }

    private void reportEnableDebugger2(int recordLength) {
        this.report.addEntry(5, -1, recordLength, "enableDebugger");
    }

    public void reportFileAttributes(FileAttributesTag tag, int recordLength) {
        this.report.addEntry(5, -1, recordLength, "fileAttributes");
    }

    private void reportMetadata(int recordLength) {
        this.report.addEntry(5, -1, recordLength, "metaData");
    }

    private void reportScriptLimits(int recordLength) {
        this.report.addEntry(5, -1, recordLength, "scriptLimits");
    }

    private void reportSetBackgroundColor(int recordLength) {
        this.report.addEntry(5, -1, recordLength, "backgroundColor");
    }

    private void reportEnd() {
        this.report.addEntry(5, -1, 2, "endMarker");
        this.report.setSize(this.outputBuffer.size());
    }

    private void reportSymbolClass(SymbolClassTag tag, int recordLength) {
        for (String symbol : tag.getSymbolNames()) {
            this.report.addSymbol(symbol, tag.getSymbol(symbol).getCharacterID());
        }
        this.report.addEntry(4, -1, recordLength, "symbolClass");
    }

    private void reportDefineVideoStream(DefineVideoStreamTag tag, int recordLength) {
        this.report.addEntry(10, tag.getCharacterID(), recordLength);
    }

    private void reportDefineSound(DefineSoundTag tag, int recordLength) {
        this.report.addEntry(8, tag.getCharacterID(), recordLength);
    }

    private void reportDefineFont(DefineFontTag tag, int recordLength) {
        String fontName = null;
        DefineFontNameTag license = tag.getLicense();
        if (license != null) {
            fontName = license.getFontName();
        }
        this.report.addEntry(2, tag.getCharacterID(), recordLength, fontName);
    }

    private void reportDefineFont2or3(DefineFont2Tag tag, int recordLength) {
        this.report.addEntry(2, tag.getCharacterID(), recordLength, tag.getFontName());
    }

    private void reportDefineFont4(DefineFont4Tag tag, int recordLength) {
        this.report.addEntry(2, tag.getCharacterID(), recordLength, tag.getFontName());
    }

    private void reportBitmap(CharacterTag tag, int recordLength) {
        this.report.addEntry(1, tag.getCharacterID(), recordLength);
    }

    private void reportExportAssets(int recordLength) {
        this.report.addEntry(4, -1, recordLength, "exportAssets");
    }

    private void reportDefineSprite(DefineSpriteTag tag, int recordLength) {
        this.report.addEntry(9, tag.getCharacterID(), recordLength);
    }

    private void reportFrameLabel(FrameLabelTag tag, int recordLength) {
        this.report.startEntry(3, 0, -1, tag.getName());
        this.report.addEntry(4, -1, recordLength, "frameLabel");
    }

    private void writeSizeReport() {
        Writer reportOut = null;
        try {
            reportOut = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.sizeReportFile), "UTF8"));
            reportOut.write(this.report.generate());
            reportOut.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reportOut != null) {
                try {
                    reportOut.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static class SWFWriterFactory
    implements ISWFWriterFactory {
        private final File sizeReport;

        SWFWriterFactory(File sizeReport) {
            this.sizeReport = sizeReport;
        }

        @Override
        public ISWFWriter createSWFWriter(ISWF swf, Header.Compression useCompression, boolean enableDebug) {
            return new SWFWriterAndSizeReporter(swf, useCompression, enableDebug, this.sizeReport);
        }
    }
}

