/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.swf.io;

import SevenZip.Compression.LZMA.Decoder;
import com.adobe.flash.utils.DAByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LZMAInputStream
extends InputStream {
    private final Decoder decoder = new Decoder();
    private final InputStream inputStream;
    private byte[] buffer = null;
    private int readIndex;

    public LZMAInputStream(InputStream inputStream) throws IOException {
        this.inputStream = inputStream;
        this.initDecode();
    }

    @Override
    public int read() throws IOException {
        int ret;
        if (this.readIndex >= this.buffer.length) {
            return -1;
        }
        if ((ret = this.buffer[this.readIndex++]) < 0) {
            ret += 256;
        }
        return ret;
    }

    private void initDecode() throws IOException {
        int propertiesSize = 5;
        byte[] properties = new byte[propertiesSize];
        if (this.inputStream.read(properties, 0, propertiesSize) != propertiesSize) {
            throw new IOException("input .lzma file is too short");
        }
        if (!this.decoder.SetDecoderProperties(properties)) {
            throw new IOException("Incorrect stream properties");
        }
        DAByteArrayOutputStream os = new DAByteArrayOutputStream();
        long outSize = -1L;
        if (!this.decoder.Code(this.inputStream, (OutputStream)os, outSize)) {
            throw new IOException("Error in data stream");
        }
        os.flush();
        this.readIndex = 0;
        this.buffer = os.getDirectByteArray();
    }
}

