/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.swf.io;

import com.adobe.flash.swf.Header;
import com.adobe.flash.swf.io.IInputBitStream;
import com.adobe.flash.swf.io.LZMAInputStream;
import com.adobe.flash.utils.DAByteArrayOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.IOUtils;

public class InputBitStream
extends InputStream
implements IInputBitStream {
    private InputStream in;
    private int bitPos = 0;
    private int bitBuf = 0;
    private long offset = 0L;
    private long readBoundary = 0L;

    public InputBitStream(InputStream in) {
        this.in = in;
    }

    public InputBitStream(byte[] bytes) {
        this.in = new ByteArrayInputStream(bytes);
    }

    @Override
    public void byteAlign() {
        this.bitPos = 0;
    }

    @Override
    public int read() throws IOException {
        return this.readByte();
    }

    @Override
    public byte[] read(int length) {
        byte[] data = new byte[length];
        try {
            this.read(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return data;
    }

    @Override
    public boolean readBit() {
        return this.readBits(1) != 0;
    }

    protected int readBits(int length) {
        int shift;
        if (length == 0) {
            return 0;
        }
        int bitsLeft = length;
        int result = 0;
        if (this.bitPos == 0) {
            this.bitBuf = this.readUI8();
            this.bitPos = 8;
        }
        while ((shift = bitsLeft - this.bitPos) > 0) {
            result |= this.bitBuf << shift;
            bitsLeft -= this.bitPos;
            this.bitBuf = this.readUI8();
            this.bitPos = 8;
        }
        this.bitPos -= bitsLeft;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return result |= this.bitBuf >> -shift;
    }

    protected int readByte() {
        this.byteAlign();
        try {
            if (this.offset >= this.readBoundary) {
                throw new RuntimeException(String.format("About to read over or reading over the boundary: %d -> %d.", this.offset, this.readBoundary));
            }
            int n = this.in.read();
            ++this.offset;
            if (-1 == n) {
                throw new RuntimeException("No more data to read.");
            }
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public double readDOUBLE() {
        return Double.longBitsToDouble(this.readSI64());
    }

    @Override
    public long readEncodedU32() {
        long decoded = 0L;
        for (int i = 0; i < 5; ++i) {
            int nextByte = this.readByte();
            decoded = decoded << 7 | (long)(nextByte & 0x7F);
            if ((nextByte & 0x80) == 0) break;
        }
        return decoded & 0xFFFFFFFFFF000000L | decoded & 0xFF0000L | decoded & 0xFF00L | decoded & 0xFFL;
    }

    @Override
    public float readFB(int length) {
        return (float)this.readSB(length) / 65536.0f;
    }

    @Override
    public float readFIXED() {
        return (float)this.readSI32() / 65536.0f;
    }

    @Override
    public float readFIXED8() {
        return (float)this.readSI16() / 256.0f;
    }

    @Override
    public float readFLOAT() {
        return Float.intBitsToFloat(this.readSI32());
    }

    @Override
    public int readSB(int length) {
        int bits = this.readBits(length);
        return bits << 32 - length >> 32 - length;
    }

    @Override
    public short readSI16() {
        return (short)(this.readByte() | this.readByte() << 8);
    }

    @Override
    public int readSI32() {
        return this.readByte() | this.readByte() << 8 | this.readByte() << 16 | this.readByte() << 24;
    }

    @Override
    public long readSI64() {
        return this.readUI32() & 0xFFFFFFFFL | this.readUI32() << 32;
    }

    @Override
    public byte readSI8() {
        return (byte)this.readByte();
    }

    @Override
    public String readString() {
        DAByteArrayOutputStream buffer = new DAByteArrayOutputStream();
        short nextByte2 = this.readUI8();
        while (nextByte2 != 0) {
            buffer.write(nextByte2);
            nextByte2 = this.readUI8();
        }
        try {
            String nextByte2 = new String(buffer.getDirectByteArray(), 0, buffer.size(), "UTF-8");
            return nextByte2;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)buffer);
        }
    }

    @Override
    public int readUB(int length) {
        return this.readBits(length);
    }

    @Override
    public int readUI16() {
        return 0xFFFF & this.readSI16();
    }

    @Override
    public int readUI24() {
        return 0xFFFFFF & (this.readByte() | this.readByte() << 8 | this.readByte() << 16);
    }

    @Override
    public long readUI32() {
        return 0xFFFFFFFFL & (long)this.readSI32();
    }

    @Override
    public short readUI8() {
        return (short)(0xFF & this.readSI8());
    }

    public void setCompress(Header.Compression compression) throws IOException {
        switch (compression) {
            case NONE: {
                break;
            }
            case ZLIB: {
                this.in = new BufferedInputStream(new InflaterInputStream(this.in));
                break;
            }
            case LZMA: {
                this.in = new LZMAInputStream(this.in);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public byte[] readToBoundary() {
        assert (this.readBoundary > 0L) : "Must set boundary before readToBoundary";
        int len = (int)(this.readBoundary - this.offset);
        byte[] result = this.read(len);
        return result;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public void setReadBoundary(long offset) {
        assert (offset > 0L) : "Read boundary must > 0.";
        this.readBoundary = offset;
    }

    @Override
    public long getReadBoundary() {
        return this.readBoundary;
    }
}

